dnl -*- shell-script -*-

#
# $Id: lam_check_sizeof_struct_stat_members.m4,v 1.1 2000/10/17 12:05:17 jsquyres Exp $
#
# This file is part of the University of Notre Dame implementation of
# LAM/MPI.  See the LICENSE file in the top-level directory for
# license and copyright details.

define(LAM_CHECK_SIZEOF_STRUCT_STAT_MEMBERS,[
# Determine size of members of struct stat
AC_MSG_CHECKING(size of struct stat members)
cat > conftest.c <<EOF
#include <sys/stat.h>
#include <stdio.h>
main()
{
    struct stat foo;
    FILE *f=fopen("conftestval", "w");
    if (!f) exit(1);
    fprintf(f, "%d\n", sizeof(foo.st_dev));
    exit(0);
}
EOF
$CC $CFLAGS -o conftest conftest.c 1>&5 2>&1
if test -s conftest && (./conftest; exit) 2>/dev/null; then
    lam_stat_size=`cat conftestval`
else
    lam_stat_size=0
fi
AC_MSG_RESULT($lam_stat_size)
if test "$lam_stat_size" = "4"; then
    AC_DEFINE(LAM_STAT_MEMBERS_INT4, 1)
else
    AC_DEFINE(LAM_STAT_MEMBERS_INT4, 0)
fi
/bin/rm -f conftest*])dnl
