/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	$Id: flatreq.h,v 6.6 1999/06/16 05:54:51 jsquyres Exp $
 *
 *	Function:	- constants and structures associated
 *			  with the flat server
 */

#ifndef _FLATREQ_H
#define _FLATREQ_H

#include "lam_config.h"
#include "net.h"
#include "portable.h"
#include "preq.h"

/*
 * constants
 */
#define FLPATHLEN	96			/* load file path length */
#define FLMAX		256
#define	EMPTY		((char *) 0)

/*
 * request codes
 */
#define FLQLOAD		1
#define FLQGET		2
#define FLQFORGET	3
#define FLQDONE		4
#define FLQCLEAN	5

/*
 * request template
 */
struct flreq {
	int4		flq_src_node;
	int4		flq_src_event;
	int4		flq_req;
	int4		flq_parm1;
#define flq_tag		flq_parm1
#define flq_pid		flq_parm1
	int4		flq_parm2;
#define flq_malength	flq_parm2
#define flq_dseg	flq_parm2
	int4		flq_parm3;
#define flq_ldlength	flq_parm3
};

/*
 * reply template
 */
struct flreply {
	int4		flr_reply;
};

/*
 * flat table entry
 */
struct flregion {
	int4		fl_tag;			/* identifying tag */
	int4		fl_status;		/* status flag */
	int4		fl_src_event;		/* sender's -pid */
	int4		fl_src_node;		/* sender's nodeid */
	int4		fl_byteswritten;	/* how many so far */
	char		*fl_addr;		/* flatted file name */
};

#ifdef __cplusplus
extern "C" {
#endif

extern int		rflat __ARGS((int4, char *, int4, int4, int4));
extern int		rflatv __ARGS((int4, char **, struct penv *,
    					int4 *, int4 *));
extern int		rflclean __ARGS((int4, int4));
extern char		*rget __ARGS((int4, int4));

#ifdef __cplusplus
}
#endif

#endif /* _FLATREQ_H */
