/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1994 The Ohio State University
 *	GDB
 *
 *	$Id: kdoom.c,v 6.4 1999/09/10 05:20:24 jsquyres Exp $
 *	
 *	Function:	- delivers a signal to a process
 *	Accepts:	- process identifier (0 means self)
 *			- signal number
 *	Returns:	- 0 or ERROR
 */

#include <kio.h>
#include <kreq.h>
#include <terror.h>
#include <typical.h>

/*
 * external variables
 */
extern struct kio_t	_kio;			/* kernel I/O block */

/*
 * external functions
 */
extern int		_cipc_kreq();		/* make kernel request */
extern void		_ksig_follow();		/* check signals */

int
kdoom(pid, signal)

int			pid;
int			signal;

{
	struct kreq	req;			/* kernel request */
	struct kreply	reply;			/* kernel reply */

	if (signal < 1) {
		if (kill(pid, -signal)) {
			return(ERROR);
		}
	} else {
/*
 * Check the signal number bounds.
 */
		if (signal > TNSIG) {
			errno = EINVAL;
			return(ERROR);
		}
/*
 * Formulate the KQDOOM kernel request.
 */
		LAM_ZERO_ME(req);
		LAM_ZERO_ME(reply);
		req.kq_req = KQDOOM;
		req.kq_index = _kio.ki_index;
		req.kq_pid = pid;
		req.kq_signal = sigmask(signal);

		if (_cipc_kreq(&req, &reply)) {
			return(ERROR);
		}
/*
 * Check signals.
 */
		if (reply.kr_signal) {
			_kio.ki_signal |= reply.kr_signal;
			_ksig_follow();
		}

		if (reply.kr_reply) {
			errno = reply.kr_reply;
			return(ERROR);
		}
	}

	return(0);
}
