/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log: rbfparms.c,v $
 *	Revision 6.2  1999/05/26 21:49:59  kmeyer1
 *	
 *	added copyright
 *	
 *	Revision 6.1  1996/11/24 00:25:50  nevin
 *	Ohio Release
 *	
 * Revision 6.0  96/02/29  14:04:56  gdburns
 * Ohio Release
 * 
 * Revision 5.2.1.1  96/02/16  01:53:02  gdburns
 * Remove user space buffer parameter.
 * 
 * Revision 5.2  94/08/22  14:13:26  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:58:02  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:46:11  gdburns
 * Ohio Release
 * 
 *	Function:	- controls buffer parameters
 */

#include <unistd.h>

#include <bfreq.h>
#include <events.h>
#include <ksignal.h>
#include <net.h>
#include <terror.h>
#include <typical.h>

int
rbfparms(node, parms)

int4			node;
struct bfparms		*parms;

{
	struct nmsg	nhreq;		/* request message */
	struct nmsg	nhreply;	/* reply message */
	struct bfreq  	*request;	/* bufferd request */
	struct bfreply  *reply;		/* bufferd reply */
	int4		mask;		/* signal mask */

	request = (struct bfreq *) nhreq.nh_data;
	request->bfq_req = BFQSPACE;
	request->bfq_src_node = (node == LOCAL) ? node : getnodeid();
	request->bfq_src_event = -getpid();
	request->bfq_maxspace = parms->bfp_maxspace;

	nhreq.nh_node = node;
	nhreq.nh_event = EVBUFFERD;
	nhreq.nh_type = DLCTL;
	nhreq.nh_flags = NOBUF;
	nhreq.nh_length = 0;
	nhreq.nh_msg = 0;

	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));

	if (nsend(&nhreq)) {
		ksigsetmask(mask);
		return(LAMERROR);
	}

	nhreply.nh_event = -getpid();
	nhreply.nh_type = 0;
	nhreply.nh_flags = 0;
	nhreply.nh_length = 0;
	nhreply.nh_msg = 0;

	if (nrecv(&nhreply)) {
		ksigsetmask(mask);
		return(LAMERROR);
	}

	ksigsetmask(mask);

	reply = (struct bfreply *) nhreply.nh_data;

	if (reply->bfr_reply) {
		errno = reply->bfr_reply;
		return(LAMERROR);
	}

	return(0);
}
