/*                                                                                                            
 * Copyright (c) Members of the EGEE Collaboration. 2004.
 * See http://eu-egee.org/partners/ for details on the copyright holders.
 * For license conditions see the license file or
 * http://eu-egee.org/license.html
 */

/*
 *   Copyright (c) 2003 EU DataGrid        http://www.eu-datagrid.org/
 *
 *   $Id: pdl_yacc.y 17546 2014-02-27 13:40:10Z msalle $
 *
 *   Copyright (c) 2003 by
 *      G.M. Venekamp <venekamp@nikhef.nl>
 *      NIKHEF Amsterdam, the Netherlands
 *
 *   This software is distributed under a BSD-style open source
 *   licence. For a complete description of the licence take a look
 *   at: http://eu-datagrid.web.cern.ch/eu-datagrid/license.html
 *
 */


%{
/*
 *   Copyright (c) 2002 EU DataGrid        http://www.eu-datagrid.org/
 *
 *
 *   Author:  G.M. Venekamp  (venekamp@nikhef.nl)
 *
 *
 *   This software is distributed under a BSD-style open source
 *   licence. For a complete description of the licence take a look
 *   at: http://eu-datagrid.web.cern.ch/eu-datagrid/license.html
 *
 */


#include <stdlib.h>
#include <string.h>

#include "evaluationmanager/pdl.h"
#include "evaluationmanager/pdl_variable.h"
#include "evaluationmanager/pdl_policy.h"
#include "evaluationmanager/pdl_rule.h"
%}

%union {
  record_t* record;
  rule_t*   rule;
};

%token<record> LABEL PATH TERM TRANS EMPTYLINE COMMENT PVAR STRING
%type<record>  config var_list var policy_list string
%type<rule> policy rule;

%token_table

%nonassoc LABEL

%%

config:   /*  empty  */           { lcmaps_pdl_warning(PDL_WARNING, "Config file is empty."); }
        | var_list policy_list
        | policy_list
	| var_list                { lcmaps_pdl_warning(PDL_ERROR, "Config file contains no policy rules."); }
;

var_list:   var
          | var_list var
;

var:   PVAR '=' PATH                      { lcmaps_set_path($3);         }
     | PVAR '='                           { lcmaps_pdl_warning(PDL_INFO, "Empty value assigned to path: ignoring this line.");
                                            lcmaps_set_path(NULL);       }
     | TERM '=' string                    { lcmaps_add_variable($1, $3); }
     | TERM '=' TERM                      { lcmaps_add_variable($1, $3); }
;

string:   STRING                          { $$ = $1;                     }
        | string STRING                   { $$ = lcmaps_concat_strings_with_space($1, $2); }
;

policy_list:   LABEL policy               { lcmaps_add_policy($1, $2); }
             | policy_list LABEL policy   { lcmaps_add_policy($2, $3); }
             | policy_list LABEL          { lcmaps_pdl_warning(PDL_WARNING, "expecting rule definitions.");
                                            lcmaps_pdl_warning(PDL_WARNING, "no rules specified for policy: '%s' at line %d.", $2->string, $2->lineno);
                                            lcmaps_remove_policy($2);
                                          }
             | LABEL                      { lcmaps_pdl_warning(PDL_WARNING, "expecting rule definitions.");
                                            lcmaps_pdl_warning(PDL_WARNING, "no rules specified for policy: '%s' at line %d.", $1->string, $1->lineno);
                                            lcmaps_remove_policy($1);
	                                  }
;

policy:   rule                            { $$ = $1; }
        | policy rule                     { $$ = $1; }
;

rule:   TERM TRANS TERM                   { $$ = lcmaps_add_rule($1, $3,  0); }
      | TERM TRANS TERM '|' TERM          { $$ = lcmaps_add_rule($1, $3, $5); }
      | '~' TERM TRANS TERM               { $$ = lcmaps_add_rule($2,  0, $4); }
;

%%

void lcmaps_set_yylval(record_t* r) {
  yylval.record = r;
}

/* Our pdl_yyparse() is just a wrapper around yyparse() */
int pdl_yyparse (void)	{
    return yyparse();
}
