/* this is the brisby fancy string */
#ifndef __str_h
#define __str_h

#include "error.h"

/* strange quirk of gcc? */
#define str_init(s) do { s[0].buf=0;s->used=0; str_need(s,1); s->buf[0] = 0; } while (0)

struct str_s {
	char *buf;
	int used;
};

typedef struct str_s str_t[1];

#define str(x) x->buf

#include <string.h>
#include <stdlib.h>
#include <ctype.h>

/* Clib */
#define __str_clen(s) strlen(s)

static void inline str_need(str_t p, int tot)
{
	if (tot > p->used) {
		/* Clib */
		p->buf = realloc(p->buf, tot);
		if (!p->buf) {
			cfatal("str_need:realloc: %s");
		}
		p->used = tot;
	}
}
static void inline str_needplus(str_t p, int amu)
{
	str_need(p, __str_clen(str(p))+amu);
}
#define str_chop(s) str_chopn(s, 1)
static void inline str_chopn(str_t p, int bytes)
{
	register int i = __str_clen(str(p)) - (bytes);

	if (i > 0)
		p->buf[i] = 0;
}

#define str_catstr(a,b) str_cat(a,str(b))
#define str_catbstr(a,b,c) str_catb(a,str(b),c)
static void inline str_cat(str_t p, char *s) {
	str_needplus(p, __str_clen(s)+1);
	/* Clib */
	strcat(p->buf, s);
}
static void inline str_catb(str_t p, char *s, int len) {
	str_needplus(p, len+1);
	/* Clib */
	strncat(p->buf, s, len);
}

#define str_copystr(a,b) str_copy(a,str(b))
static void inline str_copy(str_t p, char *s) {
	str_need(p, __str_clen(s)+1);
	/* Clib */
	strcpy(p->buf, s);
}

static void inline str_uc(char *s) {
	register int i;
	for (i = 0; s[i]; i++) {
		/* Clib */
		s[i] = toupper(((unsigned int)s[i]));
	}
}
static void inline str_lc(char *s) {
	register int i;
	for (i = 0; s[i]; i++) {
		/* Clib */
		s[i] = tolower(((unsigned int)s[i]));
	}
}

/* Clib */
#define str_ucfirst(s) (s[0] = touppwer(s[0]))
#define str_lcfirst(s) (s[0] = tolower(s[0]))

static void inline str_addch(str_t p, int ch) {
	char b[2];

	b[0] = ch; b[1] = '\0';
	str_cat(p, b);
}

static int inline str_len(str_t p) {
	return __str_clen(str(p));
}

#define str_equal(a,b) (!str_diff(a,b))
#define str_equali(a,b) (!str_diffi(a,b))
#define str_diffni(a,b,l) (!str_diffin(a,b,l))
#define str_start(a,b) (!str_diffn(a,b,__str_clen(b)))
#define str_starti(a,b) (!str_diffin(a,b,__str_clen(b)))
#define str_startn(a,b,l) (!str_diffn(a,b,l))
#define str_startni(a,b,l) (!str_diffin(a,b,l))
#define str_startin(a,b,l) (!str_diffin(a,b,l))
static int inline str_diff(char *a, char *b) {
	/* Clib */
	return strcmp(a, b);
}
static int inline str_diffn(char *a, char *b, int l) {
	/* Clib */
	return strncmp(a, b, l);
}
static int inline str_diffi(char *a, char *b) {
	/* Clib */
	return strcasecmp(a,b);
}
static int inline str_diffin(char *a, char *b, int l) {
	/* Clib */
	return strncasecmp(a,b, l);
}
static char inline *str_dup(char *s)
{
	str_t p;

	str_init(p);
	str_copy(p, s);

	return str(p);
}
static int inline str_chtoi(int ch)
{
	switch (ch) {
	case '1': return 1;
	case '2': return 2;
	case '3': return 3;
	case '4': return 4;
	case '5': return 5;
	case '6': return 6;
	case '7': return 7;
	case '8': return 8;
	case '9': return 9;
	};
	return 0;
}

#endif
