# $Id: leakbug.spec.in,v 1.8 2001/11/26 00:39:42 chipx86 Exp $

%define name    leakbug
%define ver     0.1.4
%define RELEASE 1
%define rel     %{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}
%define prefix  /usr
%{expand:%%define share %(if [ -d %{prefix}/share/man ]; then echo /share ; else echo %%{nil} ; fi)}
%ifos linux
%define CONFIG_FLAGS --prefix=%prefix --infodir='%{prefix}%{share}/info' --mandir='%{prefix}%{share}/man'
%else
%define CONFIG_FLAGS --prefix=%prefix
%endif

Summary:      A small library for detecting memory leaks within a program.
Name:         %name
Version:      %ver
Release:      %rel
Copyright:    LGPL
Group:        Development/Debuggers
Source:       ftp://ftp.gnupdate.org/pub/gnupdate/tarballs/leakbug/%{name}-%{version}.tar.gz
URL:          http://www.gnupdate.org/
Prefix:       %prefix
BuildRoot:    /var/tmp/%{name}-%{version}-root
Packager:     Christian Hammond <chipx86@portaldesign.net>

%description
Detects leaks generated by the program's calls to malloc(), strdup(), etc.
It does not detect leaks generated by outside libraries. The dmalloc
library (http://www.dmalloc.org/) should be used for this purpose.


%package      devel
Summary:      Headers for developing programs that use leakbug.
Group:        Development/Debuggers
Requires:     %name = %{PACKAGE_VERSION}

%description  devel
This package contains the header files that programmers would use to
develop programs that use the leakbug library.

%prep
%setup

%build
if [ ! -z "`echo -n ${RPM_OPT_FLAGS} | grep pentium`"]; then
	if [ ! -z `which egcs` ]; then
		CCC="egcs"
	else
		if [ ! -z `which pgcc` ]; then
			CC="pgcs"
		fi
	fi
	CFLAGS="${RPM_OPT_FLAGS}"
else
	CFLAGS="${RPM_OPT_FLAGS}"
fi

#if [ ! -f configure ]; then
	CFLAGS="$RPM_OPT_FLAGS" ./autogen.sh --prefix=%prefix
#else
#	CFLAGS="$RPM_OPT_FLAGS" ./configure --prefix=%prefix
#fi

make

%install
rm -rf $RPM_BUILD_ROOT
make DESTDIR=$RPM_BUILD_ROOT install
#gzip -n -9f $RPM_BUILD_ROOT%{prefix}%{share}/info/leakbug.info*

%clean
rm -rf $RPM_BUILD_ROOT

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%post devel
#/sbin/install-info %{prefix}%{share}/info/leakbug.info.gz %{prefix}%{share}/info/dir

%preun devel
#if [ $1 = 0 ]; then
#	/sbin/install-info --delete %{prefix}%{share}/info/leakbug.info.gz %{prefix}%{share}/info/dir
#fi

%files
%defattr(-, root, root)

%{prefix}/lib/lib*.so.*

%doc AUTHORS
%doc COPYING
%doc ChangeLog
%doc NEWS
%doc README

%files devel
%defattr(-, root, root)

%doc docs/api/html
%{prefix}/lib/lib*.so
%{prefix}/lib/*.a
%{prefix}/lib/*.la
%{prefix}/include/*
%{prefix}/share/aclocal/*
%{prefix}%{share}/man/man1/*
%{prefix}%{share}/man/man3/*
#%{prefix}%{share}/man/leakbug.info*

##########################################################################

%changelog
* Sun Nov 25 2001 Christian Hammond <chipx86@portaldesign.net>
- Bumped the version up to v0.1.4.

* Mon Aug 13 2001  Christian Hammond <chipx86@portaldesign.net>
- Bumped the version up to v0.1.3.

* Thu Jul 12 2001  Christian Hammond <chipx86@portaldesign.net>
- Bumped the version up to v0.1.2.

%changelog
* Sun May 13 2001  Christian Hammond <chipx86@portaldesign.net>
- Created the first version of this leakbug.spec

