/* VERSION: 20000111-00 */
/*
 * This is the file with the definitions of LineControl packets
 * and commands. For detailed information ask S. Fuchs <sfuchs@gmx.net>
 * Probably you need only the LC_ and the LCC_ definitions. The LCS_
 * are for LineControl Servers.
 *
 * If you don't like this code-style: tell me HOW to do better.
 * I don't like sentences like: "... is not good." or "... shouldn't be done."
 *
 * Well, enjoy coding. I've put this file under the GPL on 17. Sep 1999
 *
 * have now a look at the 3 structs at the end of this file to know what
 * I'm talking about. Then continue here with parsing... :)
 * attention: the structs and their variables are 4-byte aligned
 *            but no rule without exceptions! :)
 *            gcc and Visual C++ do it right with the below declared structs.
 *
 * 20000111: added CMD_SHUTDOWN, you have to define _LCS_SHUTDOWN_OK in srv_def.h
 *           to enable the LineControl Server to make use of it.
 *           Per default this is not defined (no support due to bad authentification).
 * 19991121: added 3 commands: CMD_ADDCHAN, CMD_RMCHAN, CMD_BADCHANOP (for isdn connections)
 * 19990908: byte - offsets for structs added. Tested them with a tiny
 *           pascal program.
 * 19990907: defines that are only for my DialServer have been moved to
 *	     another file.
 *	     CBR_THROUGHPUT description added.
 *	     CMD_TIMER and CMD_TIME_OVER removed, are now invalid commands.
*/

#include <time.h>

/*
 default settings for LineControl server and client
*/

#ifndef _LC_COMMON
#define _LC_COMMON

// LCS means 'LineControl Server'
// DCC means 'LineControl Client'

// #define STAY_TTY			// don't become daemon and print msgs to stderr ifdef!

#define LC_RETRANSMIT		4	// retransmit t_order packet after
					// .. secs if t_ack pack not recieved.
#define LC_ACK_CNT		3	// give up waiting for CMD_ACK after x*LC_ACK_WAITQ
#define LC_ABORT		3	// give up after .. retransmissions
#define LC_ACK_WAITQ		10	// secs to wait until next try
#define LCC_MIN_TIMEOUT		1*60	// minimum for client_t.interval
#define LCC_DEFAULT_TIMEOUT	3*60	// time after which client gets thrown out.
#define LCC_MAX_TIMEOUT		5*60	// maximum timeout-value (interval)
		// the timeout of a client is included in
		// ((struct p_order_t*)pack)->interval
		// set pack.interval of a CMD_REG to the desired value or
		// to 0 for default.
#define LCS_PORT                16007
#define LC_MAGIC_NR		654760132
#define LC_PACKET_VERSION	2
#define LC_MAX_MSG_LEN	100	// if there's no message to send, so set
	// p_order_t.msglen to 0 and ommit the msg. So the packet size is
	// length = sizeof(struct p_order_t) - LC_MAX_MSG_LEN;

/* definition of commands ------*/
/* The stati of your client can be the following:
 * - not registered (the server doesn't know you)
 * - registered (the server knows your port & ip, but no internet-connection
 *   get's established until an other one asks for it.)
 * - online (as long as you're marked as online, the connection won't get
 *   killed.)
 *
 * it's always the same:
 * 1. CMD_REG, wait for CMD_ACK, then for CMD_REGISTERED (or an error... see later)
 * 2. CMD_DIAL, wait for CMD_ACK, then wait for a CMD_ that indicates the status
 *    of the connection. You may ask for a server-status by sending CMD_STAT_REQ
 * 3. surf till your modem smokes... make sure to send CMD_REFRESH regularly :)
 * 4. send CMD_OFFLINE (or try CMD_BYE directly), wait for CMD_ACK
 * 5. send CMD_BYE if not done yet.
 *
 * ask for a server-status by sending CMD_STAT_REQ as soon as you're registered
 * to tell the user about the internet-connection-status
 * ( = connection-status = con_stat: defined as CST_* ) because you won't get
 * any CBR_CON_UP (server sends this as soon as the connection gets up).
*/
/* from client to server */
#define CMD_REG		1	// just register, don't dial
#define CMD_DIAL	2	// dial if connection is not up yet
#define CMD_BYE		3	// removes client from 'online-list'
#define CMD_OFFLINE	4	// after this cmd, client will be regged but not online
#define CMD_REFRESH	5	// will renew clients timeout-timer on server-side
#define CMD_STAT_REQ	6	// server will answer with CMD_ACK and then send
				// another packet with t_server_status included
				// in t_order.msg witch has to be acked from client.
#define CMD_ADDCHAN	7	// calls 'server->isdn_channel_op' - script with parameter add
#define CMD_RMCHAN	8	// calls 'server->isdn_channel_op' - script with param rm
#define CMD_SHUTDOWN	9	// calls 'server->script_shutdown',
				// does neither shutdown server nor kick clients!
				// this will be done on SIGQUIT or SIGTERM
				// (belongs to LineControl Server for Linux 2.5.3 and up.)
				// if there's no support, server returns CMD_INVALID
				// on success the client gets a CMD_UNREG

/* from server to client */
#define CMD_CON_ERROR	1000	// not able to establish connection
#define CMD_REG_ERROR	1002	// not able to register client in 'online-list'
#define CMD_REFUSED	1003	// this client is not allowed to have done the last CMD
#define CMD_INVALID	1004	// unknown/invalid command/packet
#define CMD_REGISTERED	1006	// OK, you're now regged... but not online!
#define CMD_ALR_REGGED	1007	// already regged!
#define CMD_KICK	1010	// normally timeout, maybe too many errors
#define CMD_SRV_STAT	1012	// msg contains server_status_t
#define CMD_NOT_REGGED	1013	// reg yourself and then send another cmd!
#define CMD_CLOSING	1014	// closing con, can't establish it at the
				// same time!!
#define CMD_UNREG	1015	// when client gets unregged after a CMD_BYE
#define CMD_BADCHANOP	1016	// CMD_ADDCHAN or CMD_RMCHAN failed or nothing has been executed
#define CMD_YOUROFFLINE	1017	// the client is set to 'offline' ('regged')

/* bidirectional */
#define CMD_INFO 	2000	// informational messages for the user
				// PopUp-Window suggested
#define CMD_ACK		2001	// answer to t_order packet
#define CMD_ERROR	2002	// general error, if sent by client, it will be kicked out

/* broadcast from server to clients */
/* CBR: command broadcast */
#define CBR_INFO	3000	// every cmd >= this one mustn't be ACKed!!
				// if sent as command, it is the same as
				// CMD_INFO but is sent to all clients
#define CBR_TERMED	3001	// server shutting down.
#define CBR_KILLED	3002	// server shutting down, leaving link as is.
#define CBR_CON_CLOSED	3003	// connection closed
#define CBR_CON_UP	3004	// connection is up.
#define CBR_LEFT_OPEN	3005	// server terminated, but connection not closed.
#define CBR_CON_DIED	3006	// connection died... client has to dial again. no auto dialing
#define CBR_CLOSE_ERROR	3007	// error while closing connection
#define CBR_USER_CLOSED 3008	// user closed self opened connection
				// (server was not involved!)
#define CBR_USER_UP	3009	// a user dialed, server not involved
#define CBR_THROUGHPUT	3010	// throughput in bytes per sec
    // msg[0] : received, total average
    // msg[1] : sent, total average
    // msg[2] : received, period = 1 loop
    // msg[3] : sent, period = 1 loop
    // msg[4] : total received in bytes
    // msg[5] : total sent in bytes
    // msg[6] : secs connection is up. con_up_time
    // gets sent every 2 or 3 secs... (loop)

/* Connection - STatus ( CST_ ) */
#define CST_DOWN	0
#define CST_DIALING	1
#define CST_UP_SERVER	2	// server called the con_up script
#define CST_UP_USER	3	// connection wasn't established by server
				// but is up anyway. Server won't kill con!!
#define CST_CLOSING	4
#define CST_CLOSE_ERROR	5	// not able to close connection!!

/*****  PACKET DEFINITIONS *****/

/* !! watch alignements !! */
struct p_order_t {
 unsigned int magic;		//  4	+ 0
 unsigned short version;	//  2	+ 4
 void *id;			//  4	+ 8
 short cmd;			//  2	+12
 int interval;			//  4	+16
 unsigned int dum; // = 0;	//  4	+20
 short msglen;			//  2	+24
 char msg[LC_MAX_MSG_LEN+1];	//  n	+26  <---
};

/* the first 4 entries (until cmd) have to be the SAME as in t_order! */
/* !! watch alignements !! */
struct p_ack_t {
 int magic;		// 4	+0
 short version;		// 2	+4
 void *id;		// 4	+8
 short cmd;		// 2	+12	has to be set to command.ack
 short ackcmd;		// 2	+14	the cmd that has to be acknowledged
};

/* !! watch alignements !! */
struct server_status_t {	// will be sent in p_order_t.msg
 unsigned short clients;	// 2	+0	number of registered clients
 unsigned short online;		// 2	+2	num of cl. that are online
 char con_stat;			// 1	+4	connection-status, see CST_*
 char channels;			// 1	+8	used b-channels (isdn, analog = 1)
 int ordq_nr;			// 4	+12	has to be filled in when needed
 int ackq_nr;			// 4	+16	has to be filled in when needed
 int srv_con_time;              // 4	+20	seconds since server has opened connection
 int clt_con_time;              // 4	+24	secs since client went online
 time_t con_up;                 // 4	+28	when srv opened connection (int 32)
 unsigned short buf[3];         // n*2	+32	currently unused... padding
};

#endif   /* _LC_COMMON */
