#include "srv_def.h"
#if HAVE_LIBCRYPT
#define _XOPEN_SOURCE	// else we can't use crypt()
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <syslog.h>
#include <arpa/inet.h>
#include "global_vars.h"
#include "ipvalidator.h"

#define USER_MAX_LINESIZE	1020

int vrfy_user(const char *name, const char *pass)
// 0 if valid, else -1, -2 on error
{
    register char *idx;
    FILE *passfile;
    char *linebuf;
    int got;
    char *namef;
    char *passf = NULL;	// remove a compiler warning... :)
    char *passu;
    char passc[14];
    char salt[3];
    char usrfound = 0;
//    fprintf(stderr, "looking for accounts in %s\n", server.passwd_file);
    if ( !(passfile = fopen(server->passwd_file, "r")) )
    {
	syslog(LOG_ERR, "cannot open password-file!");
	return(-2);
    }
    if ( !(linebuf = malloc(USER_MAX_LINESIZE+4)) )
    {
	fclose(passfile);
	syslog(LOG_ERR, "memory exhausted!");
	return(-2);
    }
    got = 1;	// give it at least a chance :)
    while ( (!usrfound) && got )
    {
	idx = linebuf;
	while (    (got = fread(idx, 1, 1, passfile))
	        && (idx - linebuf <= USER_MAX_LINESIZE) )
	{
	    if ( *idx == 10 ) break;
	    else if ( *idx == 13 ) break;
	    idx++;
	}
	*idx = 0;
	if ( idx - linebuf <= 2 ) continue;	// such lines don't exist
	/* comes from characters 10/13, but only 13 should exist in
	   passwd/shadow
	 */
	/* now we got a full line */
	namef = strtok(linebuf, ":");
	passf = strtok(NULL, ":");	// encrypted passwd from file
	salt[0] = *passf; salt[1] = passf[1]; salt[2] = 0;
	if ( strcmp(name, namef) == 0 ) usrfound++;
    }
    fclose(passfile);
    if ( !usrfound )
    {
	//fprintf(stderr, "user '%s' not found.\n", name);
	free(linebuf);
	return(-1);	// no such user in file
    }
    passu = crypt(pass, salt);
    memcpy(passc, passu, 13);
    passc[13] = 0;	// so we have our own string...
    got = strcmp(passf, passc);
    free(linebuf);
    if ( !got )
    {
#ifdef DEBUG
	syslog(LOG_DEBUG, "user %s supplied correct passwd.", name);
#endif
	return(0);
    }
    return(-1);
}

#ifdef SHUTDOWN_OK
int shutdown_allowed(struct client_t*who)
{
    struct sockaddr_in saddr;
    saddr.sin_addr.s_addr = who->ip;
    saddr.sin_family = AF_INET;
    saddr.sin_port = who->port;
    syslog(LOG_INFO, "SHUTDOWN: checking only against IP (+user-accounting if enabled)!");
    return(validate_ip(server->shtdn_ipl_type, &shtdn_ipl, &saddr));
}
#endif //SHUTDOWN_OK
#endif // HAVE_LIBCRYPT
