/***************************************************************************
                          cdisplay.cpp  -  description
                             -------------------
    begin                : Sat Mar 18 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *    based on the work of  Moe Wheatly, AE4JY                             *  
 ***************************************************************************/


#include "cdisplay.h"
#include <qpixmap.h>

CDisplay::CDisplay(QWidget *parent, const char *name ): QFrame(parent,name)

{

modus = BPSK;
setBackgroundColor(white);
setFrameStyle(QFrame::Box | QFrame::Raised);
setLineWidth(2);


minfreq=300;
maxfreq=2500;
from=int((minfreq*1024)/2756.25);
to=int((maxfreq*1024)/2756.25);


for (int i=0; i<4;i++)
	rxfrequency[i]=1000;
slow=FALSE;

pdisplay = 0;
pwaterfall=0;


}

CDisplay::~CDisplay()
{
}

void CDisplay::paintEvent(QPaintEvent *)
{

 int ave;
 double gain;


  switch(akttab)
 {
	case INPUT:
		plotrawinput();
   break;
	case SPECTRUM:
  if (slow)
		ave=6;
	else
		ave=2;
  gain=double(0.1*height());
	plotspectrum(fft.CalcFFT(inputdata,from,to,gain,ave,fftdata));
	break;
	case WATERFALL:
	gain=25.5;
	if (slow)
		ave=4;
	else
		ave=1;
	plotwaterfall(fft.CalcFFT(inputdata,from,to,gain,ave,fftdata));
	break;
/*  case SYNC:
	  PlotSyncData();
		break;*/
	
	default:
		break;
 }
	
}

void CDisplay::mousePressEvent(QMouseEvent *e)

{

int freq;

switch(akttab)
 {
	case SPECTRUM:				//Changing frequency only if frequency is displayed
  case WATERFALL:
		freq= (e->x()*(maxfreq-minfreq))/width()+minfreq;

			if (freq != rxfrequency[settings.actChannel])
 			{
  		rxfrequency[settings.actChannel]=freq;
			emit rxFreqChanged(freq);
 			}
		break;
	default:
	break;
 }
}

void CDisplay::plotrawinput()
{

int i,dist,y,z;
QPainter p;
bool overload;

overload= FALSE;

dist=ymax/10;

pdisplay->fill();
p.begin(pdisplay);
p.setPen(black);
p.setBrush(white);
//drawFrame( &p);
y=ymax-dist;
// Plot Grid
for (i=1;i<10; i++)
	{
   p.drawLine(0,y,xmax,y);
   y -=dist;
  }
p.setPen(blue);
// Plot sample
y=ymax/2;
p.moveTo(0,y);
for (i=0;i<xmax;i++)
	{
		z=int(*(inputdata+i));
		if(!overload)
			{
			 if( (z > 16384) || (z < -16384) )
			  {
				 overload = true;
				 p.setPen(red);
				}
			 }
		 z=y-(y*z)/32768;
		 p.lineTo(i,z);
    }

p.end();
bitBlt(this,0,0,pdisplay);
}
// Plot Spectrum of decimated Input
void CDisplay::plotspectrum(bool overload)
{

QPainter p;



int i,dist,y,z;

dist=ymax/10;
y=ymax-dist;

pdisplay->fill();
p.begin(pdisplay);
p.setBrush(white);
drawFrame(&p);

//Plot Frequencylines for the different Rx- Windows
for (i=0; i<settings.RxChannels;i++)
	{
		p.setPen(settings.colours[i]);
		// Calculate Centerfrequency Coordinates
		z=((rxfrequency[i]-minfreq)*xmax)/(maxfreq-minfreq);
		p.drawLine(z,0,z,ymax);

		if ( settings.DemodulatorType[i] == RTTY ) // RTTY demands to lines
			{
				z=((rxfrequency[i]-minfreq+170)*xmax)/(maxfreq-minfreq);
				p.drawLine(z,0,z,ymax);    	
			}
	}
p.setPen(black);
				
// Plot Grid
for (i=1;i<10; i++)
	{

   p.drawLine(0,y,xmax,y);
   y -=dist;
  }

if ( (settings.status == TX_OFF_STATE) && (modus != RTTY) )
			 plotVector(&p);

if(overload)
	p.setPen(red);
else
	p.setPen(blue);
  p.moveTo(0,ymax);
for(i=0;i<xmax;i++)
 {
  z=xtranslate[i];
  y=ymax-fftdata[z];
	p.lineTo(i,y);
	}
// paintLineal(&p);
p.end();
bitBlt(this,0,0,pdisplay);
}

void CDisplay::selecttab(int tab)

{
akttab=tab;
}



void CDisplay::scaleminfreq(int freq)
{
minfreq=freq;
translate();
}

void CDisplay::scalemaxfreq(int freq)
{
maxfreq=freq;
translate();
}

void CDisplay::filtertype(bool type)
{
slow=type;
}

void CDisplay::translate(void)
{
int i;
from=int(minfreq*1024/2756.25);
to=int(maxfreq*1024/2756.25);
for (i=0;i<width();i++)
	xtranslate[i]=(((maxfreq-minfreq)*i*to/width())+minfreq*to)/maxfreq;
}

/** plots the filtered signal  vector
to recognize phase of signal */
void CDisplay::plotVector(QPainter *p)
{

int x,y,x1,y1;
double mag;
double tmpx;
double tmpy;


xc=xmax/8;
yc=ymax/8;
p->drawEllipse(xc,yc,40,40);
xc=xc+20;
yc=yc+20;
p->setPen(green);
	for( x=196,y=0; x<10*196; y+=196, x+=196 )// 196 = (612.5/31.25)*10
	{
		x1 = x/10;
		y1 = y/10;
		tmpx =vector[y1].real() * vector[x1].real() +
				vector[y1].imag() * vector[x1].imag();
		tmpy = vector[y1].imag() * vector[x1].real() -
				vector[y1].real() * vector[x1].imag();
		p->moveTo( xc,  yc );
		mag = 2*sqrt(tmpx * tmpx + tmpy * tmpy);

		p->lineTo( xc+(int)(yc*tmpy/mag), yc-(int)(yc*tmpx/mag) );

	}

}

/*void CDisplay::PlotSyncData()
{
QPainter p;
int x,i,k1,k2;
int ys;

	k1 = 13000/ymax;
	k2 = xmax/20;
pdisplay->fill();
p.begin(pdisplay);
p.setPen(black);
p.setBrush(white);
drawFrame(&p);
	
	for( x=k2/2,i=0; i<20; i++,x+=k2)
	{
		ys = m_SyncHist[i]/k1;
		m_SyncHist[i] = 0;
		p.moveTo( x, ymax );
		p.lineTo( x, ymax-ys );
	}
p.end();
bitBlt(this,0,0,pdisplay);
}*/

void CDisplay::plotwaterfall(bool overload)
{

QPainter p;

int i,x,z;

pdisplay->fill();
p.begin(pdisplay);
p.setBrush(white);

for (i=0; i<settings.RxChannels;i++)
	{
		// Calculate Centerfrequency Coordinates
			z=((rxfrequency[i]-minfreq)*xmax)/(maxfreq-minfreq);
				p.setPen(settings.colours[i]);
				p.drawLine(z,2,z,ymax);
		if ( settings.DemodulatorType[i] == RTTY ) // RTTY demands to lines
			{
				z=((rxfrequency[i]-minfreq+170)*xmax)/(maxfreq-minfreq);
				p.drawLine(z,2,z,ymax);    	
			}

		}
p.setPen(black);
if ( (settings.status == TX_OFF_STATE) && (modus != RTTY) )
	plotVector(&p);
drawFrame(&p);
p.end();
bitBlt(pwaterfall,0,2,pwaterfall);

p.begin(pwaterfall);
for (x=2;x<xmax;x++)
 {
	z=xtranslate[x];
	i=fftdata[z];
  p.setPen(color[i]);
	p.drawPoint(x,0);
	p.drawPoint(x,1);
 }
p.end();
bitBlt(pdisplay,0,100,pwaterfall);
bitBlt(this,0,0,pdisplay);
}

void CDisplay::resizeEvent(QResizeEvent *)

{
xmax=width();
ymax=height();
translate();	// Translate x- Coordinates for Painting
if ( pdisplay !=0)
	pdisplay->resize(xmax,ymax);
else
	pdisplay = new QPixmap(xmax,ymax);


pdisplay->fill();

if ( pwaterfall !=0)
	pwaterfall->resize(xmax,40);
else	
	pwaterfall= new QPixmap(xmax,40);
pwaterfall->fill();
}

void CDisplay::setRxFrequency(int channelNumber,int freq)
{
rxfrequency[channelNumber] = freq;
}


void CDisplay::newPhaseValue(int j,float_complex z)
{

 	vector[j]=z;

}
/** Paints a Lineal in the Spectrum or Waterfall Display */

/*void CDisplay::paintLineal(QPainter* p)
{

int stepfrequency,stepwidth;
int i,ix,iy;
QString frequency;
QFontMetrics fm(settings.font);

stepfrequency=(maxfreq-minfreq)/7;
stepwidth=width()/7;
iy=fm.height()+2;

for( i=1; i < 7; i++)
		{
		frequency.setNum(minfreq+stepfrequency*i);
		ix=i*stepwidth-fm.width(frequency)/2;
		p->drawText(ix,iy,frequency);
		ix=i*stepwidth;
		p->drawLine(ix,iy,ix,iy+5);
		}
	
}*/

/** Calculates the IMD Value of the Signal */
float CDisplay::calcIMD()
{
float total,ratio;

total=fftdata[int((rxfrequency[settings.actChannel]+46.875)*1024./2756.25)]
	-fftdata[int((rxfrequency[settings.actChannel]+15.625)*1024./2756.25)];

ratio=fftdata[int((rxfrequency[settings.actChannel]-46.875)*1024./2756.25)]
	-fftdata[int((rxfrequency[settings.actChannel]-15.625)*1024./2756.25)];
total=(total+ratio)/2;
return total;
}

void CDisplay::setMode(Mode mod)
{
modus=mod;
}

