/***************************************************************************
                          crxdisplay.h  -  description
                             -------------------
    begin                : Sun Sep 17 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *   based on the work of Moe Wheatley, AE4JY                              *
 ***************************************************************************/

/**Complete Display of rx- Window and necessary Control elements
  *@author Volker Schroer
  */

#ifndef CRXDISPLAY_H
#define CRXDISPLAY_H

#include <qframe.h>
#include <qradiobutton.h>
#include <qspinbox.h>
#include <qlabel.h>
#include <qbuttongroup.h>
#include <qlayout.h>
#include <qlineedit.h>
#include <qapplication.h>
#include "parameter.h"
#include "csquelch.h"
#include "crxwindow.h"
#include "modeselect.h"


///class CRxdisplay : public QFrame
class CRxdisplay : public QFrame
 {
 Q_OBJECT
public: 
	CRxdisplay(QWidget *parent=0, int channel=0,const char *name=0);

	~CRxdisplay();
	bool SquelchOn();
	Mode mode;							// Mode
	double getRxFrequency();
  /** Changes the color of Text and Labels in  the RXWindow */
  void setColor(QColor);
  /** Draws the widget including Header text */
  void paintEvent(QPaintEvent *e);

	/** Returns the AFC- Setting */
	bool getAFCsetting();

  CRxwindow *rxwindow;

   bool UseAfc;

		QString theircall; //Theircall
		QString Name;

private:

	/** Rx Parameterwindow */
	QGroupBox *rxtune;
  QRadioButton *bafc;
  QSpinBox *rxfreq;
	QGroupBox *TriggerBox;
	QLineEdit *TriggerText;
	QRadioButton *Trigger;
	
 /** Value of Rxfrequency */
 double rxfrequency;		
 int channelNumber; // Number of RxChannel	
 /** Select Mode of Operation, BPSK QPSK*/
	
ModeSelect *Modus;
 /** Squelch */
 CSquelch *Squelch;


	QGroupBox *RecordBox;
	QRadioButton *Debug;


protected:
	void resizeEvent(QResizeEvent *);
	/** Title */
	QString title;
	
public slots:
	void setRxFrequency(double);
	void changerxfreq(int);
	void afc(bool);
	void showchar(char);
 	void setFastSquelch(bool);
	void setSquelchValue(int);
  /** prepares the new TriggerText and passes it to the Trigger detection */
  void newTriggerText();
  /** Signals the TriggerCondition and switches to the appropriate Window */
  void triggered();
  /** clears the content of  the dependent RxWIndow */
  void clearWindow();
  /** sets the Remote callsign for this RxWindow */
  void setTheirCall(const QString &);
  /** set the Name of the remote op for this window */
	void setName(const QString &);


private slots: // Private slots
	/** Signals that the mode has changed for the Channel */
	void ChangedToMode(Mode);
  /** enables/disables Debugging for the Rx window */

  void switchDebug();

	
signals: // Signals
  /** emits this signal if the user changed the cursor
and with it the desired RX- Frequency */
  void rxFrequencyChanged(int,int);

  void ModeChanged(Mode,int);
  void toggleAfc(bool);
  /** signals a new TriggerText */
  void TriggerTextChanged(QString);
  /** emits the number of the Window where the Trigger happend*/
  void triggeredWindow(int);

};

#endif
