#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "grubconf.h"
#include "grubconf.m"
#include "grubconf.p"

MODULE_DEFINE_VERSION(grubconf);

PUBLIC MODULE_grubconf::MODULE_grubconf()
	: LINUXCONF_MODULE("grubconf")
{
	linuxconf_loadmsg ("grubconf",PACKAGE_REV);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_grubconf::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_BOOT){
		keymenu = MSG_U(M_grubconf,"Grub");
		dia.new_menuitem ("boot","",keymenu);
	}
}

PUBLIC int MODULE_grubconf::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_BOOT){
		if (key == keymenu){
			grubconf_edit();
		}
	}
	return 0;
}


PUBLIC int MODULE_grubconf::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"grubconf")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"linuxconf --modulemain grubconf usage\n"
		 "\n"
		 "    grubconf --option ...\n")
		);
}

PUBLIC void MODULE_grubconf::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_grubconf::message (const char *msg, int argc, const char *argv[])
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(msg,"about")==0) {
                SSTRINGS *tb = (SSTRINGS*)argv[0];
                tb->add (new SSTRING(MSG_U(X_ABOUT,"Module grubconf was written by Gustavo Niemeyer (niemeyer@conectiva.com)")));
	}
	return ret;
}

PUBLIC int MODULE_grubconf::execmain (int argc , char *argv[], bool standalone)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"grubconf")==0){
		ret = -1;
		if (argc == 1){
			grubconf_edit();
		}else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}


static MODULE_grubconf grubconf;

