// vim: nowrap

/* ***********

Module: Isapnpconf
Created: 15/05/2000
Last Modified: 19/06/2000
Author: Cristiano Otto Von Trompczynski
e-mail: cris@conectiva.com.br
Description: Functions responsible by reading and writing in a file information of a linuxconf API mcontainer called SSTRINGS.
Other functions responsible by backup and file generation are also included in this file.
                                                                                                      "This module is for you, Penguin!"
   
   ***********
*/

#pragma implementation
#include <string.h>
#include <sys/stat.h>
#include <popen.h>
#include <stdlib.h>
#include "isapnpconf.h"

/*
PUBLIC int MODULE_isapnpconf::backup_file ()
  Responsible by generating a backup of the 'isapnp.conf' file named 'isapnp.bkp'
RETURN: ERROR4 - error trying open/close file
         OK     - is success
*/
PUBLIC int MODULE_isapnpconf::backup_file (){
	FILE *fsrc=NULL;
       	FILE *fdest=NULL;
	const char *fileor=cf_pnp.getpath();
	const char *filedest="/etc/isapnp.bkp";
	if ( !(fsrc=fopen (fileor,"r")) || !(fdest=fopen (filedest,"w")) ){
		fclose (fsrc);
		fclose (fdest);
		return ERROR4;
	}
	
	char buffer[1024];
	fgets (buffer, 1023, fsrc);
	while(!feof(fsrc)){
		fwrite (buffer, 1, strlen(buffer), fdest);
		fgets (buffer, 1023, fsrc);
	};
	fclose (fsrc);
	fclose (fdest);
	return OK;
}

/*
PUBLIC int MODULE_isapnpconf::rewrite_isapnp ()
  Rewrites the ISAPNP file. Doesn't make Backup.
RETURN: OK - if success
         ERROR - POPEN isn't OK
*/
PUBLIC int MODULE_isapnpconf::rewrite_isapnp (){
	const char *args="-r -c>/etc/isapnp.conf";
	const char *isap="/sbin/pnpdump";
	POPEN pop (isap, args);
	if ( pop.isok() ){
		while (pop.wait(1000,0)==0);
		pop.close();
		return OK;
	}
	pop.close();
	return ERROR;
	
}

/*
PUBLIC int MODULE_isapnpconf::read_file(SSTRINGS &ss)
  Reads the content on the ISAPNP.CONF file to the SSTRINGS container line after line.
RETURN: OK - if success
         ERROR - error trying open/close file
*/
PUBLIC int MODULE_isapnpconf::read_file(SSTRINGS &ss)
{
	if(!cf_pnp.exist()){
		const char *args="-r -c>/etc/isapnp.conf";
		const char *pnpdump="/sbin/pnpdump";
		POPEN pop (pnpdump, args);
		while (pop.wait(100,0)==0);
		pop.close();
	}
	
	FILE_CFG *fin = cf_pnp.fopen ("r");
	if(!(fin)){
	      	xconf_notice (MSG_U(N_COULDNOTOPENFILEREAD,"Couldn't open the file for reading!"));
	       	return ERROR;
       	}
       
	struct stat st;
	if (fstat (fileno(fin),&st)==-1){
		return ERROR;
	}

	char *buf = (char *) malloc (st.st_size+1);
	fread (buf,1,st.st_size,fin);
	buf[st.st_size] = 0;
	char *p, *last_p;
	p = last_p = buf;
	bool eof = false;
        while (!eof){
		switch (*p){
			case '\0':
				eof = true;
			break;
			case '\n':
				SSTRING *s = new SSTRING();
				s->setfrom (last_p, p-last_p);
				ss.add (s);
				last_p = p+1;
				break;
		}
		p++;
	}

	cf_pnp.fclose(fin);
	free (buf);
	return OK;
}

/*
PUBLIC int MODULE_isapnpconf::save_file(SSTRINGS &ss)
  Takes the SSTRINGs content and store in the ISAPNP.CONF file.
RETURN: OK - if success
	 ERROR - if any error while trying open/write file
*/
PUBLIC int MODULE_isapnpconf::save_file(SSTRINGS &ss)
{
	FILE_CFG *fout = cf_pnp.fopen ("w");
	if(!(fout)){
	      	xconf_notice (MSG_U(N_COULDNOTOPENFILEWRITE,"Couldn't open the file for writing!"));
	       	return ERROR;
       	}
	for (int i=0; i<ss.getnb(); i++){
		fprintf(fout,"%s\n",ss.getitem(i)->get());
	}
	cf_pnp.fclose(fout);
	return OK;
}
