#pragma implementation
#include <stdio.h>
#include <unistd.h>
#include <string.h>
#include <translat.h>
#include "managerpm.h"
#include "managerpm.m"
#include <module_apis/package_api.h>

MODULE_DEFINE_VERSION(managerpm);

PUBLIC MODULE_managerpm::MODULE_managerpm()
	: LINUXCONF_MODULE("managerpm")
{
	linuxconf_loadmsg ("managerpm",PACKAGE_REV);
	module_register_api (PACKAGE_API_KEY,PACKAGE_API_REV
		,managerpm_api_get,managerpm_api_release);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_managerpm::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_MAIN_CONTROL){
		keymenu = MSG_U(M_managerpm,"Package management (RPM)");
		dia.new_menuitem ("managerpm","",keymenu);
	}
}

PUBLIC int MODULE_managerpm::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_MAIN_CONTROL){
		if (key == keymenu){
			mngrpm_menu();
		}
	}
	return 0;
}


PUBLIC int MODULE_managerpm::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"managerpm")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"Module managerpm\n"
		 "managerpm [ specific options ]\n"
		 "\n"
		 "    --root root_directory_for_package_installation\n"
		 "    --update [rpm options ] packages ...\n"
		 "\n"
		 "    Without argument, start the main menu\n"
		 "\n")
		);
}

PUBLIC void MODULE_managerpm::usage(SSTRINGS &tb)
{
	tb.add (new SSTRING(MSG_R(T_USAGE)));
}

PUBLIC int MODULE_managerpm::execmain (int argc , char *argv[], bool)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"managerpm")==0){
		ret = -1;
		if (netconf_rootaccess()){
			int i;
			for (i=1; i<argc; i++){
				const char *s = argv[i];
				if (strcmp(s,"--root")==0 && i+1 < argc){
					i++;
					mngrpm_setfsroot (argv[i]);
				}else{
					break;
				}
			}
			if (i < argc && strcmp(argv[i],"--update")==0){
				dialog_clear();
				i++;
				RPM_OPTIONS options;
				for (; i<argc; i++){
					const char *arg = argv[i];
					if (strcmp(arg,"--nodeps")==0){
						options.nodep = 1;
					}else if (strcmp(arg,"--force")==0){
						options.force = 1;
					}else if (strcmp(arg,"--oldpackages")==0){
						options.oldrev = 1;
					}else if (strcmp(arg,"--replacefiles")==0){
						options.replace = 1;
					}else if (strcmp(arg,"--noscripts")==0){
						options.noscripts = 1;
					}else if (strcmp(arg,"--notriggers")==0){
						options.notrigger = 1;
					}else if (strcmp(arg,"--excludedocs")==0){
						options.excludedocs = 1;
					}else if (strcmp(arg,"--test")==0){
						options.test = 1;
					}else{
						break;
					}
				}
				PACKAGES newpkgs,installed;
				int nbpkg = argc - i;
				SSTRING buf ("-qp");
				int start = i;
				char cwd[PATH_MAX];
				if (getcwd(cwd,sizeof(cwd))==NULL) cwd[0] = '\0';
				SSTRINGS tmps;
				for (; i<argc; i++){
					const char *arg = argv[i];
					if (arg[0] != '/'){
						// Linuxconf always change the current directory
						// when issuing a command.
						SSTRING *s = new SSTRING;
						tmps.add (s);
						s->setfromf("%s/%s",cwd,arg);
						argv[i] = (char*)s->get();
					}
					buf.appendf (" %s",argv[i]);
				}
				if (newpkgs.load (buf.get(),false,nbpkg
					,MSG_R(T_LOADINGPKG)) != -1
					&& installed.loadinstall() != -1){
					for (int j=0; j<newpkgs.getnb(); j++){
						PACKAGE *p = newpkgs.getitem(j);
						p->selected = 1;
						p->fullname.setfrom (argv[start+j]);
					}
					ret = mngrpm_doupdate (newpkgs,options,false);
				}			
			}else if (i == argc){
				mngrpm_menu();
			}else{
				// ### Add some option parsing for the module
				::usage();
			}
		}
	}
	return ret;
}


static MODULE_managerpm managerpm;

