
/* this part deals with xf86 configuration (v4 only) */

#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "mouseconf.h"
#include "mouseconf.m"
#include "mouseconf_vars.h"
#include "mouseconf_tools.h"
#include "fviews.h"

void writeval_mouse_xf86(VIEWITEMS &given_vitems, const char *givenstr1, const char *givenstr2, SSTRING write_this);
void writeval_mouse_xf86(VIEWITEMS &given_vitems, const char *givenstr1, const char *givenstr2, const char *write_this);


/* returns the line of the specified var (with double identificator string,
   instead just one, as conventional config files)
   -- searches between the specified limits (does NOT include the first and last lines)
   returns -1 if not found */
int search_var_between_lines(VIEWITEMS &given_vitems, const char *varname1, const char *varname2, int start_at, int end_at)
{
    if((end_at-start_at)>1){ // at least 1 line between, otherwise there's no sense searching
        int        my_loop;
        const char *current_line;

        my_loop=end_at-start_at-1;
        while(my_loop){
            current_line=given_vitems.getitem(my_loop+start_at)->line.get();
            if(!compare_double_str_ci(current_line, varname1, varname2))
                return(my_loop+start_at);

            my_loop--;
        }
    }

    return(-1); // var not found
}

/* found the first and last line of the group we want to change in XF86config */
/* returns !=0 if group found, ==0 if not found */
int find_the_right_mouse_group(VIEWITEMS &given_vitems, int &startline, int &endline)
{
    int start_at=0;
    int end_at=0;

    while(find_group_limits(given_vitems, "Section \"InputDevice\"", "EndSection", start_at, end_at, end_at)){
        int        correct_identifier, correct_driver; // -1 if var not present

        correct_identifier=search_var_between_lines(given_vitems, "Identifier", "\"Mouse0\"", start_at, end_at);
        correct_driver=search_var_between_lines(given_vitems, "Driver", "\"mouse\"", start_at, end_at);
        if((correct_identifier!=-1)&&(correct_driver!=-1)){
            startline=start_at;
            endline=end_at;
            return(1);
        }
    }
    return(0);
}

/* returns -1 if var not found (or group not found),
 otherwise returns the corresponding line number */
int find_var_mouse_xf86(VIEWITEMS &given_vitems, const char *givenstr1, const char *givenstr2)
{
    int startline, endline;

    if(find_the_right_mouse_group(given_vitems, startline, endline))
        return(search_var_between_lines(given_vitems, givenstr1, givenstr2, startline, endline));
    return(-1);
}

/* finds var location (as find_var_mouse_xf86()) and creates var/group if not found */
int find_var_mouse_xf86_2write(VIEWITEMS &given_vitems, const char *givenstr1, const char *givenstr2)
{
    int startline, endline;
    int var_location;

    if(!find_the_right_mouse_group(given_vitems, startline, endline)){
        /* create group */
        given_vitems.add(new VIEWITEM(""));
        given_vitems.add(new VIEWITEM("Section \"InputDevice\""));
        given_vitems.add(new VIEWITEM("	Identifier  \"Mouse0\""));
        given_vitems.add(new VIEWITEM("	Driver      \"mouse\""));
        given_vitems.add(new VIEWITEM("EndSection"));
        /* find coordinates for newly-created group */
        find_the_right_mouse_group(given_vitems, startline, endline);
    }
    var_location=search_var_between_lines(given_vitems, givenstr1, givenstr2, startline, endline);
    if(var_location==-1){
        /* create var */
        given_vitems.insert(endline, new VIEWITEM(""));
        return(endline);
    }
    return(var_location);
}

/* same as readbool_mouse_xf86() but, well.. it writes instead */
void writebool_mouse_xf86(VIEWITEMS &given_vitems, const char *givenstr1, const char *givenstr2, const char given_data)
{
    int var_location;

    var_location=find_var_mouse_xf86_2write(given_vitems, givenstr1, givenstr2);
    if(given_data){
        given_vitems.getitem(var_location)->line.setfromf("\t%s\t%s", givenstr1, givenstr2);
        return;
    }
    given_vitems.remove_del(var_location);
}

/* reads !=0 if var is found between the specified lines */
char readbool_mouse_xf86(VIEWITEMS &given_vitems, const char *givenstr1, const char *givenstr2)
{
    if(find_var_mouse_xf86(given_vitems, givenstr1, givenstr2)!=-1)
        return(1);
    return(0);
}

/* handle for original writeval_mouse_xf86() */
void writeval_mouse_xf86(VIEWITEMS &given_vitems, const char *givenstr1, const char *givenstr2, SSTRING write_this)
{
    writeval_mouse_xf86(given_vitems, givenstr1, givenstr2, write_this.get());
}

/* same as readval_mouse_xf86 but, yes.. it writes instead.
   it'll ommit the variable from config file is given string is empty */
void writeval_mouse_xf86(VIEWITEMS &given_vitems, const char *givenstr1, const char *givenstr2, const char *write_this)
{
    int var_location;

    var_location=find_var_mouse_xf86_2write(given_vitems, givenstr1, givenstr2);
    if(*write_this){
        given_vitems.getitem(var_location)->line.setfromf("\t%s\t\t%s \"%s\"", givenstr1, givenstr2, write_this);
        return;
    }
    given_vitems.remove_del(var_location);
}

/* picks the value for a var and dumps into write_here
 returns !=0 if this var is present, ==0 otherwise (or group not found) */
/* the data is always the 3rd element of string (3rd word, surrounded by quotes) */
char readval_mouse_xf86(VIEWITEMS &given_vitems, const char *givenstr1, const char *givenstr2, SSTRING &write_here)
{
    int var_position;

    var_position=find_var_mouse_xf86(given_vitems, givenstr1, givenstr2);
    if(var_position!=-1){
        gimme_word_from_string(given_vitems.getitem(var_position)->line.get(), write_here, 2);
        cuts_quotes_off(write_here);
        return(1);
    }
    return(0);
}

/* reads only the extra data, not present in /etc/sysconfig/mouse */
void reads_xf86_config(void)
{
    VIEWITEMS_PARSER pre_vitems_xf86;
    VIEWITEMS vitems_xf86(pre_vitems_xf86);
    vitems_xf86.read(cf_xf86); // load file data

    readval_mouse_xf86(vitems_xf86, "Option", "\"SampleRate\"", mouse_prefs.samplerate);
    readval_mouse_xf86(vitems_xf86, "Option", "\"Resolution\"", mouse_prefs.resolution);
    readval_mouse_xf86(vitems_xf86, "Option", "\"Emulate3Timeout\"", mouse_prefs.emulate3timeout);
}

/* writes all the vars readen by reads_xf86_config
   PLUS all the convenient ones from /etc/sysconfig/mouse */
void writes_xf86_config(void)
{
    VIEWITEMS_PARSER pre_vitems_xf86;
    VIEWITEMS vitems_xf86(pre_vitems_xf86);
    vitems_xf86.read(cf_xf86); // load file data

    writeval_mouse_xf86(vitems_xf86, "Option", "\"SampleRate\"", mouse_prefs.samplerate);
    writeval_mouse_xf86(vitems_xf86, "Option", "\"Resolution\"", mouse_prefs.resolution);
    writeval_mouse_xf86(vitems_xf86, "Option", "\"Emulate3Timeout\"", mouse_prefs.emulate3timeout);

    writebool_mouse_xf86(vitems_xf86, "Option", "\"Emulate3Buttons\"", mouse_prefs.emulate3but);
    writeval_mouse_xf86(vitems_xf86, "Option", "\"Device\"", MOUSELINK_PATH);
    writeval_mouse_xf86(vitems_xf86, "Option", "\"Protocol\"", mouse_prefs.xmousetype);

    /* UNIMPLEMENTED YET:
       - device description field (still unsupported in XF86 configfile Section entries) */

    vitems_xf86.write(cf_xf86, 0); // ..so it finally writes
}

