
/*

 PortSlave configurator 1.1 (pslaveconf)
 by Daniel Mealha Cabrita (dancab@conectiva.com)

 v1.0 - Aug 23th, 2000
 v1.1 - Nov 1st, 2000

 changes:

 v1.1 - on the first run the module no longer complains
 on restarting pslave (because absent checksum was
 being treated as file change) - fixed.

 */

#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "pslaveconf.h"
#include "pslaveconf.m"

#include "ps_main.cc"
#include "ps_vars.h"
#include <netconf_def.h>

MODULE_DEFINE_VERSION(pslaveconf);

PUBLIC MODULE_pslaveconf::MODULE_pslaveconf()
	: LINUXCONF_MODULE("pslaveconf")
{
	linuxconf_loadmsg ("pslaveconf",PACKAGE_REV);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_pslaveconf::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_NETWORK_SERVER){
		keymenu = MSG_U(M_pslaveconf,"Portslave configurator");
		dia.new_menuitem ("pslaveconf","",keymenu);
	}
}

PUBLIC int MODULE_pslaveconf::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_NETWORK_SERVER){
		if (key == keymenu){
			// ### Place the call to the edit function here
                    lets_go();
                }
	}
	return 0;
}


PUBLIC int MODULE_pslaveconf::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"pslaveconf")==0){
		// ### Insert any menu and dialog here
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"linuxconf --modulemain pslaveconf usage\n"
		 "\n"
		 "    pslaveconf --option ...\n")
		);
}

PUBLIC void MODULE_pslaveconf::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_pslaveconf::execmain (int argc , char *argv[], bool)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"pslaveconf")==0){
		ret = -1;
		if (argc == 1){
			// ### Place call to main menu of the module
                    lets_go();
                }else{
                    // ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}

PUBLIC int MODULE_pslaveconf::probe (int level, int target, bool simul)
{
    if(level==2){
        char current_sum[500];
        const char *saved_sum;
        const char my_nothing[]="";
        int first_time_running=0;

        cf_pslave.md5sum(current_sum);
        if(!(saved_sum=linuxconf_getval("pslaveconf", "pslaveconf_sum"))){
            saved_sum=my_nothing;
            first_time_running=1; /* there was no previous checksum.. */
        }

        if(strcmp(saved_sum, current_sum)){
            if(simul==false){
                linuxconf_replace("pslaveconf", "pslaveconf_sum", current_sum);
                linuxconf_save();
                if(!first_time_running){
                    net_title(MSG_U(T_CONFIG_WERE_CHANGED, "Portslave configurations were changed"));
                    netconf_system_if("killall", "-TERM  portslave");
                }
            }
            if(!first_time_running){
                net_prtlog(NETLOG_CMD, "Executing: killall -TERM portslave\n");
                net_prtlog(NETLOG_WHY, MSG_U(X_PSLAVE_IS_GOING_TO_RESTART, "File pslave.conf was changed, idle portslave ports are going to be restarted\n"));
            }
        }
    }

    return(0);
}

static MODULE_pslaveconf pslaveconf;

