
/* this configuration deals with the 'hints' file */

#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "radiusconf.h"
#include "radiusconf.m"

#include "rc_parser.h"
#include "rc_tools.h"


void edit_hint_properties(int which_group, VIEWITEMS &given_vitems)
{
    DIALOG      my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;
    SSTRING     dialog_title;
    SSTRINGS    level_one_vars; // all level-1 vars indexed here
                                  // (used to check if all are empty -- it would be unacceptable)

    level_one_vars.neverdelete();
    my_dialog.setbutinfo(MENU_USR1, MSG_R(B_MOVE), NULL);

    /* loads vars.. */
    /* builds gui.. */
    EASY_TITLE(MSG_U(F_USERNAMEH,"User name:"));
    /* level 0 */
    my_dialog.newf_title(MSG_R(X_MATCHHINTS), 1, "", MSG_U(X_MATCHHINTS,"Match"));
    EASY_STR_QUOTED(s0_prefix,"Prefix",0,MSG_U(F_PREFIX,"Prefix:"));
    EASY_STR_QUOTED(s0_suffix,"Suffix",0,MSG_U(F_SUFFIX,"Suffix:"));
    EASY_BOOL(s0_stripusername,"Strip-User-Name",0,MSG_U(F_STRIPUSERNAME,"Strip user name:"),f0_stripusername);
    /* level 1 */
    my_dialog.newf_title(MSG_R(X_CHANGESHINTS), 1, "", MSG_U(X_CHANGESHINTS,"Changes"));
    EASY_STR_QUOTED(s1_hint,"Hint",1,MSG_U(F_HINTHINTS,"Hint:"));
    EASY_FC(c1_framedprotocol,"Framed-Protocol",1,s1_framedprotocol,MSG_U(F_FRAMEDPROTOCOLH1,"Framed protocol:"));
    EASY_ADD_FC(c1_framedprotocol,"PPP");
    EASY_ADD_FC(c1_framedprotocol,"SLIP");
    EASY_FC(c1_servicetype,"Service-Type",1,s1_servicetype,MSG_U(F_SERVICETYPEH1,"Service type:"));
    EASY_ADD_FC(c1_servicetype,"Callback-Login-User");
    EASY_ADD_FC(c1_servicetype,"Framed-User");
    EASY_ADD_FC(c1_servicetype,"Login-User");
    EASY_ADD_FC(c1_servicetype,"Shell-User");
    EASY_STR(s1_framedcompression,"Framed-Compression",1,MSG_U(F_FRAMEDCOMPRESSIONH1,"Framed compression:"));

    while(1){
        /* opens dialog.. */
        dialog_title.setfromf(MSG_U(T_HINTENTRYN,"Hint entry %d"), which_group+1);
        my_selection=0;
        my_button=my_dialog.editmenu(dialog_title.get(), "", hf_hints, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT|MENUBUT_DEL|MENUBUT_USR1);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ACCEPT:
            {
                if(invalid_entry(my_group_title.get())){
                    informative_window(MSG_U(T_INVALIDNAME4HINTUSER,"Invalid name for hint user"), MSG_U(E_INVALIDNAME4HINTUSER,"The hint username can't be empty\nneither have spaces within."));
                }else{
                    if(are_all_empty(level_one_vars)){
                        informative_window(MSG_U(T_INVALIDCONFIGHINTS,"Invalid configuration"), MSG_U(E_INVALIDCONFIGHINTS,"The \"Changes\" settings must have\nat least one entry defined."));
                    }else{
                        /* save vars.. */
                        EASY_TITLE_WRITE;
                        /* level 0 */
                        EASY_SSTRING_QUOTED_WRITE(s0_prefix,"Prefix",0);
                        EASY_SSTRING_QUOTED_WRITE(s0_suffix,"Suffix",0);
                        EASY_SSTRING_WRITE(s0_stripusername,"Strip-User-Name",0);
                        /* level 1 */
                        EASY_SSTRING_QUOTED_WRITE(s1_hint,"Hint",1);
                        EASY_SSTRING_WRITE(s1_framedprotocol,"Framed-Protocol",1);
                        EASY_SSTRING_WRITE(s1_servicetype,"Service-Type",1);
                        EASY_SSTRING_WRITE(s1_framedcompression,"Framed-Compression",1);

                        given_vitems.write(cf_hints, 0);
                        return;
                    }
                }
            }
            break;
        case MENU_DEL:
            /* remove this entry */
            delete_whole_group(given_vitems, which_group);
            given_vitems.write(cf_hints, 0);
            return;
            break;
        case MENU_USR1:
            /* move group */
            {
                int my_temp;

                my_temp=select_new_position(given_vitems, MSG_U(T_SELECTNEWPOSHINTS,"Select new position"), MSG_U(X_SELECTNEWPOSHINTS,"user name\tmatch"), MSG_R(X_LASTPOSITION));
                if(my_temp!=-1){
                    move_group(given_vitems, which_group, my_temp);
                    given_vitems.write(cf_hints, 0);
                    return;
                }
            }
            break;
        default:
            break;
        }
    }




}


void show_hints_list(void)
{
    DIALOG_RECORDS my_dialog;
    MENU_STATUS my_button=(MENU_STATUS)0;
    int         my_selection=0;

    VIEWITEMS_PARSER my_vitems_parser;
    VIEWITEMS my_vitems(my_vitems_parser);

    my_vitems.read(cf_hints);

    my_dialog.newf_head("", MSG_U(X_USERNAMEMATCHHINTS,"user name\tmatch"));

    while(1){
        int         progressive_counter=0;
        SSTRING     username_to_insert,
                    match_to_insert;

        /* fills list.. */
        while(returns_data_for_list(my_vitems, progressive_counter, match_to_insert, username_to_insert)){
            my_dialog.set_menuitem(progressive_counter, username_to_insert.get(), match_to_insert.get());
            progressive_counter++;
        }

        // remove entries below (they're the previous ones and useless now)
        my_dialog.remove_last(progressive_counter+1);

        my_button=my_dialog.editmenu(MSG_U(T_HINTSLISTENTRIES,"Hints list entries"), MSG_R(I_SENSITIVE2POSITIONS), hf_general_list2, my_selection, MENUBUT_QUIT|MENUBUT_ADD);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ADD:
            {
                int how_many;

                how_many=how_many_groups_are(my_vitems);
                create_new_group(my_vitems, "DEFAULT", "\tService-Type = Framed-User");
                edit_user_properties(how_many, my_vitems);
                my_vitems.write(cf_hints, 0);
            }
            break;
        default:
            {
                edit_hint_properties(my_selection, my_vitems);

                break;
            }
        }
    }





}

