#pragma interface
#ifndef TLMPDIA_H
#define TLMPDIA_H

#define _TLMP_uithread_argstr

struct _F_uithread_argstr{
	class UITHREAD_PRIVATE *priv;
	#define _F_uithread_argstr_thread(nom) void nom thread(const char *val)
	virtual _F_uithread_argstr_thread( )=0;
	#define _F_uithread_argstr_main(nom) void nom main()
	virtual _F_uithread_argstr_main( )=0;
};


#define _TLMP_editmenu

struct _F_editmenu{
	class EDITMENU_PRIVATE *priv;
	#define _F_editmenu_exec(nom) void nom exec(const char *key, int no)
	virtual _F_editmenu_exec( );
	#define _F_editmenu_execthread(nom) void nom execthread(const char *key, int no)
	virtual _F_editmenu_execthread( );
};

class HELP_FILE;

#ifndef DIALOG_H
	#include <dialog.h>
#endif
class UISTATE;

enum SORT_ORDER { SORT_NONE, SORT_ASC, SORT_DESC};

#define _TLMP_editrecords

struct _F_editrecords{
	class EDITRECORDS_PRIVATE *priv;
	void new_menuitem (const char *, const char *);
	void new_menuitemf (const char *, const char *, ...);
	void newf_head (const char *s);
	void addwhat(const char *s);
	void delwhat(const char *s);
	void setbutinfo(int id, const char *title, const char *icon);
	void setcontext(const char *s);
	void set_button_on_side();
	void waitfor (PRIVATE_MESSAGE &msg);
	void settype (DIALOG_TYPE type);
	void endedit();
	void setcursor(int);
	void setvsize(int);
	void newf_clist();
	void new_button (int id, const char *title, const char *help);
	void new_button_icon (int id, const char *icon, const char *help);
	void new_button_help ();
	void set_button (int id, const char *title);
	void set_button_icon (int id, const char *icon);
	void gui_passthrough (int cmd, const char *ctl, ...);
	void newline();
	void newf_chk (const char *prompt, char &var, const char *title);
	void newf_str (const char *prompt, SSTRING &s);
	void nobutton();
	void sortcolumn(int column, SORT_ORDER order);
	void sortable();
	void selectsort (int head);
	void setnextdcs (const char *dcs);
	void setdefaultdcs (const char *dcs);
	#define _F_editrecords_load(nom) void nom load(int column, SORT_ORDER order)
	virtual _F_editrecords_load( )=0;
	#define _F_editrecords_head(nom) void nom head()
	virtual _F_editrecords_head( )=0;
	#define _F_editrecords_editone(nom) void nom editone(int no, UISTATE &uistate)
	virtual _F_editrecords_editone( );
	#define _F_editrecords_pickone(nom) void nom pickone(int no, UISTATE &uistate)
	virtual _F_editrecords_pickone( );
	#define _F_editrecords_add(nom) void nom add()
	virtual _F_editrecords_add( );
	#define _F_editrecords_otherbuttons(nom) void nom otherbuttons(MENU_STATUS code, int id)
	virtual _F_editrecords_otherbuttons( );
	#define _F_editrecords_message(nom) void nom message()
	virtual _F_editrecords_message( );
	#define _F_editrecords_guidialog(nom) void nom guidialog()
	virtual _F_editrecords_guidialog( );
	#define _F_editrecords_clickhead(nom) void nom clickhead(int head, UISTATE &state)
	virtual _F_editrecords_clickhead( );
	// Some spares for binary compatibility
	virtual void _slot1();
	virtual void _slot2();
	virtual void _slot3();
	virtual void _slot4();
	virtual void _slot5();
	virtual void _slot6();
	virtual void _slot7();
	virtual void _slot8();
	virtual void _slot9();
};	

#define _TLMP_editmanyrecords

struct _F_editmanyrecords: public _F_editrecords{
	#define _F_editmanyrecords_load(nom) _F_editrecords_load(nom) 
	#define _F_editmanyrecords_head(nom) _F_editrecords_head(nom) 
	#define _F_editmanyrecords_editone(nom) _F_editrecords_editone(nom)
	#define _F_editmanyrecords_add(nom) _F_editrecords_add(nom)
	#define _F_editmanyrecords_otherbuttons(nom) _F_editrecords_otherbuttons(nom)
};

#define _TLMP_edittree

struct _F_edittree{
	class EDITTREE_PRIVATE *priv;
	// The tree edit is not limited to file and direcoties, but we are using
	// this naming to help.
	void new_subdir (const char *title);
	void end_subdir ();
	void new_file   (const char *title);
	// Load the sub-branches (sub-directories)
	// a string path and and integer path allows the client to learn
	// which "directory" must be loaded
	#define _F_edittree_load(nom) void nom load(int level, const char *spath, const int ipath[])
	virtual _F_edittree_load( )=0;
	#define _F_edittree_editone(nom) void nom editone(const char *spath, const int ipath[], int level)
	virtual _F_edittree_editone( )=0;
};


#include "tlmpdia.p"

#endif

