/*
 *   logtool - a logfile parsing/monitoring/manipulation utility
 *
 *   Copyright (C) Y2K (2000) A.L.Lambert
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#define CONFIG_FILE	"/etc/logtool/logtool.conf"	/* This is the logtool config file	*/
#define YELLOWFILE 	"/etc/logtool/yellow"      	/* This is the default yellow file  	*/
#define GREENFILE 	"/etc/logtool/green"        	/* This is the default green file 	*/
#define EXCLUDEFILE 	"/etc/logtool/exclude"      	/* This is the default ignore file 	*/
#define INCLUDEFILE 	"/etc/logtool/include" 	        /* this is the default include file 	*/

/* You shouldn't muck around with anything below this line less you know what you're doing	*/

#define DATE_LONG 	0	/* If we display the full date */
#define DATE_SHORT 	1	/* If we display the short date */

/* define values of TRUE and FALSE so code is more readable */
#define TRUE		1	/* the value of TRUE 	*/
#define FALSE		0	/* the value of FALSE 	*/

/* Define the version specific stuff's */
#define PROGRAM_NAME    "logtool"
#define AUTHORS         "A.L.Lambert"
#define VERSION         "1.0.6"
#define PRINT_VERSION   printf("%s version %s, copyright Y2K %s\n", PROGRAM_NAME, VERSION, AUTHORS);

/* Down here is the command line options and such */
#define OPTIONS         "c:t:o:i:e:y:g:vVbpsh" 
/* 
 * t=time, o=output, i=include, e=exclude, y=yellow, g=green, 
 * v=verbose, V=version, b=beep, p=program(exclude), s=source(exclude)
 * h=help, -c /path/to/config.file.  
 *
 */

/* 
 * Define's for the different event types we might see
 */

#define EVENT_DEFAULT	0	/* Only one type of log msg at the moment		*/
			   	/* Will expand for various "known things" later 	*/

/* 
 * These define the different output formats.  Unless you know what you're doing, 
 * don't muck with em.
 */
#define OUTPUT_ANSI		0
#define OUTPUT_ASCII		1
#define OUTPUT_CSV		2
#define OUTPUT_HTML		3
#define OUTPUT_RAW		4

