#ifndef _PARISC_HARDWARE_H
#define _PARISC_HARDWARE_H

struct parisc_device_id {
	unsigned char	hw_type;	/* 5 bits used */
	unsigned char	hversion_rev;	/* 4 bits */
	unsigned short	hversion;	/* 12 bits */
	unsigned int	sversion;	/* 20 bits */
};

#define HWTYPE_ANY_ID	0xff
#define HVERSION_REV_ANY_ID	0xff
#define HVERSION_ANY_ID	0xffff
#define SVERSION_ANY_ID	0xffffffffU

struct hp_hardware {
	unsigned short	hw_type:5;	/* HPHW_xxx */
	unsigned short	hversion;
	unsigned long	sversion:28;
	unsigned short	opt;
	const char	name[80];	/* The hardware description */
};

enum cpu_type {
	pcx	= 0, /* pa7000		pa 1.0  */
	pcxs	= 1, /* pa7000		pa 1.1a */
	pcxt	= 2, /* pa7100		pa 1.1b */
	pcxt_	= 3, /* pa7200	(t')	pa 1.1c */
	pcxl	= 4, /* pa7100lc	pa 1.1d */
	pcxl2	= 5, /* pa7300lc	pa 1.1e */
	pcxu	= 6, /* pa8000		pa 2.0  */
	pcxu_	= 7, /* pa8200	(u+)	pa 2.0  */
	pcxw	= 8, /* pa8500		pa 2.0  */
	pcxw_	= 9, /* pa8600	(w+)	pa 2.0  */
	pcxw2	= 10, /* pa8700		pa 2.0  */
	mako	= 11, /* pa8800		pa 2.0  */
        unknown = 12
};

extern char *cpu_name_version[][2]; /* mapping from enum cpu_type to strings */

#define HPHW_NPROC     0 
#define HPHW_MEMORY    1       
#define HPHW_B_DMA     2
#define HPHW_OBSOLETE  3
#define HPHW_A_DMA     4
#define HPHW_A_DIRECT  5
#define HPHW_OTHER     6
#define HPHW_BCPORT    7
#define HPHW_CIO       8
#define HPHW_CONSOLE   9
#define HPHW_FIO       10
#define HPHW_BA        11
#define HPHW_IOA       12
#define HPHW_BRIDGE    13
#define HPHW_FABRIC    14
#define HPHW_MC	       15
#define HPHW_FAULTY    31


extern const char *parisc_hardware_description(unsigned char hw_type,
                                               unsigned short hversion,
                                               unsigned int sversion);
extern enum cpu_type parisc_get_cpu_type(unsigned long hversion);

extern int parisc_print_mask(unsigned int hw_type, unsigned int hversion,
				unsigned int sversion);

extern const char *parisc_type(unsigned char hw_type);

#endif /* _PARISC_HARDWARE_H */
