/* 
**  log.c
*/ 

#include "mod_mp3.h"

MP3_EXPORT(void) write_log(request_rec *r, mp3_conf *cfg, request_data *info, mp3_data *bank) {
	int timz;
	struct tm *t = ap_get_gmtoff(&timz);
	char sign = (timz < 0 ? '-' : '+');
	unsigned char buffer[HUGE_STRING_LEN];
	int size = 0;

	memset(buffer, 0, HUGE_STRING_LEN);

	if (timz < 0) {
		timz = -timz;
	}

	size = snprintf(buffer, HUGE_STRING_LEN, "[%02d/%s/%d:%02d:%02d:%02d %c%.2d%.2d] %s %s %s\n",
                t->tm_mday, ap_month_snames[t->tm_mon], t->tm_year+1900, 
                t->tm_hour, t->tm_min, t->tm_sec,
                sign, timz / 60, timz % 60, info->id, bank->signature, bank->name); 
	
	if(write(cfg->log, buffer, size) == -1) {
		ap_log_rerror(APLOG_MARK, APLOG_NOERRNO|APLOG_ERR, r,
			"mod_mp3 when trying to write to the log : %s", cfg->log_filename);
	}
}
