/***************************************************************************
 *   Copyright (C) 2003 by Miguel Revilla Rodrguez                        *
 *   yo@miguelrevilla.com                                                  *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/


/* Includes */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>


/* Some useful definitios */

#define SC_MASK                 0x3F
#define SC_DOUBLE_MASK		0x3F3F
#define SC_COLOR_MASK		0x0F
#define SC_ROW_MASK		0x1F
#define SC_COLUMN_MASK		0x3F
#define SC_CDG_COMMAND          0x09
#define TRUE			1

#define CDG_FRAMEWIDTH		300
#define CDG_FRAMEHEIGHT		216
#define CDG_BORDERWIDTH		6
#define	CDG_BORDERHEIGHT	12
#define CDG_RGBAFRAMESIZE	CDG_FRAMEWIDTH * CDG_FRAMEHEIGHT * 4


/* CD+G Commands */

#define CDG_MEMORYPRESET        1
#define CDG_BORDERPRESET        2
#define CDG_TILEBLOCKNORMAL     6
#define CDG_SCROLLPRESET        20
#define CDG_SCROLLCOPY          24
#define CDG_TRANSPARENTCOLOR    28
#define CDG_COLORTABLELO        30
#define CDG_COLORTABLEUP        31
#define CDG_TILEBLOCKXOR        38


/* Useful structs */

struct cdgSubChannelChunk {
        unsigned char command ;
        unsigned char instruction ;
        unsigned char parityQ[2] ;
        unsigned char data[16] ;
        unsigned char parityP[4] ;
} ;

struct cdgColorTabStruct {
        short colorSpec[8] ;
} ;

struct cdgTileBlockStruct {
        unsigned char color0 ;
        unsigned char color1 ;
        unsigned char row ;
        unsigned char column ;
        unsigned char tilePixels[12] ;
} ;

struct cdgMemPresetStruct {
        unsigned char color ;
        unsigned char repeat ;
        unsigned char filler[14] ;
} ;

struct cdgBorderPresetStruct {
        unsigned char color ;
        unsigned char filler[15] ;
} ;

struct cdgTransparentColorStruct {
	unsigned char color ;
	unsigned char filler[15] ;
} ;

struct cdgScrollStruct {
	char color ;
	char hScroll ;
	char vScroll ;
	char filler[13] ;
} ;

struct cdgStream {
	unsigned int colorTable[17][3] ;
	unsigned char pixelMatrix[CDG_FRAMEWIDTH*CDG_FRAMEHEIGHT] ;
	int borderColor ;
	int transparentColor ;
} ;
