/***************************************************************************
 $RCSfile: ctdriver_pcsc.h,v $
                             -------------------
    cvs         : $Id: ctdriver_pcsc.h,v 1.3 2003/02/17 04:17:48 aquamaniac Exp $
    begin       : Fri Nov 22 2002
    copyright   : (C) 2001 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef CTDRIVER_PCSC_H
#define CTDRIVER_PCSC_H "$Id: ctdriver_pcsc.h,v 1.3 2003/02/17 04:17:48 aquamaniac Exp $"

#ifdef __cplusplus
extern "C" {
#endif


#include <winscard.h>
#include <ctcore.h>
#include <chameleon/libloader.h>


typedef LONG (*CTDPCSCESTABLISHCONTEXTPTR)(DWORD dwScope,
					   LPCVOID pvReserved1,
					   LPCVOID pvReserved2,
					   LPSCARDCONTEXT phContext);
typedef LONG (*CTDPCSCRELEASECONTEXTPTR)(SCARDCONTEXT hContext);
typedef LONG (*CTDPCSCLISTREADERSPTR)(SCARDCONTEXT hContext,
				      LPCSTR mszGroups,
				      LPSTR mszReaders,
				      LPDWORD pcchReaders);
typedef LONG (*CTDPCSCCONNECTPTR)(SCARDCONTEXT hContext,
				  LPCSTR szReader,
				  DWORD dwShareMode,
				  DWORD dwPreferredProtocols,
				  LPSCARDHANDLE phCard,
				  LPDWORD pdwActiveProtocol);
typedef LONG (*CTDPCSCRECONNECTPTR)(SCARDHANDLE phCard,
				    DWORD dwShareMode,
				    DWORD dwPreferredProtocols,
				    DWORD dwInit,
				    LPDWORD pdwActiveProtocol);
typedef LONG (*CTDPCSCDISCONNECTPTR)(SCARDHANDLE hCard,
				     DWORD dwDisposition);
typedef LONG (*CTDPCSCCONTROLPTR)(SCARDHANDLE hCard,
				  LPCBYTE pbSendBuffer,
				  DWORD cbSendLength,
				  LPBYTE pbRecvBuffer,
				  LPDWORD pcbRecvLength);
typedef LONG (*CTDPCSCTRANSMITPTR)(SCARDHANDLE hCard,
				   LPCSCARD_IO_REQUEST pioSendPci,
				   LPCBYTE pbSendBuffer,
				   DWORD cbSendLength,
				   LPCSCARD_IO_REQUEST pioRecvPci,
				   LPBYTE pbRecvBuffer,
				   LPDWORD pcbRecvLength);
typedef LONG (*CTDPCSCSTATUSPTR)(SCARDHANDLE hCard,
				 LPSTR szReaderName,
				 LPDWORD pcchReaderLen,
				 LPDWORD pdwState,
				 LPDWORD pdwProtocol,
				 LPBYTE pbAtr,
				 LPDWORD pcbAtrLen);



typedef struct CTDRIVERPCSC_DRIVERDATASTRUCT CTDRIVERPCSC_DRIVERDATA;
typedef struct CTDRIVERPCSC_READERDATASTRUCT CTDRIVERPCSC_READERDATA;



struct CTDRIVERPCSC_DRIVERDATASTRUCT {
  CTDPCSCESTABLISHCONTEXTPTR establishContext;
  CTDPCSCRELEASECONTEXTPTR releaseContext;
  CTDPCSCLISTREADERSPTR listReaders;
  CTDPCSCCONNECTPTR connect;
  CTDPCSCRECONNECTPTR reconnect;
  CTDPCSCDISCONNECTPTR disconnect;
  CTDPCSCCONTROLPTR control;
  CTDPCSCTRANSMITPTR transmit;
  CTDPCSCSTATUSPTR status;
  SCARDCONTEXT context;
  CHLIBLOADERHANDLE libHandle;
};


struct CTDRIVERPCSC_READERDATASTRUCT {
  SCARDHANDLE cardhandle;
  DWORD protocol;
};


ERRORCODE CTDriver_PCSC_Open(CTDRIVERTABLE *dt,
			     CTREADERDESCRIPTION *rd,
			     CONFIGGROUP *ddescr);

ERRORCODE CTDriver_PCSC_Close(CTDRIVERTABLE *dt);


#ifdef __cplusplus
}
#endif


#endif /* CTDRIVER_PCSC_H */


