/***************************************************************************
 $RCSfile: pam_chipcard.cpp,v $
                             -------------------
    cvs         : $Id: pam_chipcard.cpp,v 1.1 2003/02/10 13:43:01 aquamaniac Exp $
    begin       : Sun Feb 09 2003
    copyright   : (C) 2003 by Martin Preuss
    email       : martin@libchipcard.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/

#define PAM_SM_AUTH

extern "C" {
# include <security/pam_modules.h>
}
#include <syslog.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>


void PAM_Chipcard_LogMessage(int prio,
			     const char *format, ...) {
  va_list args;

  va_start(args, format);
  openlog("PAM-chipcard", LOG_CONS|LOG_PID, LOG_AUTH);
  vsyslog(prio, format, args);
  va_end(args);
  closelog();
}


void PAM_Chipcard_PrintMessage(pam_handle_t *pamh, const char *s){
  struct pam_conv     *conv;
  struct pam_message  *msgs[1];
  struct pam_response *response;

  pam_get_item(pamh,
	       PAM_CONV,
	       (const void **)(&conv));
  msgs[0]=(struct pam_message*)(malloc(sizeof(struct pam_message)));
  memset(msgs[0],0,sizeof(struct pam_message));
  msgs[0]->msg_style=PAM_TEXT_INFO;
  msgs[0]->msg=s;
  conv->conv(1,(const struct pam_message**)(msgs),
	     &response,conv->appdata_ptr);
  free(msgs[0]);
  free(response);
}


char *PAM_Chipcard_Input(pam_handle_t *pamh,
			 const char *s,
			 int style){
  struct pam_conv     *conv;
  struct pam_message  *msgs[1];
  struct pam_response *response;
  char *rs;

  pam_get_item(pamh,
	       PAM_CONV,
	       (const void **)(&conv));
  msgs[0]=(struct pam_message*)(malloc(sizeof(struct pam_message)));
  memset(msgs[0],0,sizeof(struct pam_message));
  msgs[0]->msg_style=style;
  msgs[0]->msg=s;
  conv->conv(1,(const struct pam_message**)(msgs),
	     &response,conv->appdata_ptr);
  free(msgs[0]);
  rs=response->resp;
  free(response);
  return rs;
}



int PAM_Chipcard_Authenticate(pam_handle_t *pamh,
			      int flags,
			      int argc,
			      const char **argv) {
  char *s;

  fprintf(stderr,"PAM_Authentificate called.\n");
  PAM_Chipcard_PrintMessage(pamh, "Moin moin ;-)\n");
  s=PAM_Chipcard_Input(pamh,
		       "Geben Sie mal was ein: ",
		       PAM_PROMPT_ECHO_OFF);
  PAM_Chipcard_PrintMessage(pamh, "Ihre Eingabe war: ");
  PAM_Chipcard_PrintMessage(pamh, s);


  return PAM_SUCCESS;
}


int PAM_Chipcard_SetCred(pam_handle_t *pamh,
			 int flags,
			 int argc,
			 const char **argv){
  fprintf(stderr,"PAM_SetCred called.\n");
  return PAM_SUCCESS;
}



/*
 * Interface to PAM
 */
extern "C" {
  PAM_EXTERN int pam_sm_authenticate(pam_handle_t *pamh,
				     int flags,
				     int argc,
				     const char **argv) {
    return PAM_Chipcard_Authenticate(pamh, flags, argc, argv);
  }

  PAM_EXTERN int pam_sm_setcred(pam_handle_t *pamh,
				int flags,
				int argc,
				const char **argv){
    return PAM_Chipcard_SetCred(pamh, flags, argc, argv);
  }
}


/*
pam_get_item(pamh,PAM_USER,(const void **)(&username));
pam_set_item(pamh,PAM_USER,username);
pam_get_user(pamh,(const char **)(&username),NULL);
pam_get_data(pamh,"hbci_manual",(const void**)(&manual));
auth
  pam_set_data(pamh,"hbci_retval",retVal,cleanup);

setcred
  pam_get_data(pamh,"hbci_retval",(const void**)(&retval));
*/







