#include <claw/multi_type_map.hpp>
#include <fstream>
#include <iostream>
#include <sstream>
#include <string>

struct custom
{
  int a;
  std::string s;

}; // class custom

std::istream& operator>>( std::istream& is, custom& c )
{
  return is >> c.a >> c.s;
}

std::ostream& operator<<( std::ostream& os, const custom& c )
{
  return os << "(" << c.a << ", " << c.s << ")";
}


using namespace claw::meta;

typedef type_list
<float,
 type_list<bool,
	   type_list<std::string,
		     type_list<custom, no_type> > > > my_type_list;

template<typename T>
void get( const claw::multi_type_map<int, my_type_list>& map, int key,
	  const std::string& type )
{
  if ( !map.template exists<T>(key) )
    std::cout << type << ":" << key << " is undefined." << std::endl;
  else
    std::cout << type << ":" << key << " is " << map.get<T>(key) << std::endl;
} // get<>()

void get( std::istream& is, claw::multi_type_map<int, my_type_list>& map )
{
  int key;
  char type;

  if (is >> key >> type)
    switch( type )
      {
      case 'c': get<custom>(map, key, "custom"); break;
      case 'b': get<bool>(map, key, "bool"); break;
      case 'f': get<float>(map, key, "float"); break;
      case 's': get<std::string>(map, key, "string"); break;
      }
} // get()

template<typename T>
void set( std::istream& is, claw::multi_type_map<int, my_type_list>& map,
	  int key )
{
  T v;
  is >> v;
  
  map.set<T>( key, v );
} // set<>()

void set( std::istream& is, claw::multi_type_map<int, my_type_list>& map )
{
  int key;
  char type;

  if (is >> key >> type)
    switch( type )
      {
      case 'c': set<custom>(is, map, key); break;
      case 'b': set<bool>(is, map, key); break;
      case 'f': set<float>(is, map, key); break;
      case 's': set<std::string>(is, map, key); break;
      }
} // set()

void read( std::istream& is )
{
  std::string line;
  claw::multi_type_map<int, my_type_list> map;

  std::cout << sizeof(map) << std::endl;

  while ( std::getline(is, line) )
    {
      std::istringstream iss(line);
      std::string action;

      iss >> action;

      if ( action == "get" )
	get( iss, map );
      else if ( action == "set" )
	set( iss, map );
    }
} // read()

int main( int argc, char* argv[] )
{
  if (argc != 2)
    std::cerr << "usage:\n" << argv[0] << " test_file." << std::endl;
  else
    {
      std::ifstream f( argv[1] );

      if ( !f )
        std::cerr << "Can't open file '" << argv[1] << "'" << std::endl;
      else
	read( f );
    }

  return 0;
} // main()
