/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#ifndef _LOG_H
#define _LOG_H 1

#include <syslog.h>
#include <stdarg.h>

#define LOG_TO_SYSLOG (1 << 0)
#define LOG_TO_STDERR (1 << 1)
#define LOG_TO_STDOUT (1 << 2)

#define LOG_WITH_NAME (1 << 30)
#define LOG_WITH_PID  (1 << 31)

#define LOG_TYPE_GENERIC  1
#define LOG_TYPE_DAEMON   2
#define LOG_TYPE_SECURITY 3

struct _log_opt
{
  char *service_name;

  int to_syslog;
  int to_stdout;
  int to_stderr;
  
  int with_pid;
  int with_name;
  
  int level;
};

extern struct _log_opt _log_opt;
extern int _log_opt_initialized;


int log_init(const char *service_name, unsigned short type, unsigned long options,
             int level_def);

void log_level_set(int level);
unsigned long log_opt_get();

void log_put(const char *format, ...);
void log_put_opt(int level, unsigned long options, const char *format, ...);
void log_vput_opt(int level, unsigned long options, const char *format, va_list args);
void log_put_abort_do(const char *func, const char *message);
#define log_put_abort(message) log_put_abort_do(__FUNCTION__, message)

#endif  /* _LOG_H */
