// Java testclient for the net.styx.flux.comm package. Start
// ttree-server-java-example in the examples directory, then invoke
// this client with:
// java -cp .:packages TestClient
// while in the java directory. See the README for more detailed
// information. The COPYING file in the root directory of the
// distributions outlines the copyright terms for this code.
//
// Bugs, problems and suggestions to joakim@styx.net.

import java.net.*;
import java.io.*;
import java.util.*;
import net.styx.flux.comm.*;

public class TestClient {		 

    public static void main(String[] args) throws IOException {

	TTree ttree;
	TTreeComm comm;

	String token = new String("faan"); // This is the token we're going to listen for this later.

        InetAddress addr = InetAddress.getByName("localhost"); // We're going to connect to the local machine.
	
	System.out.println("adr = " + addr);

	DefaultListener listener = new InnerListener(); // Make a listener which will get all packages not registered elsewhere.
	
	comm = new TTreeComm(addr, 2150, listener); // Create a comm thread, which connects to port 2150. 

	comm.addListener( token.getBytes(), new InnerTokenListener() ); // Add a listener for the token.

	comm.addListener( token.getBytes(), new InnerTokenListener2() ); // Add another listener for the token.

	comm.addListener( token.getBytes(), new InnerTokenListener3() ); // Add a third listener for the token.
	    
	}

    static class InnerListener implements DefaultListener {

	public void tTreeReceived(TTree ttree, TTreeComm comm) { // Called if we get a default block.
	    printTTree(ttree, 0); // Print the tree.
	    comm.queueOutgoingTTree(ttree); // Then send it back.
	}

	public void tTreeReceived(TTree ttree, short transid, TTreeComm comm) {
	    System.out.println("Transaction start block received: " + transid);
	    printTTree(ttree, 0); // Print the tree.
	    Transaction trans = comm.startTransaction(ttree, new InnerListener2(), transid); // Create and register a listener to take care of the transaction from now on.
	    trans.write(ttree); // Send the tree back, using the transaction object.
	}
    }

    static class InnerListener2 implements TransactionListener {
	
	public void tTreeReceived(TTree ttree, Transaction trans) {
	    System.out.println("Block in registered transaction received.");
	    printTTree(ttree, 0); // Print the tree.
	}
    }

    static class InnerTokenListener implements TokenListener {
	public void tTreeReceived (TTree ttree, byte[] token, TTreeComm comm) {
	    System.out.println("Tokenlistener 1 got the token " + new String(token));
	    printTTree(ttree, 0); // Print the tree.
	}
    }

    static class InnerTokenListener2 implements TokenListener {
	public void tTreeReceived (TTree ttree, byte[] token, TTreeComm comm) {
	    System.out.println("Tokenlistener 2 got the token " + new String(token));
	    printTTree(ttree, 0); // Print the tree.
	    comm.removeListener(this); // We don't want to listen anymore.
	}
    }

    static class InnerTokenListener3 implements TokenListener {
	public void tTreeReceived (TTree ttree, byte[] token, TTreeComm comm) {
	    System.out.println("Tokenlistener 3 got the token " + new String(token));
	    printTTree(ttree, 0); // Print the tree.
	}
    }
    
    private static void printTTree(TTree ttree, int indent) {
	
	String indentstring = new String();
	byte token[];
	Vector children;
	
	for(int i=indent ; i>0 ; i--) {
	    indentstring = (indentstring + "  "); 
	}
	
	int tokenlength = ttree.getTokenLength();
	
	token = ttree.getToken();
	if (token != null) {
	    System.out.println(indentstring + "Token: " + new String(token));
	}
	
	int childcount = ttree.getChildCount();
	
	for(int i = 0 ; i < childcount ; i++) {
	    printTTree(ttree.getChildAt(i),1+indent);
	}
    }
}
