/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include "config.h"
#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>


/* Returns: FALSE = item list empty. TRUE = fetched item OK. */
int cgi_post_item_next(FILE *in_fhd, char *var, char *val, unsigned int maxlen)
{
  unsigned int i = 0;
  char c = fgetc(in_fhd);
  char ct;

  *var = 0; *var = 0;

  if (feof(in_fhd)) return(0);
  
  while (c != '=' && !feof(in_fhd) && i < maxlen)
  {
    if (c == EOF) return(0);  /* Premature EOF. */
    else if (c == '%')
    {
      if ((ct = fgetc(in_fhd)) != EOF)
      {
        if (isalpha(ct)) c = (tolower(ct) - 'a' + 10) << 4;
        else c = (ct - '0') << 4;
      }
      if ((ct = fgetc(in_fhd)) != EOF)
      {
        if (isalpha(ct)) c |= tolower(ct) - 'a' + 10;
        else c |= (ct - '0');
      }
      *var++ = c;
    }
    else if (c == '+')
    {
      *var++ = ' ';
    }
    else *var++ = c;

    i++;
    c = fgetc(in_fhd);
  }

  i = 0;
  *var = 0;
  c = fgetc(in_fhd);
  
  while (c != '&' && !feof(in_fhd) && i < maxlen)
  {
    if (c == EOF) break;  /* Premature EOF. */
    else if (c == '%')
    {
      if ((ct = fgetc(in_fhd)) != EOF)
      {
        if (isalpha(ct)) c = (tolower(ct) - 'a' + 10) << 4;
        else c = (ct - '0') << 4;
      }
      if ((ct = fgetc(in_fhd)) != EOF)
      {
        if (isalpha(ct)) c |= tolower(ct) - 'a' + 10;
        else c |= (ct - '0');
      }
      *val++ = c;
    }
    else if (c == '+')
    {
      *val++ = ' ';
    }
    else *val++ = c;

    i++;
    c = fgetc(in_fhd);
  }

  *val = 0;
  return(1);
}


/* On first call, walk_str should point to start of query string.
 * Pointers to the item and its data are set in the passed pointers.
 * 
 * Returns walk_str for next iteration, or NULL if there were no more items 
 * (in that case, item and data pointers are invalid).
 */

char *cgi_get_item_next(char *walk_str, char **item_str, char **data_str)
{
  size_t len;

  len = strcspn(walk_str, "=&");
  if (!len) return(0);
  *item_str = malloc(len + 1);
  strncpy(*item_str, walk_str, len);
  *(*item_str + len) = 0;
  if (!*(walk_str + len)) return(0);
  walk_str += len + 1;

  len = strcspn(walk_str, "=&");
  *data_str = malloc(len + 1);
  strncpy(*data_str, walk_str, len);
  *(*data_str + len) = 0;
  if (!*(walk_str + len)) return(walk_str + len);

  return(walk_str + len + 1);
}


/* Locates item_str in query_str, returning a pointer to a freshly allocated
 * string (its data), or NULL if the item wasn't found.
 */

char *cgi_get_item(char *query_str, char *item_str)
{
  char *data_str, *nitem_str, *temp_str;
  unsigned long len;

  if (!query_str) return(0);

  if (strncmp(query_str, item_str, strlen(item_str)))
  {
    nitem_str = malloc(strlen(item_str) + 2);
    if (!nitem_str) return(0);
    *nitem_str = '&'; *(nitem_str + 1) = 0;
    strcat(nitem_str, item_str);
    temp_str = strstr(query_str, nitem_str);
    free(nitem_str);
  }
  else temp_str = query_str;

  if (!temp_str) return(0);

  temp_str = strchr(temp_str, '=');
  if (!temp_str) return(0);

  temp_str++;
  len = strcspn(temp_str, "&");
  if (!len) return(0);

  data_str = malloc(len + 1);
  if (!data_str) return(0);

  strncpy(data_str, temp_str, len);
  *(data_str + len) = 0;

  return(data_str);
}
