/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include <config.h>
#include <stdlib.h>
#include <sys/time.h>
#include <sys/types.h>
#include <unistd.h>

 
#ifndef RAND_MAX   /* for SunOS */
#  define RAND_MAX 32767
#endif


int rand_gather_faked(unsigned char *dest, size_t length, int level)
{
  static int initialized = 0;
  size_t n;
  char *p;

  if (!initialized)
  {
    initialized = 1;
#ifdef HAVE_RAND
    srand(time(NULL) * getpid());
#else
    srandom(time(NULL) * getpid());
#endif
  }

  p = dest; n = length;
#ifdef HAVE_RAND
  while(n--)
    *p++ = ((unsigned) (1 + (int) (256.0 * rand() / (RAND_MAX + 1.0))) - 1);
#else
  while(n--)
    *p++ = ((unsigned) (1 + (int) (256.0 * random() / (RAND_MAX + 1.0))) - 1);
#endif

  return 0; /* okay */
}
