/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include "config.h"
#include <stdlib.h>
#include "cipher.h"
#include "random.h"


void rand_block(void *dest, unsigned long len, int level)
{
  unsigned char buf[20];
  unsigned char *buf_read;
  unsigned long len_read;
  
  if (len < 20)
  {
    len_read = 20;
    buf_read = buf;
  }
  else
  {
    len_read = len;
    buf_read = dest;
  }

#ifdef HAVE_DEV_RANDOM
  rand_gather_linux(buf_read, len_read, level);
#elif !defined(USE_RAND_W32)
  rand_gather_unix(buf_read, len_read, level);
#else
#warning Using weak, deterministic entropy generator.
  rand_gather_faked(buf_read, len_read, level);
#endif

  /* Mash the bits with RMD160 */

  for (; len >= 20; len -= 20) hash_rmd160(dest + len - 20, dest, len);

  if (len)
  {
    hash_rmd160(buf, buf_read, len_read);
    memcpy(dest, buf, len);
  }
}


int rand_bit(int level)
{
  unsigned char b;
  
  rand_block(&b, sizeof(b), level);
  return(((((b     ) ^ (b >> 1)) ^ ((b >> 2) ^ (b >> 3))) ^
          (((b >> 4) ^ (b >> 5)) ^ ((/* b >> 7 */ 0)))) & 0x01);
}


unsigned char rand_byte(int level)
{
  unsigned char b;
  
  rand_block(&b, sizeof(b), level);
  return(b);
}


unsigned short rand_short(int level)
{
  unsigned short b;
  
  rand_block(&b, sizeof(b), level);
  return(b);
}


unsigned long rand_long(int level)
{
  unsigned long b;
  
  rand_block(&b, sizeof(b), level);
  return(b);
}
