/* Copyright (C) 1999 Hans Petter K. Jansson
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 *
 * You can contact the library's author by sending e-mail to <hpj@styx.net>.
 */

#include "config.h"
#include "types.h"
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <unistd.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "log.h"
#include "rmd160.h"
#include "tt.h"


TT *tt_new()
{
  TT *tt;
  
  tt = malloc(sizeof(*tt));
  memset(tt, 0, sizeof(*tt));
  tt->handle = -1;

  return(tt);
}


TT *tt_new_with_data(void *src, int len)
{
  TT *tt;

  tt = tt_new();
  tt_data_set_internal(tt, src, len, TRUE);
  return(tt);
}


TT *tt_new_with_parent_and_data(TT *parent, void *src, int len)
{
  TT *tt;
  
  tt = tt_new_with_data(src, len);
  if (parent) tt_add(parent, tt);
  return(tt);
}


void tt_del(TT *tt)
{
  TT *tt_child, *tt_child_next;

  /* Delete children */

  for (tt_child = tt_get_first_child(tt); tt_child; tt_child = tt_child_next)
  {
    tt_child_next = tt_get_next(tt_child);
    tt_del(tt_child);
  }

  /* Delete self */
  tt_data_del(tt);
  
  /* Unlink */
  tt_detach(tt);

  /* Free self */
  free(tt);
}


TT *tt_dup(TT *tt)
{
  TT *tt_n;
  int len;

  tt_n = tt_new();

  tt_n->data_is_internal = tt->data_is_internal;
  tt_n->data_is_local = tt->data_is_local;
  tt_n->data_is_ready = tt->data_is_ready;
  tt_n->size = tt_size(tt);

  if (tt_has_data(tt))
  {
    if (tt_data_is_internal(tt))
    {
      if (tt_data_is_local(tt))
      {
        tt_n->data = malloc(tt_size(tt));
        memcpy(tt_n->data, tt_data_get(tt), tt_n->size);
      }
      else tt_n->data = tt->data;
    }
    else
    {
      len = strlen(tt->data);
      tt_n->data = malloc(len + 1);
      strcpy(tt_n->data, tt->data);
    }
  }
  else tt_n->data = 0;
  
  return(tt_n);
}


TT *tt_dup_all(TT *tt)
{
  TT *tt_n, *tt_child, *tt_n_child;

  /* Self */
  
  tt_n = tt_dup(tt);
  
  /* Children */
  
  for (tt_child = tt_get_first_child(tt); tt_child; tt_child = tt_get_next(tt_child))
  {  
    tt_n_child = tt_dup_all(tt_child);
    tt_add_as_last_child(tt_n, tt_n_child);
  }
  
  return(tt_n);
}
