#!/bin/sh -x
#
#  this script builds libfwbuilder and libfwbuilder-devel RPMs
#
#

RPMROOT=/var/tmp/libfwbuilder
EXPORTDIR=`pwd`/export


mkdir -p ${EXPORTDIR}

./configure --prefix=/usr || exit 1


DISTRO=`cat /etc/issue|grep release|sed 's/Linux.*$//; s/ //g'`

SPECFILE=libfwbuilder.spec
MAJOR_LIB_NUM=`awk '/%define major/ { print $3; }' $SPECFILE`
if [ "x$MAJOR_LIB_NUM" == "x\'\'" ]; then
MAJOR_LIB_NUM=""
fi

VERSION=`awk '/Version:/ { print $2; }' $SPECFILE`
SNAPSHOT_DIR=libfwbuilder${MAJOR_LIB_NUM}-${VERSION}
TAR_FILE=libfwbuilder${MAJOR_LIB_NUM}-${VERSION}.tar.gz


make distclean

if [ ! -f $SPECFILE ]; then
    echo "Can't find spec file"
    exit 1
fi



LIBFILES="acconfig.h               \
	  mkinstalldirs            \
	  libfwbuilder-config.h.in \
	  libfwbuilder-config.in   \
	  ltmain.sh                \
	  ltconfig                 \
	  aclocal.m4               \
	  acsite.m4                \
	  Makefile.in              \
	  config.sub               \
	  config.guess             \
	  configure                \
	  install.sh               \
	  configure.in             \
	  build_librpm.sh          \
	  libfwbuilder.spec.in     \
	  libfwbuilder.spec        \
	  doc                      \
	  etc                      \
	  migration                \
	  src"


cd ${EXPORTDIR}
rm -rf ${SNAPSHOT_DIR}
ln -s .. ${SNAPSHOT_DIR}

FILELIST=`for f in ${LIBFILES}; do echo ${SNAPSHOT_DIR}/$f; done`

tar -ch --exclude CVS --exclude *.bak -f - ${FILELIST}  | gzip > ${TAR_FILE} 
cd ..


echo " === Building libfwbuilder RPM version $VERSION === "

mkdir -p ${RPMROOT}
mkdir -p ${RPMROOT}/SOURCES
mkdir -p ${RPMROOT}/BUILD
mkdir -p ${RPMROOT}/SPECS
mkdir -p ${RPMROOT}/SRCS
mkdir -p ${RPMROOT}/RPMS
mkdir -p ${RPMROOT}/SRPMS

if [ ! -d $EXPORTDIR ]; then
    echo "Can't find export directory"
    exit 1
else

    cp ${EXPORTDIR}/${TAR_FILE} ${RPMROOT}/SOURCES
    cp ${SPECFILE} ${RPMROOT}/SPECS 
    cd ${RPMROOT}/SPECS

    DISTRO=`cat /etc/issue|grep release|sed 's/Linux.*$//; s/ //g'`
    if test "x${DISTRO}" == "xMandrake"; then
    	ARCH=`uname -m`
    	if [ "X$ARCH" = "Xi686" ]; then
		RPMARCH="--target i586"
    	fi
    fi

    rm -f .rpmmacros
    echo "%_topdir ${RPMROOT}" > .rpmmacros

    export HOME=`pwd`; rpm -ba $RPMARCH ${SPECFILE} 
fi

