/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: Host.cc,v 1.3 2001/12/19 12:46:32 lord Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <fwbuilder/FWObject.hh>
#include <fwbuilder/Interface.hh>

#include <fwbuilder/Host.hh>

#include <fwbuilder/XMLTools.hh>

using namespace std;
using namespace libfwbuilder;

const char *Host::TYPENAME={"Host"};

Host::Host()  
{
    setStr("address", "");
}

Host::~Host() 
{
  clearChildren();
}

void Host::fromXML(xmlNodePtr root)
{
    const char *n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("address")));
    assert(n!=NULL);
    setStr("address", n);

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("snmp_read_community")));
    if (n!=NULL) setStr("snmp_read_community", n);

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("snmp_write_community")));
    if (n!=NULL) setStr("snmp_write_community", n);

    FWObject::fromXML(root);
}

xmlNodePtr Host::toXML(xmlNodePtr parent)
{
    xmlNodePtr me = FWObject::toXML(parent, false);
    FWObject *o;

    vector<FWObject*> ol;
    vector<FWObject*>::iterator j;

    ol=getByType( Interface::TYPENAME );
    for(j=ol.begin(); j!=ol.end(); ++j) 
	if ( (o=(*j))!=NULL )
	    o->toXML(me);

    o=getFirstByType( HostOptions::TYPENAME );
    if (o) o->toXML(me);

    return me;
}


bool  Host::validateChild(FWObject *o)
{ 
    string otype=o->getTypeName();
    return (FWObject::validateChild(o) && 
	    (otype==Interface::TYPENAME || otype==HostOptions::TYPENAME) );
}


/*
 *  TODO:    Implement syntax checks for interfaces
 *
 */
bool Host::Appropriate(Interface *i)
{
  return true;
}

void Host::addInterface(Interface *i)
{
    add(i);
}

void Host::removeInterface(Interface *i)
{
    remove(i);
}

FWOptions* Host::getOptionsObject()
{
    return FWOptions::cast( getFirstByType(HostOptions::TYPENAME) );
}

void Host::setDefaults()
{
    FWOptions *fopt=getOptionsObject();

    if (!exists("snmp_read_community"))  setStr("snmp_read_community" , "public" );
    if (!exists("snmp_write_community")) setStr("snmp_write_community", "private");

    if (!fopt->exists("use_mac_addr"))
	fopt->setBool("use_mac_addr" , false);

}






