/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: Rule.cc,v 1.3 2001/12/19 12:47:01 lord Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#include <fwbuilder/FWObjectDatabase.hh>
#include <fwbuilder/Rule.hh>
#include <fwbuilder/RuleElement.hh>
#include <fwbuilder/Policy.hh>
#include <fwbuilder/FWOptions.hh>
#include <fwbuilder/XMLTools.hh>

#include <fwbuilder/Policy.hh>

using namespace std;
using namespace libfwbuilder;
 
const char *Rule::TYPENAME={"Rule"};

Rule::Rule()
{
    setInt("position",0);
    enable();
}

void Rule::setPosition(int n)
{
    setInt("position",n);
}

int  Rule::getPosition()
{
    return getInt("position");
}

FWOptions* Rule::getOptionsObject()
{
    return NULL;
}

void Rule::createAndAddRuleElement(const char* element_name)
{
    FWObject    *re;

    re=FWObjectDatabase::db->create(element_name);
    assert (re!=NULL);

    add(re);

    if ( RuleElement::cast(re)!=NULL )
	(RuleElement::cast(re))->setAnyElement();
}

void Rule::disable()
{
    setBool("disabled",true);
}

void Rule::enable()
{
    setBool("disabled",false);
}

bool Rule::isDisabled()
{
    return( getBool("disabled") );
}

/*
 *************************************************************************
 */


const char *PolicyRule::TYPENAME={"PolicyRule"};

PolicyRule::PolicyRule()
{
    setStr("action","Deny");
    setBool("log",true);
}

void PolicyRule::fromXML(xmlNodePtr root)
{
    const char* n;

    FWObject::fromXML(root);

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("position")));
    if(n)  setInt("position",atoi(n));

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("disabled")));
    if(n)  setStr("disabled",n);

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("action")));
    if(n)  setStr("action",n);

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("log")));
    if(n)  setStr("log",n);


    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("interface")));
    if(n)  setStr("interface",n);

    n= FROMXMLCAST(xmlGetProp(root,TOXMLCAST("direction")));
    if(n)  setStr("direction",n);

}

xmlNodePtr PolicyRule::toXML(xmlNodePtr parent)
{
    xmlNodePtr me = FWObject::toXML(parent, false);
    FWObject *o;
    
    if ( (o=getFirstByType( RuleElementSrc::TYPENAME ))!=NULL )
	o->toXML(me);

    if ( (o=getFirstByType( RuleElementDst::TYPENAME ))!=NULL )
	o->toXML(me);

    if ( (o=getFirstByType( RuleElementSrv::TYPENAME ))!=NULL )
	o->toXML(me);

    if ( (o=getFirstByType( RuleElementInterval::TYPENAME ))!=NULL )
	o->toXML(me);

    if ( (o=getFirstByType( PolicyRuleOptions::TYPENAME ))!=NULL )
	o->toXML(me);

    return me;
}

FWOptions* PolicyRule::getOptionsObject()
{
    return FWOptions::cast( getFirstByType(PolicyRuleOptions::TYPENAME) );
}


/*
 *************************************************************************
 */


const char *NATRule::TYPENAME={"NATRule"};

void NATRule::fromXML(xmlNodePtr root)
{
    const char* n;

    FWObject::fromXML(root);

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("disabled")));
    if(n)  setStr("disabled",n);

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("position")));
    if(n)  setStr("position",n);
}

xmlNodePtr NATRule::toXML(xmlNodePtr parent)
{
    xmlNodePtr me = FWObject::toXML(parent, false);
    FWObject *o;

    if ( (o=getFirstByType( RuleElementOSrc::TYPENAME ))!=NULL )
	o->toXML(me);

    if ( (o=getFirstByType( RuleElementODst::TYPENAME ))!=NULL )
	o->toXML(me);

    if ( (o=getFirstByType( RuleElementOSrv::TYPENAME ))!=NULL )
	o->toXML(me);

    if ( (o=getFirstByType( RuleElementTSrc::TYPENAME ))!=NULL )
	o->toXML(me);

    if ( (o=getFirstByType( RuleElementTDst::TYPENAME ))!=NULL )
	o->toXML(me);

    if ( (o=getFirstByType( RuleElementTSrv::TYPENAME ))!=NULL )
	o->toXML(me);

    if ( (o=getFirstByType( RuleElementInterval::TYPENAME ))!=NULL )
	o->toXML(me);


    if ( (o=getFirstByType( NATRuleOptions::TYPENAME ))!=NULL )
	o->toXML(me);

    return me;
}

FWOptions* NATRule::getOptionsObject()
{
    return FWOptions::cast( getFirstByType(NATRuleOptions::TYPENAME) );
}

