/* 

                          Firewall Builder

                 Copyright (C) 2000 Vadim Kurland

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: RuleElement.hh,v 1.3 2001/12/19 12:47:09 lord Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/


#ifndef __RULEELEMENT_HH_FLAG__
#define __RULEELEMENT_HH_FLAG__

#include <fwbuilder/Group.hh>
#include <fwbuilder/ObjectGroup.hh>
#include <fwbuilder/ServiceGroup.hh>
#include <fwbuilder/IntervalGroup.hh>

namespace libfwbuilder
{

class Rule; 
class FWReference;

class RuleElement : virtual public FWObject {

protected:

public:
    RuleElement();
    DECLARE_FWOBJECT_SUBTYPE(RuleElement);

    virtual void fromXML(xmlNodePtr parent);

    void      setAnyElement();
    virtual   std::string  getAnyElementId();
    bool      isAny();

    /**
     * Adds reference object pointing to 'obj' as a child of 'this'. If
     * RuleElement contained "any", it is removed
     */
    virtual void addRef(FWObject *obj);
    
    /**
     * Removes reference to given object among children of 'this'. If
     * this object was the last one, appropriate "any" object is added
     * instead
     */
    virtual void removeRef(FWObject *obj);

    bool   getNeg();
    void   setNeg(bool flag);
    void   toggleNeg();

};

class RuleElementSrc : public ObjectGroup, public RuleElement {
    public:
    DECLARE_FWOBJECT_SUBTYPE(RuleElementSrc);
    RuleElementSrc();
    virtual   std::string  getAnyElementId();
    virtual FWReference* createRef( FWObject* obj );
};

class RuleElementDst : public ObjectGroup, public RuleElement {
    public:
    DECLARE_FWOBJECT_SUBTYPE(RuleElementDst);
    RuleElementDst();
    virtual   std::string  getAnyElementId();
    virtual FWReference* createRef( FWObject* obj );
};

class RuleElementSrv : public ServiceGroup, public RuleElement {
    public:
    DECLARE_FWOBJECT_SUBTYPE(RuleElementSrv);
    RuleElementSrv();
    virtual   std::string  getAnyElementId();
    virtual FWReference* createRef( FWObject* obj );
};

class RuleElementInterval : public IntervalGroup, public RuleElement {
    public:
    DECLARE_FWOBJECT_SUBTYPE(RuleElementInterval);
    RuleElementInterval();
    virtual   std::string  getAnyElementId();
    virtual FWReference* createRef( FWObject* obj );
};

class RuleElementOSrc : public ObjectGroup, public RuleElement {
    public:
    DECLARE_FWOBJECT_SUBTYPE(RuleElementOSrc);
    RuleElementOSrc();
    virtual   std::string  getAnyElementId();
    virtual FWReference* createRef( FWObject* obj );
};

class RuleElementODst : public ObjectGroup, public RuleElement {
    public:
    DECLARE_FWOBJECT_SUBTYPE(RuleElementODst);
    RuleElementODst();
    virtual   std::string  getAnyElementId();
    virtual FWReference* createRef( FWObject* obj );
};

class RuleElementOSrv : public ServiceGroup, public RuleElement {
    public:
    DECLARE_FWOBJECT_SUBTYPE(RuleElementOSrv);
    RuleElementOSrv();
    virtual   std::string  getAnyElementId();
    virtual FWReference* createRef( FWObject* obj );
};

class RuleElementTSrc : public ObjectGroup, public RuleElement {
    public:
    DECLARE_FWOBJECT_SUBTYPE(RuleElementTSrc);
    RuleElementTSrc();
    virtual   std::string  getAnyElementId();
    virtual FWReference* createRef( FWObject* obj );
};

class RuleElementTDst : public ObjectGroup, public RuleElement {
    public:
    DECLARE_FWOBJECT_SUBTYPE(RuleElementTDst);
    RuleElementTDst();
    virtual   std::string  getAnyElementId();
    virtual FWReference* createRef( FWObject* obj );
};

class RuleElementTSrv : public ServiceGroup, public RuleElement {
    public:
    DECLARE_FWOBJECT_SUBTYPE(RuleElementTSrv);
    RuleElementTSrv();
    virtual   std::string  getAnyElementId();
    virtual FWReference* createRef( FWObject* obj );
};

}

#endif




