/* functions.c generated by valac, the Vala compiler
 * generated from functions.vala, do not modify */

/* functions.vala
 *
 * Copyright (C) 2009  Didier Villevalois, Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_COMPARABLE (gee_comparable_get_type ())
#define GEE_COMPARABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COMPARABLE, GeeComparable))
#define GEE_IS_COMPARABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COMPARABLE))
#define GEE_COMPARABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COMPARABLE, GeeComparableIface))

typedef struct _GeeComparable GeeComparable;
typedef struct _GeeComparableIface GeeComparableIface;

struct _GeeComparableIface {
	GTypeInterface parent_iface;
	gint (*compare_to) (GeeComparable* self, gconstpointer object);
};



GEqualFunc gee_functions_get_equal_func_for (GType t);
GHashFunc gee_functions_get_hash_func_for (GType t);
GType gee_comparable_get_type (void) G_GNUC_CONST;
gint gee_comparable_compare_to (GeeComparable* self, gconstpointer object);
gint gee_direct_compare (void* _val1, void* _val2);
GCompareFunc gee_functions_get_compare_func_for (GType t);



/**
 * Get a equality testing function for a given type.
 *
 * @param t the type which to get an equality testing function for.
 *
 * @return the equality testing function corresponding to the given type.
 */
#line 49 "functions.vala"
GEqualFunc gee_functions_get_equal_func_for (GType t) {
#line 67 "functions.c"
	GEqualFunc result = NULL;
#line 50 "functions.vala"
	if (t == G_TYPE_STRING) {
#line 71 "functions.c"
		result = g_str_equal;
#line 51 "functions.vala"
		return result;
#line 75 "functions.c"
	} else {
		result = g_direct_equal;
#line 53 "functions.vala"
		return result;
#line 80 "functions.c"
	}
}


/**
 * Get a hash function for a given type.
 *
 * @param t the type which to get the hash function for.
 *
 * @return the hash function corresponding to the given type.
 */
#line 64 "functions.vala"
GHashFunc gee_functions_get_hash_func_for (GType t) {
#line 94 "functions.c"
	GHashFunc result = NULL;
#line 65 "functions.vala"
	if (t == G_TYPE_STRING) {
#line 98 "functions.c"
		result = g_str_hash;
#line 66 "functions.vala"
		return result;
#line 102 "functions.c"
	} else {
		result = g_direct_hash;
#line 68 "functions.vala"
		return result;
#line 107 "functions.c"
	}
}


/**
 * Get a comparator function for a given type.
 *
 * @param t the type which to get a comparator function for.
 *
 * @return the comparator function corresponding to the given type.
 */
#line 79 "functions.vala"
GCompareFunc gee_functions_get_compare_func_for (GType t) {
#line 121 "functions.c"
	GCompareFunc result = NULL;
#line 80 "functions.vala"
	if (t == G_TYPE_STRING) {
#line 125 "functions.c"
		result = (GCompareFunc) g_strcmp0;
#line 81 "functions.vala"
		return result;
#line 129 "functions.c"
	} else {
#line 82 "functions.vala"
		if (g_type_is_a (t, GEE_TYPE_COMPARABLE)) {
#line 133 "functions.c"
			result = (GCompareFunc) gee_comparable_compare_to;
#line 83 "functions.vala"
			return result;
#line 137 "functions.c"
		} else {
			result = (GCompareFunc) gee_direct_compare;
#line 85 "functions.vala"
			return result;
#line 142 "functions.c"
		}
	}
}


/**
 * Compares two arbitrary elements together.
 *
 * The comparison is done on pointers and not on values behind.
 *
 * @param _val1 the first value to compare.
 * @param _val2 the second value to compare.
 *
 * @return a negative value if _val1 is lesser than _val2, a positive value
 *         if _val1 is greater then _val2 and zero if both are equal.
 */
#line 101 "functions.vala"
gint gee_direct_compare (void* _val1, void* _val2) {
#line 161 "functions.c"
	gint result = 0;
	glong val1;
	glong val2;
#line 102 "functions.vala"
	val1 = (glong) _val1;
#line 102 "functions.vala"
	val2 = (glong) _val2;
#line 103 "functions.vala"
	if (val1 > val2) {
#line 171 "functions.c"
		result = 1;
#line 104 "functions.vala"
		return result;
#line 175 "functions.c"
	} else {
#line 105 "functions.vala"
		if (val1 == val2) {
#line 179 "functions.c"
			result = 0;
#line 106 "functions.vala"
			return result;
#line 183 "functions.c"
		} else {
			result = -1;
#line 108 "functions.vala"
			return result;
#line 188 "functions.c"
		}
	}
}




