/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: AbstractCommandBuilder.java,v 1.7 2006/02/26 00:59:04 pietschy Exp $
 */
package org.pietschy.command;

import org.w3c.dom.Element;

/**
 * Base class for all command builders.  Command builders can be registered for any command subclass by calling
 * {@link BuilderRegistry#register(Class, AbstractCommandBuilder)}.
 *
 * @version $Revision: 1.7 $
 * @author andrewp
 */
public abstract class
AbstractCommandBuilder
extends AbstractBuilder
{
   // Constants and variables
   // -------------------------------------------------------------------------
   private static final String _ID_ = "$Id: AbstractCommandBuilder.java,v 1.7 2006/02/26 00:59:04 pietschy Exp $";

   public abstract void configure(Command command, Element commandElement);

}
