/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: ButtonManager.java,v 1.11 2006/02/26 00:59:04 pietschy Exp $
 */

package org.pietschy.command;

import javax.swing.*;
import java.util.Iterator;

/**
 * ButtonManagers are used by commands to manage all the buttons that have been registered with
 * a particular {@link Face}.
 */
class
ButtonManager
{

   protected WeakSet buttons = new WeakSet(10);

   private Command command;

   private HoverManager hoverManager;

   protected
   ButtonManager(Command command)
   {
      this.command = command;
      hoverManager = new HoverManager(command);
   }

   /**
    * Attaches this command to the button.  It is implemented using an
    * action adapter.  That it an adapter is created and {@link javax.swing.AbstractButton#setAction} is called.
    *
    * @param button the button to which this command should be attached.
    */
   public void
   attachAndConfigure(AbstractButton button)
   {
      if (buttons.add(button))
      {
         button.addMouseListener(hoverManager);
         button.addHierarchyListener(hoverManager);
      }
   }

   /**
    * Detaches this command from the specified button.
    *
    * @param button the button from which this command is to be detached.
    */
   public void
   detach(AbstractButton button)
   {
      buttons.remove(button);
      button.removeMouseListener(hoverManager);
      button.removeHierarchyListener(hoverManager);
   }


   public void
   detachAll()
   {
      buttons.removeAll();
   }

   public Iterator
   buttonIterator()
   {
      return buttons.iterator();
   }


}
