package org.pietschy.command.delegate;

import java.awt.*;

/**
 *
 */
public class FocusTrackingDelegateMediatorFactory implements DelegateMediatorFactory
{
   private RelatedWindowDiscriminator defaultRelatedWindowDiscriminator = new RelatedWindowDiscriminator()
   {
      public boolean isRelated(Window parent, Window other)
      {
         return parent.equals(other);
      }
   };

   public RelatedWindowDiscriminator getDefaultRelatedWindowDiscriminator()
   {
      return defaultRelatedWindowDiscriminator;
   }

   /**
    * Sets the discriminator to use when tracking focus events.  The discriminator is
    * used to determine if the currently focused window should be tracked for delegates
    * pertaining to DelegatingCommands bound to the parent window.
    * <p/>
    * The default discriminator only tracks delegates in the same window as the DelegatingCommand.
    *
    * @param defaultRelatedWindowDiscriminator the discriminator to use.
    * @throws NullPointerException if the discriminator is <code>null</code>.
    */
   public void setDefaultRelatedWindowDiscriminator(RelatedWindowDiscriminator defaultRelatedWindowDiscriminator)
   {
      this.defaultRelatedWindowDiscriminator = defaultRelatedWindowDiscriminator;
   }

   public DelegateMediator createDelegateTracker(Window targetWindow)
   {
      return new FocusTrackingDelegateMediator(targetWindow, defaultRelatedWindowDiscriminator);
   }
}
