/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: Demo.java,v 1.29 2007/01/12 23:05:26 pietschy Exp $
 */

package org.pietschy.command.demo;

import au.com.skypie.ui.BorderUtil;
import ch.randelshofer.quaqua.QuaquaManager;
import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import org.pietschy.command.ActionCommand;
import org.pietschy.command.CommandManager;
import org.pietschy.command.LoadException;
import org.pietschy.command.delegate.DelegateManager;
import org.pietschy.command.delegate.FocusTrackingDelegateMediatorFactory;
import org.pietschy.command.demo.face.FaceDemoPanel;
import org.pietschy.command.demo.group.GroupDemoPanel;
import org.pietschy.command.demo.toggle.ToggleDemoPanel;
import org.pietschy.command.demo.welcome.WelcomePanel;

import javax.swing.*;
import java.io.IOException;
import java.util.PropertyResourceBundle;

//import ch.randelshofer.quaqua.QuaquaManager;

public class
Demo
{
   static final String _ID_ = "$Id: Demo.java,v 1.29 2007/01/12 23:05:26 pietschy Exp $";

   private static Demo instance;
   private DemoFrame mainFrame;
   private ActionCommand exitCommand;

   public static Demo
   instance()
   {
      if (instance == null)
      {
         instance = new Demo();
         instance.initialize();
      }

      return instance;
   }

   private void initialize()
   {
//      CommandManager.setLoggerFactory(new PrintStreamLoggerFactory(System.out));
      BorderUtil.setStandardBorderPadding(4);
      CommandManager commandManager = CommandManager.defaultInstance();
      commandManager.setIconFactory(new MyAbstractReflectionIconFactory());

      // we'll use the special focus tracking delegate mediator..
      DelegateManager.setDelegateMediatorFactory(new FocusTrackingDelegateMediatorFactory());

      try
      {
         commandManager.setResourceBundle(new PropertyResourceBundle(getClass().getResourceAsStream("resource.properties")));
      }
      catch (IOException e)
      {
         throw new RuntimeException("Couldn't load resource bundle", e);
      }

      try
      {
         commandManager.load(getClass().getResource("general-commands.xml"));
      }
      catch (LoadException e)
      {
         throw new RuntimeException("Couldn't load command file", e);
      }

      new VisibleCommandGroup(commandManager);
      new EnableCommandGroup(commandManager);

      exitCommand = new ActionCommand("menu.file.exit")
      {
         protected void handleExecute()
         {
            System.exit(0);
         }
      };
      exitCommand.export();

      // create some dummy commands for all to share..
      new BeepCommand("shared-commands.command-one").export();
      new BeepCommand("shared-commands.command-two").export();
      new BeepCommand("shared-commands.command-three").export();
      new BeepCommand("shared-commands.command-four").export();

      new OpenUrlCommand(commandManager, "open-gc2",
                         "http://pietschy.com/products/gui-commands/index.html");

      new OpenUrlCommand(commandManager, "run-gc2-demo",
                         "http://pietschy.com/products/gui-commands/demo.html");
 
      new OpenUrlCommand(commandManager, "whats-new",
                         "http://pietschy.com/products/gui-commands/whats_new.html");


      mainFrame = new DemoFrame();

      WelcomePanel welcomePanel = new WelcomePanel();
      mainFrame.registerDemo(welcomePanel);
      mainFrame.registerDemo(new FaceDemoPanel());
      mainFrame.registerDemo(new GroupDemoPanel());
      mainFrame.registerDemo(new ToggleDemoPanel());
//      mainFrame.registerDemo(new UndoDemoPanel());
//      mainFrame.registerDemo(new FileDemoPanel());
//      mainFrame.registerDemo(new ScriptDemoPanel());

      welcomePanel.getSelector().setSelected(true);
   }

   private Demo()
   {

   }

   public DemoFrame
   getMainFrame()
   {
      return mainFrame;
   }

   public static void main(String[] args)
   {
      final Splash splash = new Splash();
      splash.setVisible(true);

      SwingUtilities.invokeLater(new Runnable()
      {
         public void run()
         {
            try
            {
               if (CommandManager.isMacOS())
               {
                  UIManager.setLookAndFeel(QuaquaManager.getLookAndFeelClassName());
               }
               else
               {
                  UIManager.setLookAndFeel(PlasticLookAndFeel.class.getName());
               }

               UIManager.put("MenuItem.acceleratorDelimiter", "+");
            }
            catch (Exception e)
            {
               throw new RuntimeException("Couldn't load L&F", e);
            }

            Demo.instance().getMainFrame().setVisible(true);

            splash.setVisible(false);
            splash.dispose();
         }
      });


   }


}
