/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: GroupIcon.java,v 1.4 2005/10/18 03:01:33 pietschy Exp $
 */
package org.pietschy.command.demo.group;

import javax.swing.*;
import java.awt.*;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;

/**
 *
 * @version $Revision: 1.4 $
 * @author andrewp
 */
public class
GroupIcon
implements Icon
{
   private static final int WIDTH = 20;
   private static final int HEIGHT = 15;

   private Color fillColor = new Color(180,180,170);
   private String string;

   public GroupIcon(char character)
   {
      string = Character.toString(character);
   }

   public void paintIcon(Component c, Graphics g, int x, int y)
   {
      Graphics2D g2 = (Graphics2D) g;
      Color oldColor = g2.getColor();
      Stroke oldStroke = g2.getStroke();
      Object oldAliasing = g2.getRenderingHint(RenderingHints.KEY_ANTIALIASING);

      g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);


      g2.setColor(fillColor);
      g2.fillRoundRect(x, y, WIDTH, HEIGHT, 4, 4);

      g2.setColor(fillColor.darker());
      g2.setStroke(new BasicStroke(1f));
      g2.drawRoundRect(x, y, WIDTH, HEIGHT, 4, 4);

      g2.setColor(Color.BLACK);
      Font f = c.getFont().deriveFont(Font.BOLD);
      TextLayout tl = new TextLayout(string, f, g2.getFontRenderContext());
      Rectangle2D b = tl.getBounds();

      tl.draw(g2, (float) (x + (WIDTH - b.getWidth())/2), (float) (y + (HEIGHT + b.getHeight())/2));


      g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, oldAliasing);
      g2.setStroke(oldStroke);
      g2.setColor(oldColor);
   }

   public int getIconWidth()
   {
      return WIDTH+1;
   }

   public int getIconHeight()
   {
      return HEIGHT+1;
   }
}
