/**
 * GUI Commands
 * Copyright 2004 Andrew Pietsch
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * $Id: PrintStreamLoggerFactory.java,v 1.3 2004/12/12 05:29:33 pietschy Exp $
 */

package org.pietschy.command.log;

import java.io.PrintStream;

public class
PrintStreamLoggerFactory implements LoggerFactory
{
   static final String _ID_ = "$Id: PrintStreamLoggerFactory.java,v 1.3 2004/12/12 05:29:33 pietschy Exp $";

   PrintStream out;

   public PrintStreamLoggerFactory(PrintStream out)
   {
      this.out = out;
   }

   public Logger getLogger(Class aClass)
   {
      return new PrintStreamLogger(aClass, out);
   }
}
