/*
 * Decompiled with CFR 0.152.
 */
package org.jgraph.graph;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.JComponent;
import javax.swing.UIManager;
import org.jgraph.JGraph;
import org.jgraph.graph.CellView;
import org.jgraph.graph.CellViewRenderer;
import org.jgraph.graph.GraphConstants;
import org.jgraph.graph.PortView;

public class PortRenderer
extends JComponent
implements CellViewRenderer,
Serializable {
    protected transient JGraph graph;
    protected transient PortView view;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;

    public PortRenderer() {
        this.setForeground(UIManager.getColor("MenuItem.selectionBackground"));
        this.setBackground(UIManager.getColor("Tree.selectionBorderColor"));
    }

    public Component getRendererComponent(JGraph jGraph, CellView cellView, boolean bl, boolean bl2, boolean bl3) {
        if (cellView instanceof PortView && jGraph != null) {
            this.graph = jGraph;
            this.view = (PortView)cellView;
            this.hasFocus = bl2;
            this.selected = bl;
            this.preview = bl3;
            return this;
        }
        return null;
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        graphics.setColor(this.graph.getBackground());
        graphics.setXORMode(this.graph.getBackground());
        super.paint(graphics);
        if (this.preview) {
            graphics.fill3DRect(0, 0, dimension.width, dimension.height, true);
        } else {
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        boolean bl = GraphConstants.getOffset(this.view.getAllAttributes()) != null;
        graphics.setColor(this.getForeground());
        if (!bl) {
            graphics.fillRect(1, 1, dimension.width - 2, dimension.height - 2);
        } else if (!this.preview) {
            graphics.drawRect(1, 1, dimension.width - 3, dimension.height - 3);
        }
    }

    public void validate() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "text") {
            super.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, byte by, byte by2) {
    }

    public void firePropertyChange(String string, char c, char c2) {
    }

    public void firePropertyChange(String string, short s, short s2) {
    }

    public void firePropertyChange(String string, int n, int n2) {
    }

    public void firePropertyChange(String string, long l, long l2) {
    }

    public void firePropertyChange(String string, float f, float f2) {
    }

    public void firePropertyChange(String string, double d, double d2) {
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }
}

