------------------------------------------------------------------------------
--                                  Log4Ada                                 --
--                                                                          --
--                            Copyright (C) 2007                            --
--                              X. Grave CNRS                               --
--                                                                          --
--  This library is free software; you can redistribute it and/or modify    --
--  it under the terms of the GNU General Public License as published by    --
--  the Free Software Foundation; either version 2 of the License, or (at   --
--  your option) any later version.                                         --
--                                                                          --
--  This library is distributed in the hope that it will be useful, but     --
--  WITHOUT ANY WARRANTY; without even the implied warranty of              --
--  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       --
--  General Public License for more details.                                --
--                                                                          --
--  You should have received a copy of the GNU General Public License       --
--  along with this library; if not, write to the Free Software Foundation, --
--  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.          --
--                                                                          --
with Ada.Text_IO;

package body Log4ada.Appenders.Consoles is

   ------------
   -- Append --
   ------------

   procedure Append
     (Console : not null access Console_Type;
      Event : Events.Event_Type)
   is
      Timestamp_Diff : Integer;
      use Events;
   begin
      if not Console.Enabled then
         return;
      end if;
      if not Continue (Console, Event) then
         return;
      end if;
      Timestamp_Diff := Get_Timestamp (Event) - Events.First_Event_Timestamp;
      Ada.Text_IO.Put (Timestamp_Diff'Img & " ");
      Ada.Text_IO.Put (Get_Level (Event)'Img & " [");
      Ada.Text_IO.Put (Get_Location_Information (Event) & "] ");
      Ada.Text_IO.Put (Get_Logger_Name (Event) & " - ");
      Ada.Text_IO.Put (Get_Message (Event));
      if Exception_Present (Event) then
         Ada.Text_IO.Put (" - " & Get_Exception_Name (Event));
         Ada.Text_IO.Put_Line (" - " & Get_Exception_Message (Event));
      else
         Ada.Text_IO.New_Line;
      end if;
   end Append;

end Log4ada.Appenders.Consoles;
