/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef LIBPOLYXMASS_PROP_H
#define LIBPOLYXMASS_PROP_H


#include "libpolyxmass-globals.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


  typedef struct _PxmProp PxmProp;
  typedef enum _PxmDefaultPropCmp PxmDefaultPropCmp;
  typedef enum _PxmDefaultPropDup PxmDefaultPropDup;


  enum
    {
      PROP_NAME,
      PROP_DATA,
      PROP_BOTH
    };

  /* In cases where we have slots that still have no specific 
     comparison function peculiarities, we have the value below.
  */
# define PXM_UNDEF_PROP_CMP 1000
  
  /* The PxmDefaultPropCmp enum encompasses the first byte of the 
     gint enum (from 0 to 1 << 7).

     Thus prop-specific values must start with 1 << 8 (see
     libpolyxmass-note.h, for example).
  */
  enum _PxmDefaultPropCmp
    {
      PXM_DEFAULT_PROP_CMP_NONE = 0,   
      PXM_DEFAULT_PROP_CMP_NAME = 1 << 0,
      PXM_DEFAULT_PROP_CMP_DATA = 1 << 1,
      PXM_DEFAULT_PROP_CMP_DEEP = 1 << 2, 
      PXM_DEFAULT_PROP_CMP_DATA_SUBSET1 = 1 << 3,
      PXM_DEFAULT_PROP_CMP_DATA_SUBSET2 = 1 << 4,
      /* 
	 Values 1 << 5 and 1 << 6 and 1 << 7 are reserved.
      */
    };
  
  enum _PxmDefaultPropDup
    {
      PXM_DEFAULT_PROP_DUP_NODEEP = 0,
      PXM_DEFAULT_PROP_DUP_DEEP,
    };


  struct _PxmProp
  {
    gchar *name;
  
    gpointer data;
  
    PxmProp *(*custom_dup) (PxmProp *prop, gint how_dup);
  
    gint (*custom_cmp) (PxmProp *prop1, PxmProp *prop2, gint how_cmp);
  
    gint (*custom_free) (PxmProp *prop);
  
  };



  /* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
   */
  PxmProp*
  libpolyxmass_prop_new (void);

  PxmProp *
  libpolyxmass_prop_dup (PxmProp *prop, gint how_dup);

  PxmProp *
  libpolyxmass_prop_both_strings_new (gchar *name, gchar *data);

  PxmProp *
  libpolyxmass_prop_default_dup (PxmProp *prop, gint how_dup);

  GPtrArray *
  libpolyxmass_prop_GPA_dup (GPtrArray *GPA, gint how_dup);
  
  gint 
  libpolyxmass_prop_GPA_copy (GPtrArray *destGPA, GPtrArray *srcGPA);
  



  /* DATA MODIFYING FUNCTIONS
   */
  gchar *
  libpolyxmass_prop_set_name (PxmProp *prop, gchar *name);




  /* LOCATING FUNCTIONS
   */
  PxmProp * 
  libpolyxmass_prop_find_prop (GPtrArray *GPA,
			   gint *idx,
			   gint (* libpolyxmass_prop_find_cmp_func) (),
			   gchar *name,
			   gpointer data,
			   gint how_cmp);
  



  /* COMPARISON FUNCTIONS
   */
  gint
  libpolyxmass_prop_cmp (PxmProp *prop1, PxmProp *prop2, gint how_cmp);
  
  gint
  libpolyxmass_prop_default_cmp (PxmProp *prop1,
			     PxmProp *prop2,
			     gint how_cmp);
  
 

  /* RENDERING FUNCTIONS - FORMATTER FUNCTIONS
   */
  gchar *
  libpolyxmass_prop_format_xml_prop_default (PxmProp *prop,
					     gchar *indent,
					     gint offset,
					     gpointer user_data);
  
  
  PxmProp *
  libpolyxmass_prop_render_xml_prop_default (xmlDocPtr xml_doc,
					     xmlNodePtr xml_node,
					     gpointer user_data);
  
  
  
  


  /* FREE'ING FUNCTIONS
   */
  gint 
  libpolyxmass_prop_free (PxmProp *prop);

  gint 
  libpolyxmass_prop_default_free (PxmProp *prop);

  gint 
  libpolyxmass_prop_free_but_not_data (PxmProp *prop);

  gint 
  libpolyxmass_prop_GPA_free (GPtrArray *GPA);



#ifdef __cplusplus
}
#endif /* __cplusplus */



#endif






