//******************************************************************************
//  Copyright (c) 2005-2010 by Jan Van hijfte
//
//  See the included file COPYING.TXT for details about the copyright.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//******************************************************************************


#include "qlabel_c.h"

QLabelH QLabel_create(QWidgetH parent, unsigned int f)
{
	return (QLabelH) new QLabel((QWidget*)parent, (Qt::WindowFlags)f);
}

void QLabel_destroy(QLabelH handle)
{
	delete (QLabel *)handle;
}

QLabelH QLabel_create2(PWideString text, QWidgetH parent, unsigned int f)
{
	QString t_text;
	copyPWideStringToQString(text, t_text);
	return (QLabelH) new QLabel(t_text, (QWidget*)parent, (Qt::WindowFlags)f);
}

void QLabel_text(QLabelH handle, PWideString retval)
{
	QString t_retval;
	t_retval = ((QLabel *)handle)->text();
	copyQStringToPWideString(t_retval, retval);
}

const QPixmapH QLabel_pixmap(QLabelH handle)
{
	return (const QPixmapH) ((QLabel *)handle)->pixmap();
}

const QPictureH QLabel_picture(QLabelH handle)
{
	return (const QPictureH) ((QLabel *)handle)->picture();
}

QMovieH QLabel_movie(QLabelH handle)
{
	return (QMovieH) ((QLabel *)handle)->movie();
}

Qt::TextFormat QLabel_textFormat(QLabelH handle)
{
	return (Qt::TextFormat) ((QLabel *)handle)->textFormat();
}

void QLabel_setTextFormat(QLabelH handle, Qt::TextFormat p1)
{
	((QLabel *)handle)->setTextFormat(p1);
}

unsigned int QLabel_alignment(QLabelH handle)
{
	return (unsigned int) ((QLabel *)handle)->alignment();
}

void QLabel_setAlignment(QLabelH handle, unsigned int p1)
{
	((QLabel *)handle)->setAlignment((Qt::Alignment)p1);
}

void QLabel_setWordWrap(QLabelH handle, bool on)
{
	((QLabel *)handle)->setWordWrap(on);
}

bool QLabel_wordWrap(QLabelH handle)
{
	return (bool) ((QLabel *)handle)->wordWrap();
}

int QLabel_indent(QLabelH handle)
{
	return (int) ((QLabel *)handle)->indent();
}

void QLabel_setIndent(QLabelH handle, int p1)
{
	((QLabel *)handle)->setIndent(p1);
}

int QLabel_margin(QLabelH handle)
{
	return (int) ((QLabel *)handle)->margin();
}

void QLabel_setMargin(QLabelH handle, int p1)
{
	((QLabel *)handle)->setMargin(p1);
}

bool QLabel_hasScaledContents(QLabelH handle)
{
	return (bool) ((QLabel *)handle)->hasScaledContents();
}

void QLabel_setScaledContents(QLabelH handle, bool p1)
{
	((QLabel *)handle)->setScaledContents(p1);
}

void QLabel_sizeHint(QLabelH handle, PSize retval)
{
	*(QSize *)retval = ((QLabel *)handle)->sizeHint();
}

void QLabel_minimumSizeHint(QLabelH handle, PSize retval)
{
	*(QSize *)retval = ((QLabel *)handle)->minimumSizeHint();
}

void QLabel_setBuddy(QLabelH handle, QWidgetH p1)
{
	((QLabel *)handle)->setBuddy((QWidget*)p1);
}

QWidgetH QLabel_buddy(QLabelH handle)
{
	return (QWidgetH) ((QLabel *)handle)->buddy();
}

int QLabel_heightForWidth(QLabelH handle, int p1)
{
	return (int) ((QLabel *)handle)->heightForWidth(p1);
}

bool QLabel_openExternalLinks(QLabelH handle)
{
	return (bool) ((QLabel *)handle)->openExternalLinks();
}

void QLabel_setOpenExternalLinks(QLabelH handle, bool open)
{
	((QLabel *)handle)->setOpenExternalLinks(open);
}

void QLabel_setTextInteractionFlags(QLabelH handle, unsigned int flags)
{
	((QLabel *)handle)->setTextInteractionFlags((Qt::TextInteractionFlags)flags);
}

unsigned int QLabel_textInteractionFlags(QLabelH handle)
{
	return (unsigned int) ((QLabel *)handle)->textInteractionFlags();
}

void QLabel_setText(QLabelH handle, PWideString p1)
{
	QString t_p1;
	copyPWideStringToQString(p1, t_p1);
	((QLabel *)handle)->setText(t_p1);
}

void QLabel_setPixmap(QLabelH handle, const QPixmapH p1)
{
	((QLabel *)handle)->setPixmap(*(const QPixmap*)p1);
}

void QLabel_setPicture(QLabelH handle, const QPictureH p1)
{
	((QLabel *)handle)->setPicture(*(const QPicture*)p1);
}

void QLabel_setMovie(QLabelH handle, QMovieH movie)
{
	((QLabel *)handle)->setMovie((QMovie*)movie);
}

void QLabel_setNum(QLabelH handle, int p1)
{
	((QLabel *)handle)->setNum(p1);
}

void QLabel_setNum2(QLabelH handle, double p1)
{
	((QLabel *)handle)->setNum(p1);
}

void QLabel_clear(QLabelH handle)
{
	((QLabel *)handle)->clear();
}

