/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

namespace libsbml {

 using System;
 using System.Runtime.InteropServices;

/** 
 * @sbmlpackage{core}
 *
@htmlinclude pkg-marker-core.html A helper class for controlling the behavior of the
 * text-string formula parser.
 *
 * @htmlinclude not-sbml-warning.html
 *
 * The function
 * @if clike SBML_parseL3FormulaWithSettings()@endif@if csharp SBML_parseL3FormulaWithSettings()@endif@if python libsbml.parseL3FormulaWithSettings()@endif@if java <code><a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'>libsbml.parseL3FormulaWithSettings(String formula, L3ParserSettings settings)</a></code>@endif,
 * along with its variants 
 * @if clike libsbmlcs.libsbml.parseFormula()@endif@if csharp libsbmlcs.libsbml.parseFormula()@endif@if python libsbml.parseFormula()@endif@if java <code><a href='libsbml.html#parseFormula(java.lang.String)'>libsbml.parseFormula(java.lang.String formula)</a></code>@endif
 * and
 * @if clike SBML_parseL3FormulaWithModel()@endif@if csharp SBML_parseL3FormulaWithModel()@endif@if python libsbml.parseL3FormulaWithModel()@endif@if java <code><a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'>libsbml.parseL3FormulaWithModel(String formula, Model model)</a></code>@endif,
 * are the interfaces to a parser for mathematical formulas expressed as
 * text strings.  The parser converts the text-string formulas into
 * Abstract Syntax Trees (ASTs), represented in libSBML using ASTNode
 * objects. Compared to the parser implemented by the function
 * @if clike libsbmlcs.libsbml.parseFormula()@endif@if csharp libsbmlcs.libsbml.parseFormula()@endif@if python libsbml.parseFormula()@endif@if java <code><a href='libsbml.html#parseFormula(java.lang.String)'>libsbml.parseFormula(java.lang.String formula)</a></code>@endif,
 * which was designed primarily for converting the mathematical formula
 * strings in SBML Level&nbsp;1, the 'L3' variant of the parser accepts an
 * extended formula syntax.  It also has a number of configurable behaviors.
 * This class (L3ParserSettings) is an object used to communicate the
 * configuration settings with callers.
 *
 * The following aspects of the parser are configurable:
 * <ul>
 * <li> The function @c log with a single argument (&quot;<code>log(x)</code>&quot;) 
 * can be parsed as <code>log10(x)</code>, <code>ln(x)</code>, or treated
 * as an error, as desired.
 * <li> Unary minus signs can be collapsed or preserved; that is,
 * sequential pairs of unary minuses (e.g., &quot;<code>- -3</code>&quot;)
 * can be removed from the input entirely and single unary minuses can be
 * incorporated into the number node, or all minuses can be preserved in
 * the AST node structure.
 * <li> Parsing of units embedded in the input string can be turned on and
 * off.
 * <li> The string @c avogadro can be parsed as a MathML @em csymbol or
 * as an identifier.
 * <li> A Model object may optionally be provided to the parser using
 * the variant function call @if clike  SBML_parseL3FormulaWithModel()@endif@if csharp  SBML_parseL3FormulaWithModel()@endif@if python  libsbml.SBML_parseL3FormulaWithModel()@endif@if java <code><a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'>libsbml.parseL3FormulaWithModel(String formula, Model model)</a></code>@endif.
 * or stored in a L3ParserSettings object passed to the variant function
 * @if clike SBML_parseL3FormulaWithSettings()@endif@if csharp SBML_parseL3FormulaWithSettings()@endif@if python libsbml.parseL3FormulaWithSettings()@endif@if java <code><a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'>libsbml.parseL3FormulaWithSettings(String formula, org.sbml.libsbml.L3ParserSettings settings)</a></code>@endif.
 * When a Model object is provided, identifiers (values of type @c SId)
 * from that model are used in preference to pre-defined MathML
 * definitions.  More precisely, the Model entities whose identifiers will
 * shadow identical symbols in the mathematical formula are: Species,
 * Compartment, Parameter, Reaction, and SpeciesReference.  For instance,
 * if the parser is given a Model containing a Species with the identifier
 * &quot;<code>pi</code>&quot;, and the formula to be parsed is
 * &quot;<code>3*pi</code>&quot;, the MathML produced will contain the
 * construct <code>&lt;ci&gt; pi &lt;/ci&gt;</code> instead of the
 * construct <code>&lt;pi/&gt;</code>.
 * <li> Similarly, when a Model object is provided, @c SId values of
 * user-defined functions present in the Model will be used preferentially
 * over pre-defined MathML functions.  For example, if the passed-in Model
 * contains a FunctionDefinition with the identifier
 * &quot;<code>sin</code>&quot;, that function will be used instead of the
 * predefined MathML function <code>&lt;sin/&gt;</code>.
 * </ul>
 *
 * To obtain the default configuration values, callers can use the function
 * @if clike SBML_getDefaultL3ParserSettings()@endif@if csharp SBML_getDefaultL3ParserSettings()@endif@if python libsbml.SBML_getDefaultL3ParserSettings()@endif@if java <code><a href='libsbml.html#getDefaultL3ParserSettings()'>libsbml.getDefaultL3ParserSettings()</a></code>@endif.
 * To change the configuration, callers can create an L3ParserSettings
 * object, set the desired characteristics using the methods
 * provided, and pass that object to
 * @if clike SBML_parseL3FormulaWithSettings()@endif@if csharp SBML_parseL3FormulaWithSettings()@endif@if python libsbml.parseL3FormulaWithSettings()@endif@if java <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String formula, L3ParserSettings settings)</code></a>@endif.
 *
 * @if clike @see SBML_parseL3FormulaWithSettings()
 * @see SBML_parseL3Formula()
 * @see SBML_parseL3FormulaWithModel()
 * @endif
 * @if csharp @see SBML_parseL3FormulaWithSettings()
 * @see SBML_parseL3Formula()
 * @see SBML_parseL3FormulaWithModel()
 * @endif
 * @if python @see libsbml.parseL3FormulaWithSettings()
 * @see libsbml.parseL3Formula()
 * @see libsbml.parseL3FormulaWithModel()
 * @endif
 * @if java @see <code><a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'>libsbml.parseL3FormulaWithSettings(String formula, L3ParserSettings settings)</a></code>
 * @see <code><a href='libsbml.html#parseL3Formula(java.lang.String)'>libsbml.parseL3Formula(String formula)</a></code>
 * @see <code><a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'>parseL3FormulaWithModel(String formula, Model model)</a></code>
 * @endif
 */

public class L3ParserSettings : IDisposable {
	private HandleRef swigCPtr;
	protected bool swigCMemOwn;
	
	internal L3ParserSettings(IntPtr cPtr, bool cMemoryOwn)
	{
		swigCMemOwn = cMemoryOwn;
		swigCPtr    = new HandleRef(this, cPtr);
	}
	
	internal static HandleRef getCPtr(L3ParserSettings obj)
	{
		return (obj == null) ? new HandleRef(null, IntPtr.Zero) : obj.swigCPtr;
	}
	
	internal static HandleRef getCPtrAndDisown (L3ParserSettings obj)
	{
		HandleRef ptr = new HandleRef(null, IntPtr.Zero);
		
		if (obj != null)
		{
			ptr             = obj.swigCPtr;
			obj.swigCMemOwn = false;
		}
		
		return ptr;
	}

  ~L3ParserSettings() {
    Dispose();
  }

  public virtual void Dispose() {
    lock(this) {
      if (swigCPtr.Handle != IntPtr.Zero) {
        if (swigCMemOwn) {
          swigCMemOwn = false;
          libsbmlPINVOKE.delete_L3ParserSettings(swigCPtr);
        }
        swigCPtr = new HandleRef(null, IntPtr.Zero);
      }
      GC.SuppressFinalize(this);
    }
  }

  
/**
   * Creates a new L3ParserSettings object with default values.
   * 
   * This is the default constructor for the L3ParserSettings object.  It
   * sets the Model to @c null and other settings to @c
   * L3P_PARSE_LOG_AS_LOG10, @c L3P_EXPAND_UNARY_MINUS, @c L3P_PARSE_UNITS,
   * and @c L3P_AVOGADRO_IS_CSYMBOL.
   */ public
 L3ParserSettings() : this(libsbmlPINVOKE.new_L3ParserSettings__SWIG_0(), true) {
  }

  
/**
   * Creates a new L3ParserSettings object with specific values for all
   * possible settings.
   *
   * @param model a Model object to be used for disambiguating identifiers
   * 
   * @param parselog a flag that controls how the parser will handle
   * the symbol @c log in formulas
   *
   * @param collapseminus a flag that controls how the parser will handle
   * minus signs
   *
   * @param parseunits a flag that controls how the parser will handle
   * apparent references to units of measurement associated with raw
   * numbers in a formula
   *
   * @param avocsymbol a flag that controls how the parser will handle
   * the appearance of the symbol @c avogadro in a formula
   *
   * @see getModel()
   * @see setModel(@if java Model model@endif)
   * @see unsetModel()
   * @see getParseLog()
   * @see setParseLog(@if java int type@endif)
   * @see getParseUnits()
   * @see setParseUnits(@if java bool units@endif)
   * @see getParseCollapseMinus()
   * @see setParseCollapseMinus(@if java bool collapseminus@endif)
   * @see getParseAvogadroCsymbol()
   * @see setParseAvogadroCsymbol(@if java bool l2only@endif)
   */ public
 L3ParserSettings(Model model, int parselog, bool collapseminus, bool parseunits, bool avocsymbol) : this(libsbmlPINVOKE.new_L3ParserSettings__SWIG_1(Model.getCPtr(model), parselog, collapseminus, parseunits, avocsymbol), true) {
  }

  
/**
   * Sets the model reference in this L3ParserSettings object.
   *
   * When a Model object is provided, identifiers (values of type @c SId)
   * from that model are used in preference to pre-defined MathML
   * definitions.  More precisely, the Model entities whose identifiers will
   * shadow identical symbols in the mathematical formula are: Species,
   * Compartment, Parameter, Reaction, and SpeciesReference.  For instance,
   * if the parser is given a Model containing a Species with the identifier
   * &quot;<code>pi</code>&quot;, and the formula to be parsed is
   * &quot;<code>3*pi</code>&quot;, the MathML produced will contain the
   * construct <code>&lt;ci&gt; pi &lt;/ci&gt;</code> instead of the
   * construct <code>&lt;pi/&gt;</code>.
   * Similarly, when a Model object is provided, @c SId values of
   * user-defined functions present in the Model will be used preferentially
   * over pre-defined MathML functions.  For example, if the passed-in Model
   * contains a FunctionDefinition with the identifier
   * &quot;<code>sin</code>&quot;, that function will be used instead of the
   * predefined MathML function <code>&lt;sin/&gt;</code>.
   *
   * @param model a Model object to be used for disambiguating identifiers
   *
   * @warning <span class='warning'>This does @em not copy the Model object.
   * This means that modifications made to the object after invoking this
   * method may affect parsing behavior.</span>
   *
   * @see getModel()
   * @see unsetModel()
   */ public
 void setModel(Model model) {
    libsbmlPINVOKE.L3ParserSettings_setModel(swigCPtr, Model.getCPtr(model));
  }

  
/**
   * Returns the Model object referenced by this L3ParserSettings object.
   *
   * @see setModel(@if java Model model@endif)
   * @see unsetModel()
   */ public
 Model getModel() {
    IntPtr cPtr = libsbmlPINVOKE.L3ParserSettings_getModel(swigCPtr);
    Model ret = (cPtr == IntPtr.Zero) ? null : new Model(cPtr, false);
    return ret;
  }

  
/**
   * Sets the Model reference in this L3ParserSettings object to @c null.
   *
   * @see setModel(@if java Model model@endif)
   * @see getModel()
   */ public
 void unsetModel() {
    libsbmlPINVOKE.L3ParserSettings_unsetModel(swigCPtr);
  }

  
/**
   * Sets the behavior for handling @c log in mathematical formulas.
   *
   * The function @c log with a single argument
   * (&quot;<code>log(x)</code>&quot;) can be parsed as
   * <code>log10(x)</code>, <code>ln(x)</code>, or treated as an error, as
   * desired.
   *
   * @param type a constant, one of following three possibilities:
   * @li @link libsbmlcs.libsbml.L3P_PARSE_LOG_AS_LOG10 L3P_PARSE_LOG_AS_LOG10@endlink
   * @li @link libsbmlcs.libsbml.L3P_PARSE_LOG_AS_LN L3P_PARSE_LOG_AS_LN@endlink
   * @li @link libsbmlcs.libsbml.L3P_PARSE_LOG_AS_ERROR L3P_PARSE_LOG_AS_ERROR@endlink
   *
   * @see getParseLog()
   */ public
 void setParseLog(int type) {
    libsbmlPINVOKE.L3ParserSettings_setParseLog(swigCPtr, type);
  }

  
/**
   * Returns the current setting indicating what to do with formulas
   * containing the function @c log with one argument.
   *
   * The function @c log with a single argument
   * (&quot;<code>log(x)</code>&quot;) can be parsed as
   * <code>log10(x)</code>, <code>ln(x)</code>, or treated as an error, as
   * desired.
   *
   * @return One of following three constants:
   * @li @link libsbmlcs.libsbml.L3P_PARSE_LOG_AS_LOG10 L3P_PARSE_LOG_AS_LOG10@endlink
   * @li @link libsbmlcs.libsbml.L3P_PARSE_LOG_AS_LN L3P_PARSE_LOG_AS_LN@endlink
   * @li @link libsbmlcs.libsbml.L3P_PARSE_LOG_AS_ERROR L3P_PARSE_LOG_AS_ERROR@endlink
   *
   * @see setParseLog(@if java int type@endif)
   */ public
 int getParseLog() {
    int ret = libsbmlPINVOKE.L3ParserSettings_getParseLog(swigCPtr);
    return ret;
  }

  
/**
   * Sets the behavior for handling unary minuses appearing in mathematical
   * formulas.
   *
   * This setting affects two behaviors.  First, pairs of multiple unary
   * minuses in a row (e.g., &quot;<code>- -3</code>&quot;) can be
   * collapsed and ignored in the input, or the multiple minuses can be
   * preserved in the AST node tree that is generated by the parser.
   * Second, minus signs in front of numbers can be collapsed into the
   * number node itself; for example, a &quot;<code>- 4.1</code>&quot; can
   * be turned into a single ASTNode of type @link libsbmlcs.libsbml.AST_REAL
   * AST_REAL@endlink with a value of <code>-4.1</code>, or it can be
   * turned into a node of type @link libsbmlcs.libsbml.AST_MINUS
   * AST_MINUS@endlink having a child node of type @link
   * libsbmlcs.libsbml.AST_REAL AST_REAL@endlink.  This method lets you tell
   * the parser which behavior to use&mdash;either collapse minuses or
   * always preserve them.  The two possibilities are represented using the
   * following constants:
   *
   * @li @link libsbmlcs.libsbml.L3P_COLLAPSE_UNARY_MINUS
   * L3P_COLLAPSE_UNARY_MINUS@endlink (value = @c true): collapse unary
   * minuses where possible.
   * @li @link libsbmlcs.libsbml.L3P_EXPAND_UNARY_MINUS
   * L3P_EXPAND_UNARY_MINUS@endlink (value = @c false): do not collapse
   * unary minuses, and instead translate each one into an AST node of type
   * @link libsbmlcs.libsbml.AST_MINUS AST_MINUS@endlink.
   *
   * @param collapseminus a bool value (one of the constants
   * @link libsbmlcs.libsbml.L3P_COLLAPSE_UNARY_MINUS
   * L3P_COLLAPSE_UNARY_MINUS@endlink or
   * @link libsbmlcs.libsbml.L3P_EXPAND_UNARY_MINUS
   * L3P_EXPAND_UNARY_MINUS@endlink) indicating how unary minus signs in
   * the input should be handled.
   *
   * @see getParseCollapseMinus()
   */ public
 void setParseCollapseMinus(bool collapseminus) {
    libsbmlPINVOKE.L3ParserSettings_setParseCollapseMinus(swigCPtr, collapseminus);
  }

  
/**
   * Returns a flag indicating the current behavior set for handling
   * multiple unary minuses in formulas.
   *
   * This setting affects two behaviors.  First, pairs of multiple unary
   * minuses in a row (e.g., &quot;<code>- -3</code>&quot;) can be
   * collapsed and ignored in the input, or the multiple minuses can be
   * preserved in the AST node tree that is generated by the parser.
   * Second, minus signs in front of numbers can be collapsed into the
   * number node itself; for example, a &quot;<code>- 4.1</code>&quot; can
   * be turned into a single ASTNode of type @link libsbmlcs.libsbml.AST_REAL
   * AST_REAL@endlink with a value of <code>-4.1</code>, or it can be
   * turned into a node of type @link libsbmlcs.libsbml.AST_MINUS
   * AST_MINUS@endlink having a child node of type @link
   * libsbmlcs.libsbml.AST_REAL AST_REAL@endlink.  This method lets you tell
   * the parser which behavior to use&mdash;either collapse minuses or
   * always preserve them.  The two possibilities are represented using the
   * following constants:
   *
   * @li @link libsbmlcs.libsbml.L3P_COLLAPSE_UNARY_MINUS
   * L3P_COLLAPSE_UNARY_MINUS@endlink (value = @c true): collapse unary
   * minuses where possible.
   * @li @link libsbmlcs.libsbml.L3P_EXPAND_UNARY_MINUS
   * L3P_EXPAND_UNARY_MINUS@endlink (value = @c false): do not collapse
   * unary minuses, and instead translate each one into an AST node of type
   * @link libsbmlcs.libsbml.AST_MINUS AST_MINUS@endlink.
   *
   * @return A bool, one of @link
   * libsbmlcs.libsbml.L3P_COLLAPSE_UNARY_MINUS
   * L3P_COLLAPSE_UNARY_MINUS@endlink or @link
   * libsbmlcs.libsbml.L3P_EXPAND_UNARY_MINUS L3P_EXPAND_UNARY_MINUS@endlink.
   *
   * @see setParseCollapseMinus(@if java bool collapseminus@endif)
   */ public
 bool getParseCollapseMinus() {
    bool ret = libsbmlPINVOKE.L3ParserSettings_getParseCollapseMinus(swigCPtr);
    return ret;
  }

  
/**
   * Sets the parser's behavior in handling units associated with numbers
   * in a mathematical formula.
   *
   * In SBML Level&nbsp;2, there is no means of associating a unit of
   * measurement with a pure number in a formula, while SBML Level&nbsp;3
   * does define a syntax for this.  In Level&nbsp;3, MathML
   * <code>&lt;cn&gt;</code> elements can have an attribute named @c units
   * placed in the SBML namespace, which can be used to indicate the units
   * to be associated with the number.  The text-string infix formula
   * parser allows units to be placed after raw numbers; they are
   * interpreted as unit identifiers for units defined by the SBML
   * specification or in the containing Model object.  Some examples
   * include: &quot;<code>4 mL</code>&quot;, &quot;<code>2.01
   * Hz</code>&quot;, &quot;<code>3.1e-6 M</code>&quot;, and
   * &quot;<code>(5/8) inches</code>&quot;.  To produce a valid SBML model,
   * there must either exist a UnitDefinition corresponding to the
   * identifier of the unit, or the unit must be defined in Table&nbsp;2 of
   * the SBML specification.
   *
   * @param units A bool indicating whether to parse units:
   * @li @link libsbmlcs.libsbml.L3P_PARSE_UNITS L3P_PARSE_UNITS@endlink
   * (value = @c true): parse units in the text-string formula.
   * @li @link libsbmlcs.libsbml.L3P_NO_UNITS L3P_NO_UNITS@endlink (value = @c
   * false): treat units in the text-string formula as errors.
   *
   * @see getParseUnits()
   */ public
 void setParseUnits(bool units) {
    libsbmlPINVOKE.L3ParserSettings_setParseUnits(swigCPtr, units);
  }

  
/**
   * Returns @c if the current settings allow units in text-string
   * mathematical formulas.
   *
   * In SBML Level&nbsp;2, there is no means of associating a unit of
   * measurement with a pure number in a formula, while SBML Level&nbsp;3
   * does define a syntax for this.  In Level&nbsp;3, MathML
   * <code>&lt;cn&gt;</code> elements can have an attribute named @c units
   * placed in the SBML namespace, which can be used to indicate the units
   * to be associated with the number.  The text-string infix formula
   * parser allows units to be placed after raw numbers; they are
   * interpreted as unit identifiers for units defined by the SBML
   * specification or in the containing Model object.  Some examples
   * include: &quot;<code>4 mL</code>&quot;, &quot;<code>2.01
   * Hz</code>&quot;, &quot;<code>3.1e-6 M</code>&quot;, and
   * &quot;<code>(5/8) inches</code>&quot;.  To produce a valid SBML model,
   * there must either exist a UnitDefinition corresponding to the
   * identifier of the unit, or the unit must be defined in Table&nbsp;2 of
   * the SBML specification.
   *
   * Since SBML Level&nbsp;2 does not have the ability to associate units with
   * pure numbers, the value should be set to @c false when parsing text-string
   * formulas intended for use in SBML Level&nbsp;2 documents.
   *
   * @return A bool indicating whether to parse units:
   * @li @link libsbmlcs.libsbml.L3P_PARSE_UNITS L3P_PARSE_UNITS@endlink
   * (value = @c true): parse units in the text-string formula.
   * @li @link libsbmlcs.libsbml.L3P_NO_UNITS L3P_NO_UNITS@endlink (value = @c
   * false): treat units in the text-string formula as errors.
   *
   * @see setParseUnits(@if java bool units@endif)
   */ public
 bool getParseUnits() {
    bool ret = libsbmlPINVOKE.L3ParserSettings_getParseUnits(swigCPtr);
    return ret;
  }

  
/**
   * Sets the parser's behavior in handling the string @c avogadro in
   * mathematical formulas.
   *
   * SBML Level&nbsp;3 defines a symbol for representing the value of
   * Avogadro's constant, but it is not defined in SBML Level&nbsp;2.  As a
   * result, the text-string formula parser must behave differently
   * depending on which SBML Level is being targeted.  The argument to this
   * method can be one of two values:
   *
   * @li @link libsbmlcs.libsbml.L3P_AVOGADRO_IS_CSYMBOL
   * L3P_AVOGADRO_IS_CSYMBOL@endlink (value = @c true): tells the parser to
   * translate the string @c avogadro (in any capitalization) into an AST
   * node of type @link libsbmlcs.libsbml.AST_NAME_AVOGADRO
   * AST_NAME_AVOGADRO@endlink.
   * @li @link libsbmlcs.libsbml.L3P_AVOGADRO_IS_NAME
   * L3P_AVOGADRO_IS_NAME@endlink (value = @c false): tells the parser to
   * translate the string @c avogadro into an AST of type @link
   * libsbmlcs.libsbml.AST_NAME AST_NAME@endlink.
   *
   * Since SBML Level&nbsp;2 does not define a symbol for Avogadro's
   * constant, the value should be set to @c false when parsing text-string
   * formulas intended for use in SBML Level&nbsp;2 documents.
   *
   * @param l2only a bool value (one of the constants
   * @link libsbmlcs.libsbml.L3P_AVOGADRO_IS_CSYMBOL
   * L3P_AVOGADRO_IS_CSYMBOL@endlink or
   * @link libsbmlcs.libsbml.L3P_AVOGADRO_IS_NAME
   * L3P_AVOGADRO_IS_NAME@endlink) indicating how the string @c avogadro
   * should be treated when encountered in a formula.
   *
   * @see getParseAvogadroCsymbol()
   */ public
 void setParseAvogadroCsymbol(bool l2only) {
    libsbmlPINVOKE.L3ParserSettings_setParseAvogadroCsymbol(swigCPtr, l2only);
  }

  
/**
   * Returns @c true if the current settings are oriented towards handling
   * @c avogadro for SBML Level&nbsp;3.
   *
   * SBML Level&nbsp;3 defines a symbol for representing the value of
   * Avogadro's constant, but it is not defined in SBML Level&nbsp;2.  As a
   * result, the text-string formula parser must behave differently
   * depending on which SBML Level is being targeted.
   *
   * @return A bool indicating which mode is currently set; the value is
   * one of the following possibilities:
   * @li @link libsbmlcs.libsbml.L3P_AVOGADRO_IS_CSYMBOL
   * L3P_AVOGADRO_IS_CSYMBOL@endlink (value = @c true): tells the parser to
   * translate the string @c avogadro (in any capitalization) into an AST
   * node of type @link libsbmlcs.libsbml.AST_NAME_AVOGADRO
   * AST_NAME_AVOGADRO@endlink.
   * @li @link libsbmlcs.libsbml.L3P_AVOGADRO_IS_NAME
   * L3P_AVOGADRO_IS_NAME@endlink (value = @c false): tells the parser to
   * translate the string @c avogadro into an AST of type @link
   * libsbmlcs.libsbml.AST_NAME AST_NAME@endlink.
   *
   * @see setParseAvogadroCsymbol(@if java bool l2only@endif)
   */ public
 bool getParseAvogadroCsymbol() {
    bool ret = libsbmlPINVOKE.L3ParserSettings_getParseAvogadroCsymbol(swigCPtr);
    return ret;
  }

}

}
