/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  Implementation of SBML's Event construct.
 <p>
 * An SBML {@link Event} object defines when the event can occur, the variables
 * that are affected by it, how the variables are affected, and the event's
 * relationship to other events.  The effect of the event can optionally be
 * delayed after the occurrence of the condition which invokes it.
 <p>
 * The operation of {@link Event} is divided into two phases (even when the event
 * is not delayed): one when the event is <em>triggered</em>, and the other when
 * the event is <em>executed</em>.  {@link Trigger} objects define the conditions for
 * triggering an event, {@link Delay} objects define when the event is actually
 * executed, {@link EventAssignment} objects define the effects of executing the
 * event, and (in SBML Level&nbsp;3) {@link Priority} objects influence the order
 * of {@link EventAssignment} performance in cases of simultaneous events.  Please
 * consult the descriptions of {@link Trigger}, {@link Delay}, {@link EventAssignment} and {@link Priority}
 * for more information.
 <p>
 * <h2>SBML Level/Version differences</h2>
 <p>
 * <h3>SBML Level 3</h3>
 <p>
 * SBML Level 3 introduces several changes to the structure and components
 * of Events compared to SBML Level&nbsp;2.  These changes fall into two
 * main categories: changes to what is optional or required, and additions
 * of new attributes and elements.
 * <ul>
 * <li> The attribute 'useValuesFromTriggerTime' on {@link Event} is mandatory (it
 * was optional in Level&nbsp;2);
 * <li> {@link Event}'s 'listOfEventAssignments' element (of class
 * {@link ListOfEventAssignments}) is optional (it was mandatory in Level&nbsp;2);
 * <li> {@link Event}'s 'priority' element (of class {@link Priority}) is new in
 * Level&nbsp;3; and
 * <li> The {@link Trigger} object gains new mandatory attributes (described as part
 * of the definition of {@link Trigger}).
 * </ul>
 <p>
 * The changes to the attributes of {@link Event} are described below; the changes
 * to {@link Trigger} and {@link Priority} are described in their respective sections.
 <p>
 * <h3>SBML Level 2</h3>
 <p>
 * In SBML Level&nbsp;2 versions before Version&nbsp;4, the semantics of
 * {@link Event} time delays were defined such that the expressions in the event's
 * assignments were always evaluated at the time the event was
 * <em>triggered</em>.  This definition made it difficult to define an event
 * whose assignment formulas were meant to be evaluated at the time the
 * event was <em>executed</em> (i.e., after the time period defined by the
 * value of the {@link Delay} element).  In SBML Level&nbsp;2 Version&nbsp;4 and in
 * Level&nbsp;3, the attribute 'useValuesFromTriggerTime' on {@link Event} allows a
 * model to indicate the time at which the event's assignments are intended
 * the values of the assignment formulas are computed at the moment the
 * event is triggered, not after the delay.  If 'useValuesFromTriggerTime'=
 * <code>false</code>, it means that the formulas in the event's assignments are to be
 * computed <em>after</em> the delay, at the time the event is executed.
 <p>
 * The definition of {@link Event} in SBML Level&nbsp;2 Versions 1 and 2 includes
 * an additional attribute called 'timeUnits', which allowed the time units
 * of the {@link Delay} to be set explicitly.  Later Versions of SBML Level&nbsp;2
 * as well as SBML Level&nbsp;3 do not define this attribute.  LibSBML
 * supports this attribute for compatibility with previous versions of SBML
 * Level&nbsp;2; however, if a model in SBML Level&nbsp;3 or Level&nbsp;2
 * Versions&nbsp;3&ndash;4 format sets the attribute, the
 * consistency-checking method {@link SBMLDocument#checkConsistency()} will report
 * an error.
 <p>
 * The attribute 'useValuesFromTriggerTime' was introduced in SBML
 * Level&nbsp;2 Version&nbsp;4.  Models defined in prior Versions of SBML
 * Level&nbsp;2 cannot use this attribute, and
 * {@link SBMLDocument#checkConsistency()} will report an error if they do.
 <p>
 * <h2>Semantics of events in SBML Level 3 Version&nbsp;1</h2>
 <p>
 * The detailed semantics of events are described in the specification
 * documents for each SBML Level/Version.  Here we include the description
 * from the SBML Level&nbsp;1 Version&nbsp;1.
 * Any transition of a {@link Trigger} object's 'math' formula from the value 
 * <code>false</code> to <code>true</code> will cause the enclosing {@link Event} object to
 * <em>trigger</em>.  Such a transition is not possible at the very start
 * of a simulation (i.e., at time <em>t = 0</em>) unless the {@link Trigger}
 * object's 'initialValue' attribute has a value of <code>false</code>; this defines
 * the value of the trigger formula to be <code>false</code> immediately prior to the
 * start of simulation, thereby giving it the potential to change in value
 * from <code>false</code> to <code>true</code> when the formula is evaluated at <em>t =
 * 0</em>.  If 'initialValue'=<code>true</code>, then the trigger expression cannot
 * transition from <code>false</code> to <code>true</code> at <em>t = 0</em> but may do so at
 * some time <em>t > 0</em>.
 <p>
 * Consider an {@link Event} object definition <EM>E</EM> with delay <em>d</em> in
 * which the {@link Trigger} object's 'math' formula makes a transition in value
 * from <code>false</code> to <code>true</code> at times <em>t<sub>1</sub></em> and
 * <em>t<sub>2</sub></em>.  The {@link EventAssignment} within the {@link Event} object
 * will have effect at <em>t<sub>1</sub> + d</em> and
 * <em>t<sub>2</sub> + d</em> irrespective of the relative times of
 * <em>t<sub>1</sub></em> and <em>t<sub>2</sub></em>.  For example, events
 * can 'overlap' so that <em>t<sub>1</sub> < t<sub>2</sub> <
 * t<sub>1</sub> + d</em> still causes an event assignments to occur at
 * <em>t<sub>1</sub> + d</em> and <em>t<sub>2</sub> + d</em>.
 <p>
 * It is entirely possible for two events to be executed simultaneously,
 * and it is possible for events to trigger other events (i.e., an event
 * assignment can cause an event to trigger).  This leads to several
 * points:
 * <ul>
 <p>
 * <li> A software package should retest all event triggers after executing
 * an event assignment in order to account for the possibility that the
 * assignment causes another event trigger to transition from <code>false</code> to
 * <code>true.</code>  This check should be made after each individual {@link Event} object's
 * execution, even when several events are to be executed simultaneously.
 <p>
 * <li> Any {@link Event} object whose {@link Trigger} 'persistent' attribute has the value
 * <code>false</code> must have its trigger expression reevaluated continuously
 * between when the event is triggered and when it is executed.  If
 * its trigger expression ever evaluates to <code>false</code>, it must be removed
 * from the queue of events pending execution and treated as any other
 * event whose trigger expression evaluates to <code>false.</code>
 <p>
 * <li> Although the precise time at which events are executed is not
 * resolved beyond the given execution point in simulated time, it is
 * assumed that the order in which the events occur <em>is</em> resolved.
 * This order can be significant in determining the overall outcome of a
 * given simulation.  When an event <EM>X</EM> <em>triggers</em> another
 * event <EM>Y</EM> and event <EM>Y</EM> has zero delay, then event
 * <EM>Y</EM> is added to the existing set of simultaneous events that are
 * pending <em>execution</em>.  Events <EM>X</EM> and <EM>Y</EM> form a
 * cascade of events at the same point in simulation time.  An event such
 * as <EM>Y</EM> may have a special priority if it contains a {@link Priority}
 * subobject.
 <p>
 * <li> All events in a model are open to being in a cascade.  The position
 * of an event in the event queue does not affect whether it can be in the
 * cascade: event <EM>Y</EM> can be triggered whether it is before or after
 * <EM>X</EM> in the queue of events pending execution.  A cascade of
 * events can be potentially infinite (never terminate); when this occurs a
 * simulator should indicate this has occurred&mdash;it is incorrect for a
 * simulator to break a cascade arbitrarily and continue the simulation
 * without at least indicating that the infinite cascade occurred.
 <p>
 * <li> Simultaneous events having no defined priorities are executed in an
 * undefined order.  This does not mean that the behavior of the simulation
 * is completely undefined; merely that the <em>order</em> of execution of
 * these particular events is undefined.  A given simulator may use any
 * algorithm to choose an order as long as every event is executed exactly
 * once.
 <p>
 * <li> Events with defined priorities are executed in the order implied by
 * their {@link Priority} 'math' formula values, with events having higher
 * priorities being executed ahead of events with lower priorities, and
 * events with identical priorities being executed in a random order with
 * respect to one another (as determined at run-time by some random
 * algorithm equivalent to coin-flipping).  Newly-triggered events that are
 * to be executed immediately (i.e., if they define no delays) should be
 * inserted into the queue of events pending execution according to their
 * priorities: events with higher priority values value must be inserted
 * ahead of events with lower priority values and after any pending events
 * with even higher priorities, and inserted randomly among pending events
 * with the same priority values.  Events without {@link Priority} objects must be
 * inserted into the queue in some fashion, but the algorithm used to place
 * it in the queue is undefined.  Similarly, there is no restriction on the
 * order of a newly-inserted event with a defined {@link Priority} with respect to
 * any other pending {@link Event} without a defined {@link Priority}.
 <p>
 * <li> A model variable that is the target of one or more event
 * assignments can change more than once when simultaneous events are
 * processed at some time point <em>t</em>.  The model's behavior (output)
 * for such a variable is the value of the variable at the end of
 * processing all the simultaneous events at time <em>t</em>.
 <p>
 * </ul>
 <p>
 * @see Trigger
 * @see Priority
 * @see Delay
 * @see EventAssignment
 */

public class Event extends SBase {
   private long swigCPtr;

   protected Event(long cPtr, boolean cMemoryOwn)
   {
     super(libsbmlJNI.Event_SWIGUpcast(cPtr), cMemoryOwn);
     swigCPtr = cPtr;
   }

   protected static long getCPtr(Event obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (Event obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_Event(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  
/**
   * Creates a new {@link Event} using the given SBML <code>level</code> and <code>version</code>
   * values.
   <p>
   * @param level a long integer, the SBML Level to assign to this {@link Event}
   <p>
   * @param version a long integer, the SBML Version to assign to this
   * {@link Event}
   <p>
   * @throws SBMLConstructorException 
   * Thrown if the given <code>level</code> and <code>version</code> combination, or this kind
   * of SBML object, are either invalid or mismatched with respect to the
   * parent {@link SBMLDocument} object.
   <p>
   * <p>
 * @note Upon the addition of an {@link Event} object to an {@link SBMLDocument} (e.g., using
 * {@link Model#addEvent(Event e)}), the SBML Level, SBML Version and
 * XML namespace of the document <em>override</em> the values used when creating
 * the {@link Event} object via this constructor.  This is necessary to ensure that
 * an SBML document is a consistent structure.  Nevertheless, the ability to
 * supply the values at the time of creation of an {@link Event} is an important aid
 * to producing valid SBML.  Knowledge of the intented SBML Level and Version
 * determine whether it is valid to assign a particular value to an
 * attribute, or whether it is valid to add an object to an existing
 * {@link SBMLDocument}.
   */ public
 Event(long level, long version) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Event__SWIG_0(level, version), true);
  }

  
/**
   * Creates a new {@link Event} using the given {@link SBMLNamespaces} object
   * <code>sbmlns</code>.
   <p>
   * <p>
 * The {@link SBMLNamespaces} object encapsulates SBML Level/Version/namespaces
 * information.  It is used to communicate the SBML Level, Version, and (in
 * Level&nbsp;3) packages used in addition to SBML Level&nbsp;3 Core.  A
 * common approach to using libSBML's {@link SBMLNamespaces} facilities is to create an
 * {@link SBMLNamespaces} object somewhere in a program once, then hand that object
 * as needed to object constructors that accept {@link SBMLNamespaces} as arguments. 
   <p>
   * @param sbmlns an {@link SBMLNamespaces} object.
   <p>
   * @throws SBMLConstructorException 
   * Thrown if the given <code>level</code> and <code>version</code> combination, or this kind
   * of SBML object, are either invalid or mismatched with respect to the
   * parent {@link SBMLDocument} object.
   <p>
   * <p>
 * @note Upon the addition of an {@link Event} object to an {@link SBMLDocument} (e.g., using
 * {@link Model#addEvent(Event e)}), the SBML Level, SBML Version and
 * XML namespace of the document <em>override</em> the values used when creating
 * the {@link Event} object via this constructor.  This is necessary to ensure that
 * an SBML document is a consistent structure.  Nevertheless, the ability to
 * supply the values at the time of creation of an {@link Event} is an important aid
 * to producing valid SBML.  Knowledge of the intented SBML Level and Version
 * determine whether it is valid to assign a particular value to an
 * attribute, or whether it is valid to add an object to an existing
 * {@link SBMLDocument}.
   */ public
 Event(SBMLNamespaces sbmlns) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Event__SWIG_1(SBMLNamespaces.getCPtr(sbmlns), sbmlns), true);
  }

  
/**
   * Copy constructor; creates a copy of this {@link Event}.
   <p>
   * @param orig the object to copy.
   <p>
   * @throws SBMLConstructorException 
   * Thrown if the argument <code>orig</code> is <code>null.</code>
   */ public
 Event(Event orig) throws org.sbml.libsbml.SBMLConstructorException {
    this(libsbmlJNI.new_Event__SWIG_2(Event.getCPtr(orig), orig), true);
  }

  
/**
   * Creates and returns a deep copy of this {@link Event}.
   <p>
   * @return a (deep) copy of this {@link Event}.
   */ public
 Event cloneObject() {
    long cPtr = libsbmlJNI.Event_cloneObject(swigCPtr, this);
    return (cPtr == 0) ? null : new Event(cPtr, true);
  }

  
/**
   * Returns the first child element found that has the given <code>id</code> in the
   * model-wide SId namespace, or <code>null</code> if no such object is found.
   <p>
   * @param id string representing the id of objects to find
   <p>
   * @return pointer to the first element found with the given <code>id</code>.
   */ public
 SBase getElementBySId(String id) {
  return libsbml.DowncastSBase(libsbmlJNI.Event_getElementBySId(swigCPtr, this, id), false);
}

  
/**
   * Returns the first child element it can find with the given <code>metaid</code>, or
   * <code>null</code> if no such object is found.
   <p>
   * @param metaid string representing the metaid of objects to find
   <p>
   * @return pointer to the first element found with the given <code>metaid</code>.
   */ public
 SBase getElementByMetaId(String metaid) {
  return libsbml.DowncastSBase(libsbmlJNI.Event_getElementByMetaId(swigCPtr, this, metaid), false);
}

  
/**
   * Returns the value of the 'id' attribute of this {@link Event}.
   <p>
   * @return the id of this {@link Event}.
   */ public
 String getId() {
    return libsbmlJNI.Event_getId(swigCPtr, this);
  }

  
/**
   * Returns the value of the 'name' attribute of this {@link Event}.
   <p>
   * @return the name of this {@link Event}.
   */ public
 String getName() {
    return libsbmlJNI.Event_getName(swigCPtr, this);
  }

  
/**
   * Get the event trigger portion of this {@link Event}.
   <p>
   * @return the {@link Trigger} object of this {@link Event}.
   */ public
 Trigger getTrigger() {
    long cPtr = libsbmlJNI.Event_getTrigger__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new Trigger(cPtr, false);
  }

  
/**
   * Get the assignment delay portion of this {@link Event}, if there is one.
   <p>
   * @return the delay of this {@link Event} if one is defined, or <code>null</code> if none
   * is defined.
   */ public
 Delay getDelay() {
    long cPtr = libsbmlJNI.Event_getDelay__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new Delay(cPtr, false);
  }

  
/**
   * (SBML Level&nbsp;3 only) Get the event priority portion of this
   * {@link Event}.
   <p>
   * @return the {@link Priority} object of this {@link Event}.
   <p>
   * @note The element 'priority' is available in SBML Level&nbsp;3
   * Version&nbsp;1 Core, but is not present in lower Levels of SBML.
   */ public
 Priority getPriority() {
    long cPtr = libsbmlJNI.Event_getPriority__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new Priority(cPtr, false);
  }

  
/**
   * Get the value of the 'timeUnits' attribute of this {@link Event}, if it has one.
   <p>
   * @return the value of the attribute 'timeUnits' as a string.
   <p>
   * <p>
 * @warning <span class='warning'>Definitions of {@link Event} in SBML Level 2
 * Versions&nbsp;1 and&nbsp;2 included the additional attribute called
 * 'timeUnits', but it was removed in SBML Level&nbsp;2 Version&nbsp;3.
 * LibSBML supports this attribute for compatibility with previous versions
 * of SBML Level&nbsp;2, but its use is discouraged since models in
 * Level&nbsp;2 Versions&nbsp;3 and&nbsp;4 cannot contain it.  If a
 * Version&nbsp;3 or&nbsp;4 model sets the attribute, the
 * consistency-checking method {@link SBMLDocument#checkConsistency()} will report
 * an error.</span>
   */ public
 String getTimeUnits() {
    return libsbmlJNI.Event_getTimeUnits(swigCPtr, this);
  }

  
/**
   * Get the value of the 'useValuesFromTriggerTime' attribute of this {@link Event}.
   <p>
   * <p>
 * The optional {@link Delay} on {@link Event} means there are two times to consider when
 * computing the results of an event: the time at which the event is
 * <em>triggered</em>, and the time at which assignments are
 * <em>executed</em>.  It is also possible to distinguish between the
 * time at which the {@link EventAssignment}'s expression is calculated, and the
 * time at which the assignment is made: the expression could be
 * evaluated at the same time the assignments are performed, i.e., when
 * the event is <em>executed</em>, but it could also be defined to be
 * evaluated at the time the event is <em>triggered</em>.
 <p>
 * In SBML Level&nbsp;2 versions prior to Version&nbsp;4, the semantics
 * of {@link Event} time delays were defined such that the expressions in the
 * event's assignments were always evaluated at the time the event was
 * <em>triggered</em>.  This definition made it difficult to define an
 * event whose assignment formulas were meant to be evaluated at the time
 * the event was <em>executed</em> (i.e., after the time period defined
 * by the value of the {@link Delay} element).  In SBML Level&nbsp;2
 * Version&nbsp;4, the attribute 'useValuesFromTriggerTime' on {@link Event}
 * allows a model to indicate the time at which the event's assignments
 * are intended to be evaluated.  In SBML Level&nbsp;2, the attribute has
 * a default value of <code>true</code>, which corresponds to the interpretation of
 * event assignments prior to Version&nbsp;4: the values of the
 * assignment formulas are computed at the moment the event is triggered,
 * not after the delay.  If 'useValuesFromTriggerTime'=<code>false</code>, it means
 * that the formulas in the event's assignments are to be computed after
 * the delay, at the time the event is executed.  In SBML Level&nbsp;3,
 * the attribute is mandatory, not optional, and all events must specify
 * a value for it.
   <p>
   * @return the value of the attribute 'useValuesFromTriggerTime' as a boolean.
   <p>
   * <p>
 * @warning <span class='warning'>The attribute 'useValuesFromTriggerTime'
 * was introduced in SBML Level&nbsp;2 Version&nbsp;4.  It is not valid in
 * models defined using SBML Level&nbsp;2 versions prior to Version&nbsp;4.
 * If a Level&nbsp;2 Version&nbsp;1&ndash;3 model sets the attribute, the
 * consistency-checking method {@link SBMLDocument#checkConsistency()} will report
 * an error.</span> 
   */ public
 boolean getUseValuesFromTriggerTime() {
    return libsbmlJNI.Event_getUseValuesFromTriggerTime(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Event}'s 'id' attribute is set.
   <p>
   * @return <code>true</code> if the 'id' attribute of this {@link Event} is
   * set, <code>false</code> otherwise.
   */ public
 boolean isSetId() {
    return libsbmlJNI.Event_isSetId(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if this
   * {@link Event}'s 'name' attribute is set.
   <p>
   * @return <code>true</code> if the 'name' attribute of this {@link Event} is
   * set, <code>false</code> otherwise.
   */ public
 boolean isSetName() {
    return libsbmlJNI.Event_isSetName(swigCPtr, this);
  }

  
/**
   * Predicate for testing whether the trigger for this {@link Event} is set.
   <p>
   * @return <code>true</code> if the trigger of this {@link Event} is set, <code>false</code>
   * otherwise.
   */ public
 boolean isSetTrigger() {
    return libsbmlJNI.Event_isSetTrigger(swigCPtr, this);
  }

  
/**
   * Predicate for testing whether the delay for this {@link Event} is set.
   <p>
   * @return <code>true</code> if the delay of this {@link Event} is set, <code>false</code>
   * otherwise.
   */ public
 boolean isSetDelay() {
    return libsbmlJNI.Event_isSetDelay(swigCPtr, this);
  }

  
/**
   * (SBML Level&nbsp;3 only) Predicate for testing whether the priority
   * for this {@link Event} is set.
   <p>
   * @return <code>true</code> if the priority of this {@link Event} is set, <code>false</code>
   * otherwise.
   <p>
   * @note The element 'priority' is available in SBML Level&nbsp;3
   * Version&nbsp;1 Core, but is not present in lower Levels of SBML.
   */ public
 boolean isSetPriority() {
    return libsbmlJNI.Event_isSetPriority(swigCPtr, this);
  }

  
/**
   * Predicate for testing whether the 'timeUnits' attribute of this {@link Event}
   * is set.
   <p>
   * @return <code>true</code> if the 'timeUnits' attribute of this {@link Event} is
   * set, <code>false</code> otherwise.
   <p>
   * <p>
 * @warning <span class='warning'>Definitions of {@link Event} in SBML Level 2
 * Versions&nbsp;1 and&nbsp;2 included the additional attribute called
 * 'timeUnits', but it was removed in SBML Level&nbsp;2 Version&nbsp;3.
 * LibSBML supports this attribute for compatibility with previous versions
 * of SBML Level&nbsp;2, but its use is discouraged since models in
 * Level&nbsp;2 Versions&nbsp;3 and&nbsp;4 cannot contain it.  If a
 * Version&nbsp;3 or&nbsp;4 model sets the attribute, the
 * consistency-checking method {@link SBMLDocument#checkConsistency()} will report
 * an error.</span>
   */ public
 boolean isSetTimeUnits() {
    return libsbmlJNI.Event_isSetTimeUnits(swigCPtr, this);
  }

  
/**
   * Predicate for testing whether the 'useValuesFromTriggerTime' attribute of this {@link Event}
   * is set.
   <p>
   * @return <code>true</code> if the 'useValuesFromTriggerTime' attribute of this {@link Event} is
   * set, <code>false</code> otherwise.
   <p>
   * @note In SBML Level&nbsp;2, this attribute is optional and has a default value of
   * <code>true</code>, whereas in Level&nbsp;3 Version&nbsp;1, this optional is mandatory and
   * has no default value.
   */ public
 boolean isSetUseValuesFromTriggerTime() {
    return libsbmlJNI.Event_isSetUseValuesFromTriggerTime(swigCPtr, this);
  }

  
/**
   * Sets the value of the 'id' attribute of this {@link Event}.
   <p>
   * The string <code>sid</code> is copied.
   <p>
   * <p>
 * SBML has strict requirements for the syntax of identifiers, that is, the
 * values of the 'id' attribute present on most types of SBML objects.
 * The following is a summary of the definition of the SBML identifier type 
 * <code>SId</code>, which defines the permitted syntax of identifiers.  We
 * express the syntax using an extended form of BNF notation: 
 * <pre style='margin-left: 2em; border: none; font-weight: bold; font-size: 13px; color: black'>
 * letter .= 'a'..'z','A'..'Z'
 * digit  .= '0'..'9'
 * idChar .= letter | digit | '_'
 * SId    .= ( letter | '_' ) idChar*
 * </pre>
 * The characters <code>(</code> and <code>)</code> are used for grouping, the
 * character <code>*</code> 'zero or more times', and the character
 * <code>|</code> indicates logical 'or'.  The equality of SBML identifiers is
 * determined by an exact character sequence match; i.e., comparisons must be
 * performed in a case-sensitive manner.  In addition, there are a few
 * conditions for the uniqueness of identifiers in an SBML model.  Please
 * consult the SBML specifications for the exact details of the uniqueness
 * requirements.
   <p>
   * @param sid the string to use as the identifier of this {@link Event}
   <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * </ul>
   */ public
 int setId(String sid) {
    return libsbmlJNI.Event_setId(swigCPtr, this, sid);
  }

  
/**
   * Sets the value of the 'name' attribute of this {@link Event}.
   <p>
   * The string in <code>name</code> is copied.
   <p>
   * @param name the new name for the {@link Event}
   <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * </ul>
   */ public
 int setName(String name) {
    return libsbmlJNI.Event_setName(swigCPtr, this, name);
  }

  
/**
   * Sets the trigger definition of this {@link Event} to a copy of the given
   * {@link Trigger} object instance.
   <p>
   * @param trigger the {@link Trigger} object instance to use.
   <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH }
   * <li> {@link  libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH }
   * </ul>
   */ public
 int setTrigger(Trigger trigger) {
    return libsbmlJNI.Event_setTrigger(swigCPtr, this, Trigger.getCPtr(trigger), trigger);
  }

  
/**
   * Sets the delay definition of this {@link Event} to a copy of the given {@link Delay}
   * object instance.
   <p>
   * @param delay the {@link Delay} object instance to use
   <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH }
   * <li> {@link  libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH }
   * </ul>
   */ public
 int setDelay(Delay delay) {
    return libsbmlJNI.Event_setDelay(swigCPtr, this, Delay.getCPtr(delay), delay);
  }

  
/**
   * (SBML Level&nbsp;3 only) Sets the priority definition of this {@link Event}
   * to a copy of the given {@link Priority} object instance.
   <p>
   * @param priority the {@link Priority} object instance to use
   <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH }
   * <li> {@link  libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   *
   * </ul> <p>
   * @note The element 'priority' is available in SBML Level&nbsp;3
   * Version&nbsp;1 Core, but is not present in lower Levels of SBML.
   */ public
 int setPriority(Priority priority) {
    return libsbmlJNI.Event_setPriority(swigCPtr, this, Priority.getCPtr(priority), priority);
  }

  
/**
   * Sets the 'timeUnits' attribute of this {@link Event} to a copy of <code>sid</code>.
   <p>
   * @param sid the identifier of the time units to use.
   <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_INVALID_ATTRIBUTE_VALUE LIBSBML_INVALID_ATTRIBUTE_VALUE }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   *
   * </ul> <p>
   * <p>
 * @warning <span class='warning'>Definitions of {@link Event} in SBML Level 2
 * Versions&nbsp;1 and&nbsp;2 included the additional attribute called
 * 'timeUnits', but it was removed in SBML Level&nbsp;2 Version&nbsp;3.
 * LibSBML supports this attribute for compatibility with previous versions
 * of SBML Level&nbsp;2, but its use is discouraged since models in
 * Level&nbsp;2 Versions&nbsp;3 and&nbsp;4 cannot contain it.  If a
 * Version&nbsp;3 or&nbsp;4 model sets the attribute, the
 * consistency-checking method {@link SBMLDocument#checkConsistency()} will report
 * an error.</span>
   */ public
 int setTimeUnits(String sid) {
    return libsbmlJNI.Event_setTimeUnits(swigCPtr, this, sid);
  }

  
/**
   * Sets the 'useValuesFromTriggerTime' attribute of this {@link Event} to a <code>value</code>.
   <p>
   * <p>
 * The optional {@link Delay} on {@link Event} means there are two times to consider when
 * computing the results of an event: the time at which the event is
 * <em>triggered</em>, and the time at which assignments are
 * <em>executed</em>.  It is also possible to distinguish between the
 * time at which the {@link EventAssignment}'s expression is calculated, and the
 * time at which the assignment is made: the expression could be
 * evaluated at the same time the assignments are performed, i.e., when
 * the event is <em>executed</em>, but it could also be defined to be
 * evaluated at the time the event is <em>triggered</em>.
 <p>
 * In SBML Level&nbsp;2 versions prior to Version&nbsp;4, the semantics
 * of {@link Event} time delays were defined such that the expressions in the
 * event's assignments were always evaluated at the time the event was
 * <em>triggered</em>.  This definition made it difficult to define an
 * event whose assignment formulas were meant to be evaluated at the time
 * the event was <em>executed</em> (i.e., after the time period defined
 * by the value of the {@link Delay} element).  In SBML Level&nbsp;2
 * Version&nbsp;4, the attribute 'useValuesFromTriggerTime' on {@link Event}
 * allows a model to indicate the time at which the event's assignments
 * are intended to be evaluated.  In SBML Level&nbsp;2, the attribute has
 * a default value of <code>true</code>, which corresponds to the interpretation of
 * event assignments prior to Version&nbsp;4: the values of the
 * assignment formulas are computed at the moment the event is triggered,
 * not after the delay.  If 'useValuesFromTriggerTime'=<code>false</code>, it means
 * that the formulas in the event's assignments are to be computed after
 * the delay, at the time the event is executed.  In SBML Level&nbsp;3,
 * the attribute is mandatory, not optional, and all events must specify
 * a value for it.
   <p>
   * @param value the value of useValuesFromTriggerTime to use.
   <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   *
   * </ul> <p>
   * <p>
 * @warning <span class='warning'>The attribute 'useValuesFromTriggerTime'
 * was introduced in SBML Level&nbsp;2 Version&nbsp;4.  It is not valid in
 * models defined using SBML Level&nbsp;2 versions prior to Version&nbsp;4.
 * If a Level&nbsp;2 Version&nbsp;1&ndash;3 model sets the attribute, the
 * consistency-checking method {@link SBMLDocument#checkConsistency()} will report
 * an error.</span>
   */ public
 int setUseValuesFromTriggerTime(boolean value) {
    return libsbmlJNI.Event_setUseValuesFromTriggerTime(swigCPtr, this, value);
  }

  
/**
   * Unsets the value of the 'id' attribute of this {@link Event}.
   <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   */ public
 int unsetId() {
    return libsbmlJNI.Event_unsetId(swigCPtr, this);
  }

  
/**
   * Unsets the value of the 'name' attribute of this {@link Event}.
   <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   */ public
 int unsetName() {
    return libsbmlJNI.Event_unsetName(swigCPtr, this);
  }

  
/**
   * Unsets the {@link Delay} of this {@link Event}.
   <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   * </ul>
   */ public
 int unsetDelay() {
    return libsbmlJNI.Event_unsetDelay(swigCPtr, this);
  }

  
/**
   * (SBML Level&nbsp;3 only) Unsets the {@link Priority} of this {@link Event}.
   <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   *
   * </ul> <p>
   * @note The element 'priority' is available in SBML Level&nbsp;3
   * Version&nbsp;1 Core, but is not present in lower Levels of SBML.
   */ public
 int unsetPriority() {
    return libsbmlJNI.Event_unsetPriority(swigCPtr, this);
  }

  
/**
   * Unsets the {@link Trigger} of this {@link Event}.
   <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   *
   * </ul> <p>
   * @note The element 'priority' is available in SBML Level&nbsp;3
   * Version&nbsp;1 Core, but is not present in lower Levels of SBML.
   */ public
 int unsetTrigger() {
    return libsbmlJNI.Event_unsetTrigger(swigCPtr, this);
  }

  
/**
   * Unsets the 'timeUnits' attribute of this {@link Event}.
   <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_UNEXPECTED_ATTRIBUTE LIBSBML_UNEXPECTED_ATTRIBUTE }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   *
   * </ul> <p>
   * <p>
 * @warning <span class='warning'>Definitions of {@link Event} in SBML Level 2
 * Versions&nbsp;1 and&nbsp;2 included the additional attribute called
 * 'timeUnits', but it was removed in SBML Level&nbsp;2 Version&nbsp;3.
 * LibSBML supports this attribute for compatibility with previous versions
 * of SBML Level&nbsp;2, but its use is discouraged since models in
 * Level&nbsp;2 Versions&nbsp;3 and&nbsp;4 cannot contain it.  If a
 * Version&nbsp;3 or&nbsp;4 model sets the attribute, the
 * consistency-checking method {@link SBMLDocument#checkConsistency()} will report
 * an error.</span>
   */ public
 int unsetTimeUnits() {
    return libsbmlJNI.Event_unsetTimeUnits(swigCPtr, this);
  }

  
/**
   * Appends a copy of the given {@link EventAssignment} to this {@link Event}.
   <p>
   * @param ea the {@link EventAssignment} object to add.
   <p>
   * @return integer value indicating success/failure of the
   * function.   The possible values
   * returned by this function are:
   * <ul>
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_SUCCESS LIBSBML_OPERATION_SUCCESS }
   * <li> {@link  libsbmlConstants#LIBSBML_LEVEL_MISMATCH LIBSBML_LEVEL_MISMATCH }
   * <li> {@link  libsbmlConstants#LIBSBML_VERSION_MISMATCH LIBSBML_VERSION_MISMATCH }
   * <li> {@link  libsbmlConstants#LIBSBML_DUPLICATE_OBJECT_ID LIBSBML_DUPLICATE_OBJECT_ID }
   * <li> {@link  libsbmlConstants#LIBSBML_OPERATION_FAILED LIBSBML_OPERATION_FAILED }
   *
   * </ul> <p>
   * <p>
 * @note This method should be used with some caution.  The fact that this
 * method <em>copies</em> the object passed to it means that the caller will be
 * left holding a physically different object instance than the one contained
 * inside this object.  Changes made to the original object instance (such as
 * resetting attribute values) will <em>not affect the instance in this
 * object</em>.  In addition, the caller should make sure to free the
 * original object if it is no longer being used, or else a memory leak will
 * result.  Please see other methods on this class (particularly a
 * corresponding method whose name begins with the word <code>create</code>)
 * for alternatives that do not lead to these issues. 
   <p>
   * @see #createEventAssignment()
   */ public
 int addEventAssignment(EventAssignment ea) {
    return libsbmlJNI.Event_addEventAssignment(swigCPtr, this, EventAssignment.getCPtr(ea), ea);
  }

  
/**
   * Creates a new, empty {@link EventAssignment}, adds it to this {@link Event}'s list of
   * event assignments and returns the {@link EventAssignment}.
   <p>
   * @return the newly created {@link EventAssignment} object instance
   <p>
   * @see #addEventAssignment(EventAssignment ea)
   */ public
 EventAssignment createEventAssignment() {
    long cPtr = libsbmlJNI.Event_createEventAssignment(swigCPtr, this);
    return (cPtr == 0) ? null : new EventAssignment(cPtr, false);
  }

  
/**
   * Creates a new, empty {@link Trigger}, adds it to this {@link Event} and 
   * returns the {@link Trigger}.
   <p>
   * @return the newly created {@link Trigger} object instance
   */ public
 Trigger createTrigger() {
    long cPtr = libsbmlJNI.Event_createTrigger(swigCPtr, this);
    return (cPtr == 0) ? null : new Trigger(cPtr, false);
  }

  
/**
   * Creates a new, empty {@link Delay}, adds it to this {@link Event} and 
   * returns the {@link Delay}.
   <p>
   * @return the newly created {@link Delay} object instance
   */ public
 Delay createDelay() {
    long cPtr = libsbmlJNI.Event_createDelay(swigCPtr, this);
    return (cPtr == 0) ? null : new Delay(cPtr, false);
  }

  
/**
   * (SBML Level&nbsp;3 only) Creates a new, empty {@link Priority}, adds it to this
   * {@link Event} and returns the {@link Priority}.
   <p>
   * @return the newly created {@link Priority} object instance
   <p>
   * @note The element 'priority' is available in SBML Level&nbsp;3
   * Version&nbsp;1 Core, but is not present in lower Levels of SBML.
   */ public
 Priority createPriority() {
    long cPtr = libsbmlJNI.Event_createPriority(swigCPtr, this);
    return (cPtr == 0) ? null : new Priority(cPtr, false);
  }

  
/**
   * Returns the list of event assignments for this {@link Event}.
   <p>
   * @return the list of EventAssignments for this {@link Event}.
   */ public
 ListOfEventAssignments getListOfEventAssignments() {
    long cPtr = libsbmlJNI.Event_getListOfEventAssignments__SWIG_0(swigCPtr, this);
    return (cPtr == 0) ? null : new ListOfEventAssignments(cPtr, false);
  }

  
/**
   * Return a specific {@link EventAssignment} object of this {@link Event}.
   <p>
   * @param n an integer, the index of the {@link EventAssignment} object to return
   <p>
   * @return the <code>n</code>th {@link EventAssignment} of this {@link Event}.
   */ public
 EventAssignment getEventAssignment(long n) {
    long cPtr = libsbmlJNI.Event_getEventAssignment__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new EventAssignment(cPtr, false);
  }

  
/**
   * Return the event assignment indicated by the given <code>variable</code>.
   <p>
   * @param variable a string, the identifier of the variable whose
   * {@link EventAssignment} is being sought.
   <p>
   * @return the {@link EventAssignment} for the given <code>variable</code>, or <code>null</code> if
   * no such {@link EventAssignment} exits.
   */ public
 EventAssignment getEventAssignment(String variable) {
    long cPtr = libsbmlJNI.Event_getEventAssignment__SWIG_2(swigCPtr, this, variable);
    return (cPtr == 0) ? null : new EventAssignment(cPtr, false);
  }

  
/**
   * Returns the number of {@link EventAssignment} objects attached to this
   * {@link Event}.
   <p>
   * @return the number of EventAssignments in this {@link Event}.
   */ public
 long getNumEventAssignments() {
    return libsbmlJNI.Event_getNumEventAssignments(swigCPtr, this);
  }

  
/**
   * Removes the nth {@link EventAssignment} object from this {@link Event} object and
   * returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   <p>
   * @param n the index of the {@link EventAssignment} object to remove
   <p>
   * @return the {@link EventAssignment} object removed.  As mentioned above, 
   * the caller owns the returned item. <code>null</code> is returned if the given index 
   * is out of range.
   */ public
 EventAssignment removeEventAssignment(long n) {
    long cPtr = libsbmlJNI.Event_removeEventAssignment__SWIG_0(swigCPtr, this, n);
    return (cPtr == 0) ? null : new EventAssignment(cPtr, true);
  }

  
/**
   * Removes the {@link EventAssignment} object with the given 'variable' attribute 
   * from this {@link Event} object and returns a pointer to it.
   <p>
   * The caller owns the returned object and is responsible for deleting it.
   * If none of the {@link EventAssignment} objects in this {@link Event} object have the 
   * 'variable' attribute <code>variable</code>, then <code>null</code> is returned.
   <p>
   * @param variable the 'variable' attribute of the {@link EventAssignment} object 
   * to remove
   <p>
   * @return the {@link EventAssignment} object removed.  As mentioned above, the 
   * caller owns the returned object. <code>null</code> is returned if no {@link EventAssignment}
   * object with the 'variable' attribute exists in this {@link Event} object.
   */ public
 EventAssignment removeEventAssignment(String variable) {
    long cPtr = libsbmlJNI.Event_removeEventAssignment__SWIG_1(swigCPtr, this, variable);
    return (cPtr == 0) ? null : new EventAssignment(cPtr, true);
  }

  
/**
   * Sets this SBML object to child SBML objects (if any).
   * (Creates a child-parent relationship by the parent)
   <p>
   * Subclasses must override this function if they define
   * one ore more child elements.
   * Basically, this function needs to be called in
   * constructor, copy constructor and assignment operator.
   <p>
   * @see setSBMLDocument
   * @see enablePackageInternal
   * @internal
   */ public
 void connectToChild() {
    libsbmlJNI.Event_connectToChild(swigCPtr, this);
  }

  
/**
   * Enables/Disables the given package with this element and child
   * elements (if any).
   * (This is an internal implementation for enablePackage function)
   <p>
   * @note Subclasses of the SBML Core package in which one or more child
   * elements are defined must override this function.
   * @internal
   */ public
 void enablePackageInternal(String pkgURI, String pkgPrefix, boolean flag) {
    libsbmlJNI.Event_enablePackageInternal(swigCPtr, this, pkgURI, pkgPrefix, flag);
  }

  
/**
   * Returns the libSBML type code of this object instance.
   <p>
   * <p>
 * LibSBML attaches an identifying code to every kind of SBML object.  These
 * are integer constants known as <em>SBML type codes</em>.  The names of all
 * the codes begin with the characters &ldquo;<code>SBML_</code>&rdquo;. 
 * In the Java language interface for libSBML, the
 * type codes are defined as static integer constants in the interface class
 * {@link libsbmlConstants}.    Note that different Level&nbsp;3 
 * package plug-ins may use overlapping type codes; to identify the package
 * to which a given object belongs, call the <code>getPackageName()</code>
 * method on the object.
   <p>
   * @return the SBML type code for this object:
   * {@link  libsbmlConstants#SBML_EVENT SBML_EVENT} (default).
   <p>
   * <p>
 * @warning <span class='warning'>The specific integer values of the possible
 * type codes may be reused by different Level&nbsp;3 package plug-ins.
 * Thus, to identifiy the correct code, <strong>it is necessary to invoke
 * both getTypeCode() and getPackageName()</strong>.</span>
   <p>
   * @see #getElementName()
   * @see #getPackageName()
   */ public
 int getTypeCode() {
    return libsbmlJNI.Event_getTypeCode(swigCPtr, this);
  }

  
/**
   * Returns the XML element name of this object, which for {@link Event}, is
   * always <code>'event'.</code>
   <p>
   * @return the name of this element, i.e., <code>'event'.</code> 
   */ public
 String getElementName() {
    return libsbmlJNI.Event_getElementName(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if all the required attributes for this
   * {@link Event} object have been set.
   <p>
   * @note The required attributes for an {@link Event} object are:
   * <ul>
   * <li> 'useValuesfromTriggerTime' (required in SBML Level&nbsp;3)
   * </ul>
   */ public
 boolean hasRequiredAttributes() {
    return libsbmlJNI.Event_hasRequiredAttributes(swigCPtr, this);
  }

  
/**
   * Predicate returning <code>true</code> if
   * all the required elements for the given Event_t structure
   * have been set.
   <p>
   * @note The required elements for an {@link Event} object are:
   * <ul>
   * <li> 'trigger'
   * <li> 'listOfEventAssignments' (required in SBML Level&nbsp;2, optional in Level&nbsp;3)
   * </ul>
   */ public
 boolean hasRequiredElements() {
    return libsbmlJNI.Event_hasRequiredElements(swigCPtr, this);
  }

}
