/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 2.0.4
 *
 * Do not make changes to this file unless you know what you are doing--modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.sbml.libsbml;

/** 
 *  A helper class for controlling the behavior of the
 * text-string formula parser.
 <p>
 * <p style='color: #777; font-style: italic'>
This class of objects is defined by libSBML only and has no direct
equivalent in terms of SBML components.  This class is not prescribed by
the SBML specifications, although it is used to implement features
defined in SBML.
</p>

 <p>
 * The function
 * <code><a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'>libsbml.parseL3FormulaWithSettings(String formula, {@link L3ParserSettings} settings)</a></code>,
 * along with its variants 
 * <code><a href='libsbml.html#parseFormula(java.lang.String)'>libsbml.parseFormula(java.lang.String formula)</a></code>
 * and
 * <code><a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'>libsbml.parseL3FormulaWithModel(String formula, {@link Model} model)</a></code>,
 * are the interfaces to a parser for mathematical formulas expressed as
 * text strings.  The parser converts the text-string formulas into
 * Abstract Syntax Trees (ASTs), represented in libSBML using {@link ASTNode}
 * objects. Compared to the parser implemented by the function
 * <code><a href='libsbml.html#parseFormula(java.lang.String)'>libsbml.parseFormula(java.lang.String formula)</a></code>,
 * which was designed primarily for converting the mathematical formula
 * strings in SBML Level&nbsp;1, the 'L3' variant of the parser accepts an
 * extended formula syntax.  It also has a number of configurable behaviors.
 * This class (L3ParserSettings) is an object used to communicate the
 * configuration settings with callers.
 <p>
 * The following aspects of the parser are configurable:
 * <ul>
 * <li> The function <code>log</code> with a single argument (&quot;<code>log(x)</code>&quot;) 
 * can be parsed as <code>log10(x)</code>, <code>ln(x)</code>, or treated
 * as an error, as desired.
 * <li> Unary minus signs can be collapsed or preserved; that is,
 * sequential pairs of unary minuses (e.g., &quot;<code>- -3</code>&quot;)
 * can be removed from the input entirely and single unary minuses can be
 * incorporated into the number node, or all minuses can be preserved in
 * the AST node structure.
 * <li> Parsing of units embedded in the input string can be turned on and
 * off.
 * <li> The string <code>avogadro</code> can be parsed as a MathML <em>csymbol</em> or
 * as an identifier.
 * <li> A {@link Model} object may optionally be provided to the parser using
 * the variant function call <code><a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'>libsbml.parseL3FormulaWithModel(String formula, {@link Model} model)</a></code>.
 * or stored in a {@link L3ParserSettings} object passed to the variant function
 * <code><a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'>libsbml.parseL3FormulaWithSettings(String formula, org.sbml.libsbml.L3ParserSettings settings)</a></code>.
 * When a {@link Model} object is provided, identifiers (values of type <code>SId</code>)
 * from that model are used in preference to pre-defined MathML
 * definitions.  More precisely, the {@link Model} entities whose identifiers will
 * shadow identical symbols in the mathematical formula are: {@link Species},
 * {@link Compartment}, {@link Parameter}, {@link Reaction}, and {@link SpeciesReference}.  For instance,
 * if the parser is given a {@link Model} containing a {@link Species} with the identifier
 * &quot;<code>pi</code>&quot;, and the formula to be parsed is
 * &quot;<code>3*pi</code>&quot;, the MathML produced will contain the
 * construct <code>&lt;ci&gt; pi &lt;/ci&gt;</code> instead of the
 * construct <code>&lt;pi/&gt;</code>.
 * <li> Similarly, when a {@link Model} object is provided, <code>SId</code> values of
 * user-defined functions present in the {@link Model} will be used preferentially
 * over pre-defined MathML functions.  For example, if the passed-in {@link Model}
 * contains a {@link FunctionDefinition} with the identifier
 * &quot;<code>sin</code>&quot;, that function will be used instead of the
 * predefined MathML function <code>&lt;sin/&gt;</code>.
 * </ul>
 <p>
 * To obtain the default configuration values, callers can use the function
 * <code><a href='libsbml.html#getDefaultL3ParserSettings()'>libsbml.getDefaultL3ParserSettings()</a></code>.
 * To change the configuration, callers can create an {@link L3ParserSettings}
 * object, set the desired characteristics using the methods
 * provided, and pass that object to
 * <a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'><code>libsbml.parseL3FormulaWithSettings(String formula, {@link L3ParserSettings} settings)</code></a>.
 <p>
 <p>
 <p>
 <p>
 * @see <code><a href='libsbml.html#parseL3FormulaWithSettings(java.lang.String, org.sbml.libsbml.L3ParserSettings)'>libsbml.parseL3FormulaWithSettings(String formula, L3ParserSettings settings)</a></code>
 * @see <code><a href='libsbml.html#parseL3Formula(java.lang.String)'>libsbml.parseL3Formula(String formula)</a></code>
 * @see <code><a href='libsbml.html#parseL3FormulaWithModel(java.lang.String, org.sbml.libsbml.Model)'>parseL3FormulaWithModel(String formula, Model model)</a></code>
 */

public class L3ParserSettings {
   private long swigCPtr;
   protected boolean swigCMemOwn;

   protected L3ParserSettings(long cPtr, boolean cMemoryOwn)
   {
     swigCMemOwn = cMemoryOwn;
     swigCPtr    = cPtr;
   }

   protected static long getCPtr(L3ParserSettings obj)
   {
     return (obj == null) ? 0 : obj.swigCPtr;
   }

   protected static long getCPtrAndDisown (L3ParserSettings obj)
   {
     long ptr = 0;

     if (obj != null)
     {
       ptr             = obj.swigCPtr;
       obj.swigCMemOwn = false;
     }

     return ptr;
   }

  protected void finalize() {
    delete();
  }

  public synchronized void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        libsbmlJNI.delete_L3ParserSettings(swigCPtr);
      }
      swigCPtr = 0;
    }
  }

  
/**
   * Creates a new {@link L3ParserSettings} object with default values.
   <p>
   * This is the default constructor for the {@link L3ParserSettings} object.  It
   * sets the {@link Model} to <code>null</code> and other settings to 
   * <code>L3P_PARSE_LOG_AS_LOG10</code>, <code>L3P_EXPAND_UNARY_MINUS</code>, <code>L3P_PARSE_UNITS</code>,
   * and <code>L3P_AVOGADRO_IS_CSYMBOL.</code>
   */ public
 L3ParserSettings() {
    this(libsbmlJNI.new_L3ParserSettings__SWIG_0(), true);
  }

  
/**
   * Creates a new {@link L3ParserSettings} object with specific values for all
   * possible settings.
   <p>
   * @param model a {@link Model} object to be used for disambiguating identifiers
   <p>
   * @param parselog a flag that controls how the parser will handle
   * the symbol <code>log</code> in formulas
   <p>
   * @param collapseminus a flag that controls how the parser will handle
   * minus signs
   <p>
   * @param parseunits a flag that controls how the parser will handle
   * apparent references to units of measurement associated with raw
   * numbers in a formula
   <p>
   * @param avocsymbol a flag that controls how the parser will handle
   * the appearance of the symbol <code>avogadro</code> in a formula
   <p>
   * @see #getModel()
   * @see #setModel(Model model)
   * @see #unsetModel()
   * @see #getParseLog()
   * @see #setParseLog(int type)
   * @see #getParseUnits()
   * @see #setParseUnits(boolean units)
   * @see #getParseCollapseMinus()
   * @see #setParseCollapseMinus(boolean collapseminus)
   * @see #getParseAvogadroCsymbol()
   * @see #setParseAvogadroCsymbol(boolean l2only)
   */ public
 L3ParserSettings(Model model, int parselog, boolean collapseminus, boolean parseunits, boolean avocsymbol) {
    this(libsbmlJNI.new_L3ParserSettings__SWIG_1(Model.getCPtr(model), model, parselog, collapseminus, parseunits, avocsymbol), true);
  }

  
/**
   * Sets the model reference in this {@link L3ParserSettings} object.
   <p>
   * When a {@link Model} object is provided, identifiers (values of type <code>SId</code>)
   * from that model are used in preference to pre-defined MathML
   * definitions.  More precisely, the {@link Model} entities whose identifiers will
   * shadow identical symbols in the mathematical formula are: {@link Species},
   * {@link Compartment}, {@link Parameter}, {@link Reaction}, and {@link SpeciesReference}.  For instance,
   * if the parser is given a {@link Model} containing a {@link Species} with the identifier
   * &quot;<code>pi</code>&quot;, and the formula to be parsed is
   * &quot;<code>3*pi</code>&quot;, the MathML produced will contain the
   * construct <code>&lt;ci&gt; pi &lt;/ci&gt;</code> instead of the
   * construct <code>&lt;pi/&gt;</code>.
   * Similarly, when a {@link Model} object is provided, <code>SId</code> values of
   * user-defined functions present in the {@link Model} will be used preferentially
   * over pre-defined MathML functions.  For example, if the passed-in {@link Model}
   * contains a {@link FunctionDefinition} with the identifier
   * &quot;<code>sin</code>&quot;, that function will be used instead of the
   * predefined MathML function <code>&lt;sin/&gt;</code>.
   <p>
   * @param model a {@link Model} object to be used for disambiguating identifiers
   <p>
   * @warning <span class='warning'>This does <em>not</em> copy the {@link Model} object.
   * This means that modifications made to the object after invoking this
   * method may affect parsing behavior.</span>
   <p>
   * @see #getModel()
   * @see #unsetModel()
   */ public
 void setModel(Model model) {
    libsbmlJNI.L3ParserSettings_setModel(swigCPtr, this, Model.getCPtr(model), model);
  }

  
/**
   * Returns the {@link Model} object referenced by this {@link L3ParserSettings} object.
   <p>
   * @see #setModel(Model model)
   * @see #unsetModel()
   */ public
 Model getModel() {
    long cPtr = libsbmlJNI.L3ParserSettings_getModel(swigCPtr, this);
    return (cPtr == 0) ? null : new Model(cPtr, false);
  }

  
/**
   * Sets the {@link Model} reference in this {@link L3ParserSettings} object to <code>null.</code>
   <p>
   * @see #setModel(Model model)
   * @see #getModel()
   */ public
 void unsetModel() {
    libsbmlJNI.L3ParserSettings_unsetModel(swigCPtr, this);
  }

  
/**
   * Sets the behavior for handling <code>log</code> in mathematical formulas.
   <p>
   * The function <code>log</code> with a single argument
   * (&quot;<code>log(x)</code>&quot;) can be parsed as
   * <code>log10(x)</code>, <code>ln(x)</code>, or treated as an error, as
   * desired.
   <p>
   * @param type a constant, one of following three possibilities:
   * <ul>
   * <li> {@link  libsbmlConstants#L3P_PARSE_LOG_AS_LOG10 L3P_PARSE_LOG_AS_LOG10}
   * <li> {@link  libsbmlConstants#L3P_PARSE_LOG_AS_LN L3P_PARSE_LOG_AS_LN}
   * <li> {@link  libsbmlConstants#L3P_PARSE_LOG_AS_ERROR L3P_PARSE_LOG_AS_ERROR}
   *
   * </ul> <p>
   * @see #getParseLog()
   */ public
 void setParseLog(int type) {
    libsbmlJNI.L3ParserSettings_setParseLog(swigCPtr, this, type);
  }

  
/**
   * Returns the current setting indicating what to do with formulas
   * containing the function <code>log</code> with one argument.
   <p>
   * The function <code>log</code> with a single argument
   * (&quot;<code>log(x)</code>&quot;) can be parsed as
   * <code>log10(x)</code>, <code>ln(x)</code>, or treated as an error, as
   * desired.
   <p>
   * @return One of following three constants:
   * <ul>
   * <li> {@link  libsbmlConstants#L3P_PARSE_LOG_AS_LOG10 L3P_PARSE_LOG_AS_LOG10}
   * <li> {@link  libsbmlConstants#L3P_PARSE_LOG_AS_LN L3P_PARSE_LOG_AS_LN}
   * <li> {@link  libsbmlConstants#L3P_PARSE_LOG_AS_ERROR L3P_PARSE_LOG_AS_ERROR}
   *
   * </ul> <p>
   * @see #setParseLog(int type)
   */ public
 int getParseLog() {
    return libsbmlJNI.L3ParserSettings_getParseLog(swigCPtr, this);
  }

  
/**
   * Sets the behavior for handling unary minuses appearing in mathematical
   * formulas.
   <p>
   * This setting affects two behaviors.  First, pairs of multiple unary
   * minuses in a row (e.g., &quot;<code>- -3</code>&quot;) can be
   * collapsed and ignored in the input, or the multiple minuses can be
   * preserved in the AST node tree that is generated by the parser.
   * Second, minus signs in front of numbers can be collapsed into the
   * number node itself; for example, a &quot;<code>- 4.1</code>&quot; can
   * be turned into a single {@link ASTNode} of type {@link  libsbmlConstants#AST_REAL
   * AST_REAL} with a value of <code>-4.1</code>, or it can be
   * turned into a node of type {@link  libsbmlConstants#AST_MINUS
   * AST_MINUS} having a child node of type {@link 
   * libsbmlConstants#AST_REAL AST_REAL}.  This method lets you tell
   * the parser which behavior to use&mdash;either collapse minuses or
   * always preserve them.  The two possibilities are represented using the
   * following constants:
   <p>
   * <ul>
   * <li> {@link  libsbmlConstants#L3P_COLLAPSE_UNARY_MINUS
   * L3P_COLLAPSE_UNARY_MINUS} (value = <code>true</code>): collapse unary
   * minuses where possible.
   * <li> {@link  libsbmlConstants#L3P_EXPAND_UNARY_MINUS
   * L3P_EXPAND_UNARY_MINUS} (value = <code>false</code>): do not collapse
   * unary minuses, and instead translate each one into an AST node of type
   * {@link  libsbmlConstants#AST_MINUS AST_MINUS}.
   *
   * </ul> <p>
   * @param collapseminus a boolean value (one of the constants
   * {@link  libsbmlConstants#L3P_COLLAPSE_UNARY_MINUS
   * L3P_COLLAPSE_UNARY_MINUS} or
   * {@link  libsbmlConstants#L3P_EXPAND_UNARY_MINUS
   * L3P_EXPAND_UNARY_MINUS}) indicating how unary minus signs in
   * the input should be handled.
   <p>
   * @see #getParseCollapseMinus()
   */ public
 void setParseCollapseMinus(boolean collapseminus) {
    libsbmlJNI.L3ParserSettings_setParseCollapseMinus(swigCPtr, this, collapseminus);
  }

  
/**
   * Returns a flag indicating the current behavior set for handling
   * multiple unary minuses in formulas.
   <p>
   * This setting affects two behaviors.  First, pairs of multiple unary
   * minuses in a row (e.g., &quot;<code>- -3</code>&quot;) can be
   * collapsed and ignored in the input, or the multiple minuses can be
   * preserved in the AST node tree that is generated by the parser.
   * Second, minus signs in front of numbers can be collapsed into the
   * number node itself; for example, a &quot;<code>- 4.1</code>&quot; can
   * be turned into a single {@link ASTNode} of type {@link  libsbmlConstants#AST_REAL
   * AST_REAL} with a value of <code>-4.1</code>, or it can be
   * turned into a node of type {@link  libsbmlConstants#AST_MINUS
   * AST_MINUS} having a child node of type {@link 
   * libsbmlConstants#AST_REAL AST_REAL}.  This method lets you tell
   * the parser which behavior to use&mdash;either collapse minuses or
   * always preserve them.  The two possibilities are represented using the
   * following constants:
   <p>
   * <ul>
   * <li> {@link  libsbmlConstants#L3P_COLLAPSE_UNARY_MINUS
   * L3P_COLLAPSE_UNARY_MINUS} (value = <code>true</code>): collapse unary
   * minuses where possible.
   * <li> {@link  libsbmlConstants#L3P_EXPAND_UNARY_MINUS
   * L3P_EXPAND_UNARY_MINUS} (value = <code>false</code>): do not collapse
   * unary minuses, and instead translate each one into an AST node of type
   * {@link  libsbmlConstants#AST_MINUS AST_MINUS}.
   *
   * </ul> <p>
   * @return A boolean, one of {@link 
   * libsbmlConstants#L3P_COLLAPSE_UNARY_MINUS
   * L3P_COLLAPSE_UNARY_MINUS} or {@link 
   * libsbmlConstants#L3P_EXPAND_UNARY_MINUS L3P_EXPAND_UNARY_MINUS}.
   <p>
   * @see #setParseCollapseMinus(boolean collapseminus)
   */ public
 boolean getParseCollapseMinus() {
    return libsbmlJNI.L3ParserSettings_getParseCollapseMinus(swigCPtr, this);
  }

  
/**
   * Sets the parser's behavior in handling units associated with numbers
   * in a mathematical formula.
   <p>
   * In SBML Level&nbsp;2, there is no means of associating a unit of
   * measurement with a pure number in a formula, while SBML Level&nbsp;3
   * does define a syntax for this.  In Level&nbsp;3, MathML
   * <code>&lt;cn&gt;</code> elements can have an attribute named <code>units</code>
   * placed in the SBML namespace, which can be used to indicate the units
   * to be associated with the number.  The text-string infix formula
   * parser allows units to be placed after raw numbers; they are
   * interpreted as unit identifiers for units defined by the SBML
   * specification or in the containing {@link Model} object.  Some examples
   * include: &quot;<code>4 mL</code>&quot;, &quot;<code>2.01
   * Hz</code>&quot;, &quot;<code>3.1e-6 M</code>&quot;, and
   * &quot;<code>(5/8) inches</code>&quot;.  To produce a valid SBML model,
   * there must either exist a {@link UnitDefinition} corresponding to the
   * identifier of the unit, or the unit must be defined in Table&nbsp;2 of
   * the SBML specification.
   <p>
   * @param units A boolean indicating whether to parse units:
   * <ul>
   * <li> {@link  libsbmlConstants#L3P_PARSE_UNITS L3P_PARSE_UNITS}
   * (value = <code>true</code>): parse units in the text-string formula.
   * <li> {@link  libsbmlConstants#L3P_NO_UNITS L3P_NO_UNITS} (value = 
   * <code>false</code>): treat units in the text-string formula as errors.
   *
   * </ul> <p>
   * @see #getParseUnits()
   */ public
 void setParseUnits(boolean units) {
    libsbmlJNI.L3ParserSettings_setParseUnits(swigCPtr, this, units);
  }

  
/**
   * Returns <code>if</code> the current settings allow units in text-string
   * mathematical formulas.
   <p>
   * In SBML Level&nbsp;2, there is no means of associating a unit of
   * measurement with a pure number in a formula, while SBML Level&nbsp;3
   * does define a syntax for this.  In Level&nbsp;3, MathML
   * <code>&lt;cn&gt;</code> elements can have an attribute named <code>units</code>
   * placed in the SBML namespace, which can be used to indicate the units
   * to be associated with the number.  The text-string infix formula
   * parser allows units to be placed after raw numbers; they are
   * interpreted as unit identifiers for units defined by the SBML
   * specification or in the containing {@link Model} object.  Some examples
   * include: &quot;<code>4 mL</code>&quot;, &quot;<code>2.01
   * Hz</code>&quot;, &quot;<code>3.1e-6 M</code>&quot;, and
   * &quot;<code>(5/8) inches</code>&quot;.  To produce a valid SBML model,
   * there must either exist a {@link UnitDefinition} corresponding to the
   * identifier of the unit, or the unit must be defined in Table&nbsp;2 of
   * the SBML specification.
   <p>
   * Since SBML Level&nbsp;2 does not have the ability to associate units with
   * pure numbers, the value should be set to <code>false</code> when parsing text-string
   * formulas intended for use in SBML Level&nbsp;2 documents.
   <p>
   * @return A boolean indicating whether to parse units:
   * <ul>
   * <li> {@link  libsbmlConstants#L3P_PARSE_UNITS L3P_PARSE_UNITS}
   * (value = <code>true</code>): parse units in the text-string formula.
   * <li> {@link  libsbmlConstants#L3P_NO_UNITS L3P_NO_UNITS} (value = 
   * <code>false</code>): treat units in the text-string formula as errors.
   *
   * </ul> <p>
   * @see #setParseUnits(boolean units)
   */ public
 boolean getParseUnits() {
    return libsbmlJNI.L3ParserSettings_getParseUnits(swigCPtr, this);
  }

  
/**
   * Sets the parser's behavior in handling the string <code>avogadro</code> in
   * mathematical formulas.
   <p>
   * SBML Level&nbsp;3 defines a symbol for representing the value of
   * Avogadro's constant, but it is not defined in SBML Level&nbsp;2.  As a
   * result, the text-string formula parser must behave differently
   * depending on which SBML Level is being targeted.  The argument to this
   * method can be one of two values:
   <p>
   * <ul>
   * <li> {@link  libsbmlConstants#L3P_AVOGADRO_IS_CSYMBOL
   * L3P_AVOGADRO_IS_CSYMBOL} (value = <code>true</code>): tells the parser to
   * translate the string <code>avogadro</code> (in any capitalization) into an AST
   * node of type {@link  libsbmlConstants#AST_NAME_AVOGADRO
   * AST_NAME_AVOGADRO}.
   * <li> {@link  libsbmlConstants#L3P_AVOGADRO_IS_NAME
   * L3P_AVOGADRO_IS_NAME} (value = <code>false</code>): tells the parser to
   * translate the string <code>avogadro</code> into an AST of type {@link 
   * libsbmlConstants#AST_NAME AST_NAME}.
   *
   * </ul> <p>
   * Since SBML Level&nbsp;2 does not define a symbol for Avogadro's
   * constant, the value should be set to <code>false</code> when parsing text-string
   * formulas intended for use in SBML Level&nbsp;2 documents.
   <p>
   * @param l2only a boolean value (one of the constants
   * {@link  libsbmlConstants#L3P_AVOGADRO_IS_CSYMBOL
   * L3P_AVOGADRO_IS_CSYMBOL} or
   * {@link  libsbmlConstants#L3P_AVOGADRO_IS_NAME
   * L3P_AVOGADRO_IS_NAME}) indicating how the string <code>avogadro</code>
   * should be treated when encountered in a formula.
   <p>
   * @see #getParseAvogadroCsymbol()
   */ public
 void setParseAvogadroCsymbol(boolean l2only) {
    libsbmlJNI.L3ParserSettings_setParseAvogadroCsymbol(swigCPtr, this, l2only);
  }

  
/**
   * Returns <code>true</code> if the current settings are oriented towards handling
   * <code>avogadro</code> for SBML Level&nbsp;3.
   <p>
   * SBML Level&nbsp;3 defines a symbol for representing the value of
   * Avogadro's constant, but it is not defined in SBML Level&nbsp;2.  As a
   * result, the text-string formula parser must behave differently
   * depending on which SBML Level is being targeted.
   <p>
   * @return A boolean indicating which mode is currently set; the value is
   * one of the following possibilities:
   * <ul>
   * <li> {@link  libsbmlConstants#L3P_AVOGADRO_IS_CSYMBOL
   * L3P_AVOGADRO_IS_CSYMBOL} (value = <code>true</code>): tells the parser to
   * translate the string <code>avogadro</code> (in any capitalization) into an AST
   * node of type {@link  libsbmlConstants#AST_NAME_AVOGADRO
   * AST_NAME_AVOGADRO}.
   * <li> {@link  libsbmlConstants#L3P_AVOGADRO_IS_NAME
   * L3P_AVOGADRO_IS_NAME} (value = <code>false</code>): tells the parser to
   * translate the string <code>avogadro</code> into an AST of type {@link 
   * libsbmlConstants#AST_NAME AST_NAME}.
   *
   * </ul> <p>
   * @see #setParseAvogadroCsymbol(boolean l2only)
   */ public
 boolean getParseAvogadroCsymbol() {
    return libsbmlJNI.L3ParserSettings_getParseAvogadroCsymbol(swigCPtr, this);
  }

}
