#
# @file    TestL3FormulaParserC.py
# @brief   L3FormulaParser unit tests
#
# @author  Akiya Jouraku (Python conversion)
# @author  Ben Bornstein
 
# 
# ====== WARNING ===== WARNING ===== WARNING ===== WARNING ===== WARNING ======
#
# DO NOT EDIT THIS FILE.
#
# This file was generated automatically by converting the file located at
# src/sbml/test/TestL3FormulaParserC.c
# using the conversion program dev/utilities/translateTests/translateTests.pl.
# Any changes made here will be lost the next time the file is regenerated.
#
# -----------------------------------------------------------------------------
# This file is part of libSBML.  Please visit http://sbml.org for more
# information about SBML, and the latest version of libSBML.
#
# Copyright 2005-2010 California Institute of Technology.
# Copyright 2002-2005 California Institute of Technology and
#                     Japan Science and Technology Corporation.
# 
# This library is free software; you can redistribute it and/or modify it
# under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation.  A copy of the license agreement is provided
# in the file named "LICENSE.txt" included with this software distribution
# and also available online as http://sbml.org/software/libsbml/license.html
# -----------------------------------------------------------------------------

import sys
import math
import unittest
import libsbml

def isnan(x):
  return (x != x)
  pass

def util_isInf(*x):
  return ( (x[0] == util_PosInf()) or  (x[0] == util_NegInf()) )

def util_NaN():
  z = 1e300
  z = z * z

  return z - z

def util_PosInf():
  z = 1e300
  z = z * z

  return z

def util_NegInf():
  z = 1e300
  z = z * z

  return -z 

class TestL3FormulaParserC(unittest.TestCase):

  def test_SBML_C_parseL3Formula_1(self):
    r = libsbml.parseL3Formula("1")
    self.assert_( r.getType() == libsbml.AST_INTEGER )
    self.assert_( r.getInteger() == 1 )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_10(self):
    r = libsbml.parseL3Formula("1 + -2e100 / 3")
    self.assert_( r.getType() == libsbml.AST_PLUS )
    self.assert_( r.getCharacter() == '+' )
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 1 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_DIVIDE )
    self.assert_( c.getCharacter() == '/' )
    self.assert_( c.getNumChildren() == 2 )
    c = c.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_MINUS )
    self.assert_( c.getCharacter() == '-' )
    self.assert_( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_REAL_E )
    self.assert_( c.getMantissa() == 2 )
    self.assert_( c.getExponent() == 100 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild().getRightChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 3 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_11(self):
    r = libsbml.parseL3Formula("1 - -foo / 3")
    self.assert_( r.getType() == libsbml.AST_MINUS )
    self.assert_( r.getCharacter() == '-' )
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 1 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_DIVIDE )
    self.assert_( c.getCharacter() == '/' )
    self.assert_( c.getNumChildren() == 2 )
    c = r.getRightChild().getLeftChild()
    self.assert_( c.getType() == libsbml.AST_MINUS )
    self.assert_( c.getCharacter() == '-' )
    self.assert_( c.getNumChildren() == 1 )
    c = r.getRightChild().getLeftChild().getLeftChild()
    self.assert_( c.getType() == libsbml.AST_NAME )
    self.assert_((  "foo" == c.getName() ))
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild().getRightChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 3 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_12(self):
    r = libsbml.parseL3Formula("2 * foo^bar + 3.0")
    self.assert_( r.getType() == libsbml.AST_PLUS )
    self.assert_( r.getCharacter() == '+' )
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_TIMES )
    self.assert_( c.getCharacter() == '*' )
    self.assert_( c.getNumChildren() == 2 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_REAL )
    self.assert_( c.getReal() == 3.0 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getLeftChild().getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 2 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getLeftChild().getRightChild()
    self.assert_( c.getType() == libsbml.AST_POWER )
    self.assert_( c.getCharacter() == '^' )
    self.assert_( c.getNumChildren() == 2 )
    c = r.getLeftChild().getRightChild().getLeftChild()
    self.assert_( c.getType() == libsbml.AST_NAME )
    self.assert_((  "foo" == c.getName() ))
    self.assert_( c.getNumChildren() == 0 )
    c = r.getLeftChild().getRightChild().getRightChild()
    self.assert_( c.getType() == libsbml.AST_NAME )
    self.assert_((  "bar" == c.getName() ))
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_13(self):
    r = libsbml.parseL3Formula("foo()")
    self.assert_( r.getType() == libsbml.AST_FUNCTION )
    self.assert_((  "foo" == r.getName() ))
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_14(self):
    r = libsbml.parseL3Formula("foo(1)")
    self.assert_( r.getType() == libsbml.AST_FUNCTION )
    self.assert_((  "foo" == r.getName() ))
    self.assert_( r.getNumChildren() == 1 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 1 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_15(self):
    r = libsbml.parseL3Formula("foo(1, bar)")
    self.assert_( r.getType() == libsbml.AST_FUNCTION )
    self.assert_((  "foo" == r.getName() ))
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 1 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_NAME )
    self.assert_((  "bar" == c.getName() ))
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_16(self):
    r = libsbml.parseL3Formula("foo(1, bar, 2^-3)")
    self.assert_( r.getType() == libsbml.AST_FUNCTION )
    self.assert_((  "foo" == r.getName() ))
    self.assert_( r.getNumChildren() == 3 )
    c = r.getChild(0)
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 1 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getChild(1)
    self.assert_( c.getType() == libsbml.AST_NAME )
    self.assert_((  "bar" == c.getName() ))
    self.assert_( c.getNumChildren() == 0 )
    c = r.getChild(2)
    self.assert_( c.getType() == libsbml.AST_POWER )
    self.assert_( c.getCharacter() == '^' )
    self.assert_( c.getNumChildren() == 2 )
    c = r.getChild(2).getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 2 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getChild(2).getRightChild()
    self.assert_( c.getType() == libsbml.AST_MINUS )
    self.assert_( c.getCharacter() == '-' )
    self.assert_( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 3 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_17(self):
    r = libsbml.parseL3Formula("1//1")
    self.assert_( r == None )
    self.assert_((  "Error when parsing input '1//1' at position 3:  syntax error, unexpected '/'" == libsbml.getLastParseL3Error() ))
    pass  

  def test_SBML_C_parseL3Formula_18(self):
    r = libsbml.parseL3Formula("1+2*3 4")
    self.assert_( r == None )
    self.assert_((  "Error when parsing input '1+2*3 4' at position 7:  syntax error, unexpected integer" == libsbml.getLastParseL3Error() ))
    pass  

  def test_SBML_C_parseL3Formula_2(self):
    r = libsbml.parseL3Formula("2.1")
    self.assert_( r.getType() == libsbml.AST_REAL )
    self.assert_( r.getReal() == 2.1 )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_3(self):
    r = libsbml.parseL3Formula("2.1e5")
    self.assert_( r.getType() == libsbml.AST_REAL_E )
    self.assert_( r.getMantissa() == 2.1 )
    self.assert_( r.getExponent() == 5 )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_4(self):
    r = libsbml.parseL3Formula("foo")
    self.assert_( r.getType() == libsbml.AST_NAME )
    self.assert_((  "foo" == r.getName() ))
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_5(self):
    r = libsbml.parseL3Formula("1 + foo")
    self.assert_( r.getType() == libsbml.AST_PLUS )
    self.assert_( r.getCharacter() == '+' )
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 1 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_NAME )
    self.assert_((  "foo" == c.getName() ))
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_6(self):
    r = libsbml.parseL3Formula("1 + 2")
    self.assert_( r.getType() == libsbml.AST_PLUS )
    self.assert_( r.getCharacter() == '+' )
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 1 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 2 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_7(self):
    r = libsbml.parseL3Formula("1 + 2 * 3")
    self.assert_( r.getType() == libsbml.AST_PLUS )
    self.assert_( r.getCharacter() == '+' )
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 1 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_TIMES )
    self.assert_( c.getCharacter() == '*' )
    self.assert_( c.getNumChildren() == 2 )
    c = c.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 2 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild().getRightChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 3 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_8(self):
    r = libsbml.parseL3Formula("(1 - 2) * 3")
    self.assert_( r.getType() == libsbml.AST_TIMES )
    self.assert_( r.getCharacter() == '*' )
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_MINUS )
    self.assert_( c.getCharacter() == '-' )
    self.assert_( c.getNumChildren() == 2 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 3 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getLeftChild().getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 1 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getLeftChild().getRightChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 2 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_9(self):
    r = libsbml.parseL3Formula("1 + -2 / 3")
    self.assert_( r.getType() == libsbml.AST_PLUS )
    self.assert_( r.getCharacter() == '+' )
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 1 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_DIVIDE )
    self.assert_( c.getCharacter() == '/' )
    self.assert_( c.getNumChildren() == 2 )
    c = c.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_MINUS )
    self.assert_( c.getCharacter() == '-' )
    self.assert_( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 2 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild().getRightChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 3 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_arguments(self):
    r = libsbml.parseL3Formula("sin(x,y)")
    self.assert_( r == None )
    self.assert_((  "Error when parsing input 'sin(x,y)' at position 8:  The function 'sin' takes exactly one argument, but 2 were found." == libsbml.getLastParseL3Error() ))
    r = libsbml.parseL3Formula("delay(x)")
    self.assert_( r == None )
    self.assert_((  "Error when parsing input 'delay(x)' at position 8:  The function 'delay' takes exactly two arguments, but 1 were found." == libsbml.getLastParseL3Error() ))
    r = libsbml.parseL3Formula("piecewise()")
    self.assert_( r == None )
    self.assert_((  "Error when parsing input 'piecewise()' at position 11:  The function 'piecewise' takes at least one argument, but none were found." == libsbml.getLastParseL3Error() ))
    r = libsbml.parseL3Formula("gt(x)")
    self.assert_( r == None )
    self.assert_((  "Error when parsing input 'gt(x)' at position 5:  The function 'gt' takes at least two arguments, but 1 were found." == libsbml.getLastParseL3Error() ))
    r = libsbml.parseL3Formula("minus()")
    self.assert_( r == None )
    self.assert_((  "Error when parsing input 'minus()' at position 7:  The function 'minus' takes exactly one or two arguments, but 0 were found." == libsbml.getLastParseL3Error() ))
    r = libsbml.parseL3Formula("root(x, y, z)")
    self.assert_( r == None )
    self.assert_((  "Error when parsing input 'root(x, y, z)' at position 13:  The function 'root' takes exactly one or two arguments, but 3 were found." == libsbml.getLastParseL3Error() ))
    r = libsbml.parseL3Formula("power()")
    self.assert_( r == None )
    self.assert_((  "Error when parsing input 'power()' at position 7:  The function 'power' takes exactly two arguments, but 0 were found." == libsbml.getLastParseL3Error() ))
    pass  

  def test_SBML_C_parseL3Formula_avogadrosettings(self):
    r = libsbml.parseL3Formula("avogadro")
    self.assert_( r.getType() == libsbml.AST_NAME_AVOGADRO )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    settings = libsbml.getDefaultL3ParserSettings()
    settings.setParseAvogadroCsymbol(0)
    self.assert_( settings.getParseAvogadroCsymbol() == 0 )
    r = libsbml.parseL3FormulaWithSettings("avogadro", settings)
    self.assert_( r.getType() == libsbml.AST_NAME )
    self.assert_((  "avogadro" == r.getName() ))
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    settings.setParseAvogadroCsymbol(1)
    self.assert_( settings.getParseAvogadroCsymbol() == 1 )
    r = libsbml.parseL3FormulaWithSettings("avogadro", settings)
    self.assert_( r.getType() == libsbml.AST_NAME_AVOGADRO )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    _dummyList = [ settings ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_collapseminussettings1(self):
    r = libsbml.parseL3Formula("--4.4")
    self.assert_( r.getType() == libsbml.AST_MINUS )
    self.assert_( r.getNumChildren() == 1 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_MINUS )
    self.assert_( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_REAL )
    self.assert_( c.getReal() == 4.4 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    settings = libsbml.getDefaultL3ParserSettings()
    settings.setParseCollapseMinus(1)
    self.assert_( settings.getParseCollapseMinus() == 1 )
    r = libsbml.parseL3FormulaWithSettings("--4.4", settings)
    self.assert_( r.getType() == libsbml.AST_REAL )
    self.assert_( r.getReal() == 4.4 )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    settings.setParseCollapseMinus(0)
    self.assert_( settings.getParseCollapseMinus() == 0 )
    r = libsbml.parseL3FormulaWithSettings("--4.4", settings)
    self.assert_( r.getType() == libsbml.AST_MINUS )
    self.assert_( r.getNumChildren() == 1 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_MINUS )
    self.assert_( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_REAL )
    self.assert_( c.getReal() == 4.4 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    _dummyList = [ settings ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_collapseminussettings2(self):
    r = libsbml.parseL3Formula("--x")
    self.assert_( r.getType() == libsbml.AST_MINUS )
    self.assert_( r.getNumChildren() == 1 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_MINUS )
    self.assert_( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_NAME )
    self.assert_((  "x" == c.getName() ))
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    settings = libsbml.getDefaultL3ParserSettings()
    settings.setParseCollapseMinus(1)
    self.assert_( settings.getParseCollapseMinus() == 1 )
    r = libsbml.parseL3FormulaWithSettings("--x", settings)
    self.assert_( r.getType() == libsbml.AST_NAME )
    self.assert_((  "x" == r.getName() ))
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    settings.setParseCollapseMinus(0)
    self.assert_( settings.getParseCollapseMinus() == 0 )
    r = libsbml.parseL3FormulaWithSettings("--x", settings)
    self.assert_( r.getType() == libsbml.AST_MINUS )
    self.assert_( r.getNumChildren() == 1 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_MINUS )
    self.assert_( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_NAME )
    self.assert_((  "x" == c.getName() ))
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    _dummyList = [ settings ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_collapseminussettings3(self):
    r = libsbml.parseL3Formula("x---4.4")
    self.assert_( r.getType() == libsbml.AST_MINUS )
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_NAME )
    self.assert_((  "x" == c.getName() ))
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_MINUS )
    self.assert_( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_MINUS )
    self.assert_( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_REAL )
    self.assert_( c.getReal() == 4.4 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    settings = libsbml.getDefaultL3ParserSettings()
    settings.setParseCollapseMinus(1)
    self.assert_( settings.getParseCollapseMinus() == 1 )
    r = libsbml.parseL3FormulaWithSettings("x---4.4", settings)
    self.assert_( r.getType() == libsbml.AST_MINUS )
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_NAME )
    self.assert_((  "x" == c.getName() ))
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_REAL )
    self.assert_( c.getReal() == 4.4 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    settings.setParseCollapseMinus(0)
    self.assert_( settings.getParseCollapseMinus() == 0 )
    r = libsbml.parseL3FormulaWithSettings("x---4.4", settings)
    self.assert_( r.getType() == libsbml.AST_MINUS )
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_NAME )
    self.assert_((  "x" == c.getName() ))
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_MINUS )
    self.assert_( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_MINUS )
    self.assert_( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_REAL )
    self.assert_( c.getReal() == 4.4 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    _dummyList = [ settings ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_collapseminussettings4(self):
    r = libsbml.parseL3Formula("x---y")
    self.assert_( r.getType() == libsbml.AST_MINUS )
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_NAME )
    self.assert_((  "x" == c.getName() ))
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_MINUS )
    self.assert_( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_MINUS )
    self.assert_( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_NAME )
    self.assert_((  "y" == c.getName() ))
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    settings = libsbml.getDefaultL3ParserSettings()
    settings.setParseCollapseMinus(1)
    self.assert_( settings.getParseCollapseMinus() == 1 )
    r = libsbml.parseL3FormulaWithSettings("x---y", settings)
    self.assert_( r.getType() == libsbml.AST_MINUS )
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_NAME )
    self.assert_((  "x" == c.getName() ))
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_NAME )
    self.assert_((  "y" == c.getName() ))
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    settings.setParseCollapseMinus(0)
    self.assert_( settings.getParseCollapseMinus() == 0 )
    r = libsbml.parseL3FormulaWithSettings("x---y", settings)
    self.assert_( r.getType() == libsbml.AST_MINUS )
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_NAME )
    self.assert_((  "x" == c.getName() ))
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_MINUS )
    self.assert_( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_MINUS )
    self.assert_( c.getNumChildren() == 1 )
    c = c.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_NAME )
    self.assert_((  "y" == c.getName() ))
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    _dummyList = [ settings ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_collapseminussettings5(self):
    settings = libsbml.getDefaultL3ParserSettings()
    settings.setParseCollapseMinus(1)
    self.assert_( settings.getParseCollapseMinus() == 1 )
    r = libsbml.parseL3FormulaWithSettings("---4", settings)
    self.assert_( r.getType() == libsbml.AST_INTEGER )
    self.assert_( r.getInteger() == -4 )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    r = libsbml.parseL3FormulaWithSettings("---(3/8)", settings)
    self.assert_( r.getType() == libsbml.AST_RATIONAL )
    self.assert_( r.getNumerator() == -3 )
    self.assert_( r.getDenominator() == 8 )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    r = libsbml.parseL3FormulaWithSettings("---(-3/8)", settings)
    self.assert_( r.getType() == libsbml.AST_RATIONAL )
    self.assert_( r.getNumerator() == 3 )
    self.assert_( r.getDenominator() == 8 )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    r = libsbml.parseL3FormulaWithSettings("---4.4", settings)
    self.assert_( r.getType() == libsbml.AST_REAL )
    self.assert_( r.getReal() == -4.4 )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    r = libsbml.parseL3FormulaWithSettings("---4e-3", settings)
    self.assert_( r.getType() == libsbml.AST_REAL_E )
    self.assert_( r.getMantissa() == -4 )
    self.assert_( r.getExponent() == -3 )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    r = libsbml.parseL3FormulaWithSettings("---.4", settings)
    self.assert_( r.getType() == libsbml.AST_REAL )
    self.assert_( r.getReal() == -.4 )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    _dummyList = [ settings ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_constants1(self):
    r = libsbml.parseL3Formula("true")
    self.assert_( r.getType() == libsbml.AST_CONSTANT_TRUE )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_constants10(self):
    r = libsbml.parseL3Formula("notanumber")
    self.assert_( r.getType() == libsbml.AST_REAL )
    self.assert_( isnan(r.getReal()) == 1 )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_constants11(self):
    r = libsbml.parseL3Formula("nan")
    self.assert_( r.getType() == libsbml.AST_REAL )
    self.assert_( isnan(r.getReal()) == 1 )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_constants12(self):
    r = libsbml.parseL3Formula("NaN")
    self.assert_( r.getType() == libsbml.AST_REAL )
    self.assert_( isnan(r.getReal()) == 1 )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_constants2(self):
    r = libsbml.parseL3Formula("false")
    self.assert_( r.getType() == libsbml.AST_CONSTANT_FALSE )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_constants3(self):
    r = libsbml.parseL3Formula("pi")
    self.assert_( r.getType() == libsbml.AST_CONSTANT_PI )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_constants4(self):
    r = libsbml.parseL3Formula("exponentiale")
    self.assert_( r.getType() == libsbml.AST_CONSTANT_E )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_constants5(self):
    r = libsbml.parseL3Formula("avogadro")
    self.assert_( r.getType() == libsbml.AST_NAME_AVOGADRO )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_constants6(self):
    r = libsbml.parseL3Formula("time")
    self.assert_( r.getType() == libsbml.AST_NAME_TIME )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_constants7(self):
    r = libsbml.parseL3Formula("inf")
    self.assert_( r.getType() == libsbml.AST_REAL )
    self.assert_( util_isInf(r.getReal()) == True )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_constants8(self):
    r = libsbml.parseL3Formula("infinity")
    self.assert_( r.getType() == libsbml.AST_REAL )
    self.assert_( util_isInf(r.getReal()) == True )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_constants9(self):
    r = libsbml.parseL3Formula("INF")
    self.assert_( r.getType() == libsbml.AST_REAL )
    self.assert_( util_isInf(r.getReal()) == True )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_e1(self):
    r = libsbml.parseL3Formula("2.001e+5")
    self.assert_( r.getType() == libsbml.AST_REAL_E )
    self.assert_( r.getMantissa() == 2.001 )
    self.assert_( r.getExponent() == 5 )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_e2(self):
    r = libsbml.parseL3Formula(".001e+5")
    self.assert_( r.getType() == libsbml.AST_REAL_E )
    self.assert_( r.getMantissa() == .001 )
    self.assert_( r.getExponent() == 5 )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_e3(self):
    r = libsbml.parseL3Formula(".001e-5")
    self.assert_( r.getType() == libsbml.AST_REAL_E )
    self.assert_( r.getMantissa() == .001 )
    self.assert_( r.getExponent() == -5 )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_e4(self):
    r = libsbml.parseL3Formula("2.e-005")
    self.assert_( r.getType() == libsbml.AST_REAL_E )
    self.assert_( r.getMantissa() == 2 )
    self.assert_( r.getExponent() == -5 )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_e5(self):
    r = libsbml.parseL3Formula(".e+5")
    self.assert_( r == None )
    self.assert_((  "Error when parsing input '.e+5' at position 1:  syntax error, unexpected $undefined" == libsbml.getLastParseL3Error() ))
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_logic1(self):
    r = libsbml.parseL3Formula("1 && 2 == 3")
    self.assert_( r.getType() == libsbml.AST_LOGICAL_AND )
    self.assert_((  "and" == r.getName() ))
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 1 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_RELATIONAL_EQ )
    self.assert_((  "eq" == c.getName() ))
    self.assert_( c.getNumChildren() == 2 )
    c = c.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 2 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild().getRightChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 3 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_logic2(self):
    r = libsbml.parseL3Formula("(1 && 2) == 3")
    self.assert_( r.getType() == libsbml.AST_RELATIONAL_EQ )
    self.assert_((  "eq" == r.getName() ))
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_LOGICAL_AND )
    self.assert_((  "and" == c.getName() ))
    self.assert_( c.getNumChildren() == 2 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 3 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getLeftChild().getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 1 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getLeftChild().getRightChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 2 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_modelPresent1(self):
    model = libsbml.Model(3,1)
    p = model.createParameter()
    p.setId( "infinity")
    r = libsbml.parseL3FormulaWithModel("infinity", model)
    self.assert_( r.getType() == libsbml.AST_NAME )
    self.assert_((  "infinity" == r.getName() ))
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_modelPresent2(self):
    model = libsbml.Model(3,1)
    p = model.createSpecies()
    p.setId( "true")
    r = libsbml.parseL3FormulaWithModel("true", model)
    self.assert_( r.getType() == libsbml.AST_NAME )
    self.assert_((  "true" == r.getName() ))
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_modelPresent3(self):
    model = libsbml.Model(3,1)
    p = model.createCompartment()
    p.setId( "NaN")
    r = libsbml.parseL3FormulaWithModel("NaN", model)
    self.assert_( r.getType() == libsbml.AST_NAME )
    self.assert_((  "NaN" == r.getName() ))
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_modelPresent4(self):
    model = libsbml.Model(3,1)
    p = model.createReaction()
    p.setId( "pi")
    r = libsbml.parseL3FormulaWithModel("pi", model)
    self.assert_( r.getType() == libsbml.AST_NAME )
    self.assert_((  "pi" == r.getName() ))
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_modelPresent5(self):
    model = libsbml.Model(3,1)
    p = model.createReaction()
    sr = p.createProduct()
    sr.setId( "avogadro")
    r = libsbml.parseL3FormulaWithModel("avogadro", model)
    self.assert_( r.getType() == libsbml.AST_NAME )
    self.assert_((  "avogadro" == r.getName() ))
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_modelPresent6(self):
    model = libsbml.Model(3,1)
    p = model.createReaction()
    sr = p.createProduct()
    sr.setId( "AVOGADRO")
    r = libsbml.parseL3FormulaWithModel("avogadro", model)
    self.assert_( r.getType() == libsbml.AST_NAME_AVOGADRO )
    self.assert_((  "avogadro" == r.getName() ))
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_modelPresent7(self):
    model = libsbml.Model(3,1)
    p = model.createFunctionDefinition()
    p.setId( "sin")
    r = libsbml.parseL3FormulaWithModel("sin(x, y)", model)
    self.assert_( r.getType() == libsbml.AST_FUNCTION )
    self.assert_((  "sin" == r.getName() ))
    self.assert_( r.getNumChildren() == 2 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_modulo(self):
    r = libsbml.parseL3Formula("x % y")
    self.assert_((  "piecewise(x - y * ceil(x / y), xor(lt(x, 0), lt(y, 0)), x - y * floor(x / y))" == libsbml.formulaToString(r) ))
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_negInf(self):
    r = libsbml.parseL3Formula("-inf")
    self.assert_( r.getType() == libsbml.AST_MINUS )
    self.assert_( r.getCharacter() == '-' )
    self.assert_( r.getNumChildren() == 1 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_REAL )
    self.assert_( util_isInf(c.getReal()) == True )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_negZero(self):
    r = libsbml.parseL3Formula("-0.0")
    self.assert_( r.getType() == libsbml.AST_MINUS )
    self.assert_( r.getCharacter() == '-' )
    self.assert_( r.getNumChildren() == 1 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_REAL )
    self.assert_( c.getReal() == 0 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_oddMathML1(self):
    r = libsbml.parseL3Formula("sqrt(3)")
    self.assert_( r.getType() == libsbml.AST_FUNCTION_ROOT )
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 2 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 3 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_oddMathML2(self):
    r = libsbml.parseL3Formula("sqr(3)")
    self.assert_( r.getType() == libsbml.AST_FUNCTION_POWER )
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 3 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 2 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_oddMathML3(self):
    r = libsbml.parseL3Formula("log10(3)")
    self.assert_( r.getType() == libsbml.AST_FUNCTION_LOG )
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 10 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 3 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_oddMathML4(self):
    r = libsbml.parseL3Formula("log(4.4, 3)")
    self.assert_( r.getType() == libsbml.AST_FUNCTION_LOG )
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_REAL )
    self.assert_( c.getReal() == 4.4 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 3 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_oddMathML5(self):
    r = libsbml.parseL3Formula("root(1.1, 3)")
    self.assert_( r.getType() == libsbml.AST_FUNCTION_ROOT )
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_REAL )
    self.assert_( c.getReal() == 1.1 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 3 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_parselogsettings(self):
    r = libsbml.parseL3Formula("log(4.4)")
    self.assert_( r.getType() == libsbml.AST_FUNCTION_LOG )
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 10 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_REAL )
    self.assert_( c.getReal() == 4.4 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    settings = libsbml.L3ParserSettings()
    settings.setParseLog(libsbml.L3P_PARSE_LOG_AS_LN)
    self.assert_( settings.getParseLog() == libsbml.L3P_PARSE_LOG_AS_LN )
    r = libsbml.parseL3FormulaWithSettings("log(4.4)", settings)
    self.assert_( r.getType() == libsbml.AST_FUNCTION_LN )
    self.assert_( r.getNumChildren() == 1 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_REAL )
    self.assert_( c.getReal() == 4.4 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    settings.setParseLog(libsbml.L3P_PARSE_LOG_AS_LOG10)
    self.assert_( settings.getParseLog() == libsbml.L3P_PARSE_LOG_AS_LOG10 )
    r = libsbml.parseL3FormulaWithSettings("log(4.4)", settings)
    self.assert_( r.getType() == libsbml.AST_FUNCTION_LOG )
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 10 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_REAL )
    self.assert_( c.getReal() == 4.4 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    settings.setParseLog(libsbml.L3P_PARSE_LOG_AS_ERROR)
    self.assert_( settings.getParseLog() == libsbml.L3P_PARSE_LOG_AS_ERROR )
    r = libsbml.parseL3FormulaWithSettings("log(4.4)", settings)
    self.assert_( r == None )
    self.assert_((  "Error when parsing input 'log(4.4)' at position 8:  Writing a function as 'log(x)' was legal in the L1 parser, but translated as the natural log, not the base-10 log.  This construct is disallowed entirely as being ambiguous, and you are encouraged instead to use 'ln(x)', 'log10(x)', or 'log(base, x)'." == libsbml.getLastParseL3Error() ))
    _dummyList = [ settings ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_precedence(self):
    root = libsbml.parseL3Formula("a && b == !(c - d * e^-f) ")
    self.assert_( root.getType() == libsbml.AST_LOGICAL_AND )
    self.assert_((  "and" == root.getName() ))
    self.assert_( root.getNumChildren() == 2 )
    left = root.getLeftChild()
    self.assert_( left.getType() == libsbml.AST_NAME )
    self.assert_((  "a" == left.getName() ))
    self.assert_( left.getNumChildren() == 0 )
    right = root.getRightChild()
    self.assert_( right.getType() == libsbml.AST_RELATIONAL_EQ )
    self.assert_((  "eq" == right.getName() ))
    self.assert_( right.getNumChildren() == 2 )
    left = right.getLeftChild()
    self.assert_( left.getType() == libsbml.AST_NAME )
    self.assert_((  "b" == left.getName() ))
    self.assert_( left.getNumChildren() == 0 )
    right = right.getRightChild()
    self.assert_( right.getType() == libsbml.AST_LOGICAL_NOT )
    self.assert_((  "not" == right.getName() ))
    self.assert_( right.getNumChildren() == 1 )
    right = right.getLeftChild()
    self.assert_( right.getType() == libsbml.AST_MINUS )
    self.assert_( right.getCharacter() == '-' )
    self.assert_( right.getNumChildren() == 2 )
    left = right.getLeftChild()
    self.assert_( left.getType() == libsbml.AST_NAME )
    self.assert_((  "c" == left.getName() ))
    self.assert_( left.getNumChildren() == 0 )
    right = right.getRightChild()
    self.assert_( right.getType() == libsbml.AST_TIMES )
    self.assert_( right.getCharacter() == '*' )
    self.assert_( right.getNumChildren() == 2 )
    left = right.getLeftChild()
    self.assert_( left.getType() == libsbml.AST_NAME )
    self.assert_((  "d" == left.getName() ))
    self.assert_( left.getNumChildren() == 0 )
    right = right.getRightChild()
    self.assert_( right.getType() == libsbml.AST_POWER )
    self.assert_( right.getCharacter() == '^' )
    self.assert_( right.getNumChildren() == 2 )
    left = right.getLeftChild()
    self.assert_( left.getType() == libsbml.AST_NAME )
    self.assert_((  "e" == left.getName() ))
    self.assert_( left.getNumChildren() == 0 )
    right = right.getRightChild()
    self.assert_( right.getType() == libsbml.AST_MINUS )
    self.assert_( right.getCharacter() == '-' )
    self.assert_( right.getNumChildren() == 1 )
    left = right.getLeftChild()
    self.assert_( left.getType() == libsbml.AST_NAME )
    self.assert_((  "f" == left.getName() ))
    self.assert_( left.getNumChildren() == 0 )
    _dummyList = [ root ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_rational1(self):
    r = libsbml.parseL3Formula("(3/4)")
    self.assert_( r.getType() == libsbml.AST_RATIONAL )
    self.assert_( r.getNumerator() == 3 )
    self.assert_( r.getDenominator() == 4 )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_rational2(self):
    r = libsbml.parseL3Formula("(3/4) mL")
    self.assert_( r.getType() == libsbml.AST_RATIONAL )
    self.assert_( r.getNumerator() == 3 )
    self.assert_( r.getDenominator() == 4 )
    self.assert_((  "mL" == r.getUnits() ))
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_rational3(self):
    r = libsbml.parseL3Formula("3/4")
    self.assert_( r.getType() == libsbml.AST_DIVIDE )
    self.assert_( r.getCharacter() == '/' )
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 3 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 4 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_rational4(self):
    r = libsbml.parseL3Formula("(3/x)")
    self.assert_( r.getType() == libsbml.AST_DIVIDE )
    self.assert_( r.getCharacter() == '/' )
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 3 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_NAME )
    self.assert_((  "x" == c.getName() ))
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_rational5(self):
    r = libsbml.parseL3Formula("(3/4.4)")
    self.assert_( r.getType() == libsbml.AST_DIVIDE )
    self.assert_( r.getCharacter() == '/' )
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 3 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_REAL )
    self.assert_( c.getReal() == 4.4 )
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_rational6(self):
    r = libsbml.parseL3Formula("3/4 ml")
    self.assert_( r.getType() == libsbml.AST_DIVIDE )
    self.assert_( r.getCharacter() == '/' )
    self.assert_( r.getNumChildren() == 2 )
    c = r.getLeftChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 3 )
    self.assert_( c.getNumChildren() == 0 )
    c = r.getRightChild()
    self.assert_( c.getType() == libsbml.AST_INTEGER )
    self.assert_( c.getInteger() == 4 )
    self.assert_((  "ml" == c.getUnits() ))
    self.assert_( c.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_rational7(self):
    r = libsbml.parseL3Formula("(3/4.4) ml")
    self.assert_( r == None )
    self.assert_((  "Error when parsing input '(3/4.4) ml' at position 10:  syntax error, unexpected element name" == libsbml.getLastParseL3Error() ))
    pass  

  def test_SBML_C_parseL3Formula_targetl2settings(self):
    r = libsbml.parseL3Formula("4 mL")
    self.assert_( r.getType() == libsbml.AST_INTEGER )
    self.assert_( r.getInteger() == 4 )
    self.assert_((  "mL" == r.getUnits() ))
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    r = libsbml.parseL3Formula("avogadro")
    self.assert_( r.getType() == libsbml.AST_NAME_AVOGADRO )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    settings = libsbml.getDefaultL3ParserSettings()
    settings.setParseUnits(0)
    settings.setParseAvogadroCsymbol(0)
    self.assert_( settings.getParseUnits() == 0 )
    self.assert_( settings.getParseAvogadroCsymbol() == 0 )
    r = libsbml.parseL3FormulaWithSettings("4 mL", settings)
    self.assert_( r == None )
    self.assert_((  "Error when parsing input '4 mL' at position 4:  The ability to associate units with numbers has been disabled." == libsbml.getLastParseL3Error() ))
    r = libsbml.parseL3FormulaWithSettings("avogadro", settings)
    self.assert_( r.getType() == libsbml.AST_NAME )
    self.assert_((  "avogadro" == r.getName() ))
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    settings.setParseUnits(1)
    settings.setParseAvogadroCsymbol(1)
    self.assert_( settings.getParseUnits() == 1 )
    self.assert_( settings.getParseAvogadroCsymbol() == 1 )
    r = libsbml.parseL3FormulaWithSettings("4 mL", settings)
    self.assert_( r.getType() == libsbml.AST_INTEGER )
    self.assert_( r.getInteger() == 4 )
    self.assert_((  "mL" == r.getUnits() ))
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    r = libsbml.parseL3FormulaWithSettings("avogadro", settings)
    self.assert_( r.getType() == libsbml.AST_NAME_AVOGADRO )
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    _dummyList = [ settings ]; _dummyList[:] = []; del _dummyList
    pass  

  def test_SBML_C_parseL3Formula_unitssettings(self):
    r = libsbml.parseL3Formula("4 mL")
    self.assert_( r.getType() == libsbml.AST_INTEGER )
    self.assert_( r.getInteger() == 4 )
    self.assert_((  "mL" == r.getUnits() ))
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    settings = libsbml.getDefaultL3ParserSettings()
    settings.setParseUnits(0)
    self.assert_( settings.getParseUnits() == 0 )
    r = libsbml.parseL3FormulaWithSettings("4 mL", settings)
    self.assert_( r == None )
    self.assert_((  "Error when parsing input '4 mL' at position 4:  The ability to associate units with numbers has been disabled." == libsbml.getLastParseL3Error() ))
    settings.setParseUnits(1)
    self.assert_( settings.getParseUnits() == 1 )
    r = libsbml.parseL3FormulaWithSettings("4 mL", settings)
    self.assert_( r.getType() == libsbml.AST_INTEGER )
    self.assert_( r.getInteger() == 4 )
    self.assert_((  "mL" == r.getUnits() ))
    self.assert_( r.getNumChildren() == 0 )
    _dummyList = [ r ]; _dummyList[:] = []; del _dummyList
    _dummyList = [ settings ]; _dummyList[:] = []; del _dummyList
    pass  

def suite():
  suite = unittest.TestSuite()
  suite.addTest(unittest.makeSuite(TestL3FormulaParserC))

  return suite

if __name__ == "__main__":
  if unittest.TextTestRunner(verbosity=1).run(suite()).wasSuccessful() :
    sys.exit(0)
  else:
    sys.exit(1)
